/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.tick_ship_chunks;

import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap {
    @Shadow
    @Final
    ServerLevel f_140133_;

    @Inject(method={"euclideanDistanceSquared"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preDistanceToSqr(ChunkPos chunkPos, Entity entity, CallbackInfoReturnable<Double> cir) {
        double d2 = chunkPos.f_45578_ * 16 + 8;
        double e2 = chunkPos.f_45579_ * 16 + 8;
        double retValue = VSGameUtilsKt.squaredDistanceBetweenInclShips(entity.m_9236_(), entity.m_20185_(), 0.0, entity.m_20189_(), d2, 0.0, e2);
        cir.setReturnValue((Object)retValue);
    }

    @Inject(method={"anyPlayerCloseEnoughForSpawning"}, at={@At(value="RETURN")}, cancellable=true)
    void noPlayersCloseForSpawning(ChunkPos chunkPos, CallbackInfoReturnable<Boolean> cir) {
        ServerShip ship;
        if (VSGameUtilsKt.isChunkInShipyard((Level)this.f_140133_, chunkPos.f_45578_, chunkPos.f_45579_) && !((Boolean)cir.getReturnValue()).booleanValue() && (ship = (ServerShip)VSGameUtilsKt.getShipObjectWorld(this.f_140133_).getLoadedShips().getByChunkPos(chunkPos.f_45578_, chunkPos.f_45579_, VSGameUtilsKt.getDimensionId((Level)this.f_140133_))) != null) {
            cir.setReturnValue((Object)true);
        }
    }
}

