/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.shipyard_entities;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.handling.DefaultShipyardEntityHandler;
import org.valkyrienskies.mod.common.entity.handling.WorldEntityHandler;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={Projectile.class})
public abstract class MixinProjectile
extends Entity
implements TraceableEntity {
    @Shadow
    protected abstract void m_37283_();

    public MixinProjectile(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")})
    private void sendToShipyard(BlockHitResult blockHitResult, CallbackInfo ci2) {
        Ship ship = VSGameUtilsKt.getShipManagingPos(this.m_9236_(), blockHitResult.m_82425_());
        if (ship != null) {
            Vector3d hitLocation = ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(blockHitResult.f_82445_));
            blockHitResult.f_82445_ = VectorConversionsMCKt.toMinecraft((Vector3dc)hitLocation);
            DefaultShipyardEntityHandler.INSTANCE.moveEntityFromWorldToShipyard(this, ship);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void returnFromShipyard(CallbackInfo ci2) {
        Ship ship = VSGameUtilsKt.getShipManaging(this);
        if (ship == null) {
            return;
        }
        Iterable result = this.m_9236_().m_186434_((Entity)this, this.m_20191_().m_82400_(0.1));
        if (!result.iterator().hasNext()) {
            WorldEntityHandler.INSTANCE.moveEntityFromShipyardToWorld(this, ship);
        }
    }
}

