/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.poi;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4ic;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.POIChunkSearcher;
import org.valkyrienskies.mod.mixinducks.world.OfLevel;

@Mixin(value={PoiManager.class})
public abstract class MixinPOIManager
implements OfLevel {
    @Unique
    private Level valkyrienskies$sLevel;

    @Shadow
    public abstract Stream<PoiRecord> m_27117_(Predicate<PoiType> var1, ChunkPos var2, PoiManager.Occupancy var3);

    @Overwrite
    public Stream<PoiRecord> m_27166_(Predicate<PoiType> predicate, BlockPos blockPos, int i2, PoiManager.Occupancy occupancy) {
        int j2 = Math.floorDiv(i2, 16) + 1;
        AABB aABB = new AABB(blockPos).m_82400_((double)i2 + 1.0);
        Stream<ChunkPos> chunkRange = ChunkPos.m_45596_((ChunkPos)new ChunkPos(blockPos), (int)j2);
        Level level = this.valkyrienskies$sLevel;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            for (LoadedServerShip ship : VSGameUtilsKt.getShipObjectWorld(sLevel).getLoadedShips().getIntersecting((AABBdc)VectorConversionsMCKt.toJOML(aABB), VSGameUtilsKt.getDimensionId((Level)sLevel))) {
                Vector4ic chunkRangeBounds = POIChunkSearcher.INSTANCE.shipChunkBounds(ship.getActiveChunksSet());
                if (chunkRangeBounds == null) continue;
                chunkRange = Stream.concat(chunkRange, ChunkPos.m_45599_((ChunkPos)new ChunkPos(chunkRangeBounds.x(), chunkRangeBounds.y()), (ChunkPos)new ChunkPos(chunkRangeBounds.z(), chunkRangeBounds.w())));
            }
        }
        return chunkRange.flatMap(chunkPos -> this.m_27117_(predicate, (ChunkPos)chunkPos, occupancy)).filter(poiRecord -> {
            BlockPos blockPos2 = poiRecord.m_27257_();
            Vec3 vecPos = VSGameUtilsKt.toWorldCoordinates(this.valkyrienskies$sLevel, new Vec3((double)blockPos2.m_123341_(), (double)blockPos2.m_123342_(), (double)blockPos2.m_123343_()));
            return Math.abs(vecPos.m_7096_() - (double)blockPos.m_123341_()) <= (double)i2 && Math.abs(vecPos.m_7094_() - (double)blockPos.m_123343_()) <= (double)i2;
        });
    }

    @WrapOperation(method={"getInRange"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;")})
    private Stream<PoiRecord> onGetInRange(Stream<PoiRecord> instance, Predicate<PoiType> predicate, Operation<Stream<PoiRecord>> original, @Local(argsOnly=true) BlockPos arg, @Local(argsOnly=true) int i2) {
        int k2 = i2 * i2;
        return instance.filter(poiRecord -> POIChunkSearcher.INSTANCE.getWorldPos((PoiRecord)poiRecord, this.valkyrienskies$sLevel).m_82557_(Vec3.m_82528_((Vec3i)arg)) <= (double)k2);
    }

    @Override
    public Level getLevel() {
        return this.valkyrienskies$sLevel;
    }

    @Override
    public void setLevel(Level level) {
        this.valkyrienskies$sLevel = level;
    }
}

