/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.physics_block_entities;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.api.BlockEntityPhysicsListener;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.util.PhysicsBlockEntityUtil;

@Mixin(value={LevelChunk.class})
public abstract class MixinLevelChunk {
    @Shadow
    @Final
    Level f_62776_;

    @Inject(method={"updateBlockEntityTicker"}, at={@At(value="HEAD")})
    private <T extends BlockEntity> void beforeUpdateBlockEntityTicker(T blockEntity, CallbackInfo ci2) {
        String dimensionId = ValkyrienSkies.getDimensionId(this.f_62776_);
        if (blockEntity instanceof BlockEntityPhysicsListener) {
            BlockEntityPhysicsListener listener = (BlockEntityPhysicsListener)blockEntity;
            listener.setDimension(dimensionId);
            PhysicsBlockEntityUtil.onLoad(listener, blockEntity.m_58899_(), this.f_62776_, "[ADDED] updateBlockEntityTicker");
        } else {
            PhysicsBlockEntityUtil.onRemove(blockEntity.m_58899_(), this.f_62776_, "[REMOVED] updateBlockEntityTicker");
        }
    }

    @WrapOperation(method={"clearAllBlockEntities"}, at={@At(value="INVOKE", target="Ljava/util/Map;clear()V")})
    private void beforeClearAllBlockEntities(Map<BlockPos, BlockEntity> blockEntities, Operation<Void> original) {
        blockEntities.forEach((blockPos, blockEntity) -> {
            if (blockEntity instanceof BlockEntityPhysicsListener) {
                BlockEntityPhysicsListener listener = (BlockEntityPhysicsListener)blockEntity;
                PhysicsBlockEntityUtil.onRemove(blockPos, this.f_62776_, "clearAllBlockEntities");
            }
        });
        original.call(new Object[]{blockEntities});
    }

    @Inject(method={"removeBlockEntity"}, at={@At(value="TAIL")})
    private void afterRemoveBlockEntity(BlockPos blockPos, CallbackInfo ci2) {
        PhysicsBlockEntityUtil.onRemove(blockPos, this.f_62776_, "removeBlockEntity");
    }
}

