/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.fix_render_chunk_sorting;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={ChunkRenderDispatcher.RenderChunk.class})
public class MixinRenderChunk {
    @Shadow
    public AABB f_112785_;
    @Shadow
    @Final
    private BlockPos.MutableBlockPos f_112793_;

    @Inject(method={"getDistToPlayerSqr"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetSquaredCameraDistance(CallbackInfoReturnable<Double> cir) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        ClientShip shipObject = VSGameUtilsKt.getLoadedShipManagingPos(world, (Vec3i)this.f_112793_);
        if (shipObject != null) {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vector3d chunkPosInWorld = shipObject.getRenderTransform().getShipToWorldMatrix().transformPosition(new Vector3d(this.f_112785_.f_82288_ + 8.0, this.f_112785_.f_82289_ + 8.0, this.f_112785_.f_82290_ + 8.0));
            double relDistanceSq = chunkPosInWorld.distanceSquared(camera.m_90583_().f_82479_, camera.m_90583_().f_82480_, camera.m_90583_().f_82481_);
            cir.setReturnValue((Object)relDistanceSq);
        }
    }

    @Inject(method={"hasAllNeighbors"}, at={@At(value="HEAD")}, cancellable=true)
    private void preHasAllNeighbors(CallbackInfoReturnable<Boolean> cir) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        if (VSGameUtilsKt.isBlockInShipyard((Level)world, (BlockPos)this.f_112793_)) {
            cir.setReturnValue((Object)true);
        }
    }
}

