/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.forge.mixin.compat.terrafirmacraft;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.dries007.tfc.world.TFCChunkGenerator;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VS2ChunkAllocator;

@Mixin(value={TFCChunkGenerator.class})
public class MixinTFCChunkGenerator {
    @Final
    @Shadow
    private Holder<NoiseGeneratorSettings> noiseSettings;

    @Inject(method={"getBaseColumn"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetBaseColumn(int x2, int y2, LevelHeightAccessor level, RandomState random, CallbackInfoReturnable<NoiseColumn> cir) {
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(x2, y2)) {
            NoiseSettings ns2 = ((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_64439_();
            int k2 = Math.max(ns2.f_158688_(), level.m_141937_());
            cir.setReturnValue((Object)new NoiseColumn(k2, new BlockState[0]));
        }
    }

    @Inject(method={"buildSurface"}, at={@At(value="HEAD")}, cancellable=true)
    private void preBuildSurface(WorldGenRegion world, StructureManager manager, RandomState random, ChunkAccess chunk, CallbackInfo ci2) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }

    @Inject(method={"fillFromNoise"}, at={@At(value="HEAD")}, cancellable=true)
    private void preFillFromNoise(Executor executor, Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunk, CallbackInfoReturnable<CompletableFuture<ChunkAccess>> cir) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            cir.setReturnValue(CompletableFuture.completedFuture(chunk));
        }
    }

    @Inject(method={"applyCarvers"}, at={@At(value="HEAD")}, cancellable=true)
    private void preApplyCarvers(WorldGenRegion worldGenRegion, long l2, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving, CallbackInfo ci2) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }

    @Inject(method={"createStructures"}, at={@At(value="HEAD")}, cancellable=true)
    private void preCreateStructures(RegistryAccess access, ChunkGeneratorStructureState state, StructureManager manager, ChunkAccess chunk, StructureTemplateManager templateManager, CallbackInfo ci2) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }

    @Inject(method={"spawnOriginalMobs"}, at={@At(value="HEAD")}, cancellable=true)
    private void preSpawnOriginalMobs(WorldGenRegion worldGenRegion, CallbackInfo ci2) {
        ChunkPos chunkPos = worldGenRegion.m_143488_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }

    @Inject(method={"applyBiomeDecoration"}, at={@At(value="HEAD")}, cancellable=true)
    private void preApplyBiomeDecoration(WorldGenLevel level, ChunkAccess chunk, StructureManager structureFeatureManager, CallbackInfo ci2) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (VS2ChunkAllocator.INSTANCE.isChunkInShipyardCompanion(chunkPos.f_45578_, chunkPos.f_45579_)) {
            ci2.cancel();
        }
    }
}

