/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.compat.hexcasting;

import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironmentComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.compat.hexcasting.Key;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lorg/valkyrienskies/mod/compat/hexcasting/AmbitRemapping;", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironmentComponent$IsVecInRange;", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironmentComponent$HasEditPermissionsAt;", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironmentComponent$Key;", "getKey", "()Lat/petrak/hexcasting/api/casting/eval/CastingEnvironmentComponent$Key;", "Lnet/minecraft/core/BlockPos;", "pos", "", "current", "onHasEditPermissionsAt", "(Lnet/minecraft/core/BlockPos;Z)Z", "Lnet/minecraft/world/phys/Vec3;", "vec", "onIsVecInRange", "(Lnet/minecraft/world/phys/Vec3;Z)Z", "getCasterPosition", "()Lnet/minecraft/world/phys/Vec3;", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "getEnv", "()Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "id", "Ljava/util/UUID;", "Lorg/valkyrienskies/mod/compat/hexcasting/Key;", "key", "Lorg/valkyrienskies/mod/compat/hexcasting/Key;", "<init>", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nShipAmbit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipAmbit.kt\norg/valkyrienskies/mod/compat/hexcasting/AmbitRemapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public class AmbitRemapping
implements CastingEnvironmentComponent.IsVecInRange,
CastingEnvironmentComponent.HasEditPermissionsAt {
    @NotNull
    private final CastingEnvironment env;
    private final UUID id;
    @NotNull
    private final Key key;

    public AmbitRemapping(@NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
        UUID uUID = this.id = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"id");
        this.key = new Key(uUID);
    }

    @NotNull
    public final CastingEnvironment getEnv() {
        return this.env;
    }

    @NotNull
    public CastingEnvironmentComponent.Key<?> getKey() {
        return this.key;
    }

    public boolean onHasEditPermissionsAt(@NotNull BlockPos pos, boolean current) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (current) {
            return true;
        }
        LoadedServerShip loadedServerShip = VSGameUtilsKt.getLoadedShipManagingPos(this.env.getWorld(), (Vec3i)pos);
        if (loadedServerShip != null) {
            LoadedServerShip ship = loadedServerShip;
            boolean bl2 = false;
            Ship ship2 = (Ship)ship;
            Vec3 vec3 = pos.m_252807_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            return this.env.hasEditPermissionsAt(BlockPos.m_274446_((Position)((Position)ValkyrienSkies.positionToWorld(ship2, vec3))));
        }
        return current;
    }

    public boolean onIsVecInRange(@NotNull Vec3 vec, boolean current) {
        LoadedServerShip otherPos;
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        if (current) {
            return true;
        }
        ServerLevel level = this.env.getWorld();
        Vec3 vec3 = this.getCasterPosition();
        if (vec3 == null) {
            vec3 = Vec3.f_82478_;
        }
        Vec3 castVec = vec3;
        Intrinsics.checkNotNull((Object)castVec);
        LoadedServerShip casterShip = VSGameUtilsKt.getLoadedShipManagingPos(level, (Vector3dc)VectorConversionsMCKt.toJOML(castVec));
        LoadedServerShip otherShip = VSGameUtilsKt.getLoadedShipManagingPos(level, (Vector3dc)VectorConversionsMCKt.toJOML(vec));
        if (Intrinsics.areEqual((Object)casterShip, (Object)otherShip)) {
            return current;
        }
        LoadedServerShip loadedServerShip = otherShip;
        if (loadedServerShip == null || (loadedServerShip = ValkyrienSkies.positionToWorld((Ship)loadedServerShip, vec)) == null) {
            loadedServerShip = otherPos = vec;
        }
        if (casterShip != null) {
            LoadedServerShip casterShip2 = casterShip;
            boolean bl2 = false;
            return this.env.isVecInRange(ValkyrienSkies.positionToShip((Ship)casterShip2, (Vec3)otherPos));
        }
        return this.env.isVecInRange((Vec3)otherPos);
    }

    @Nullable
    public Vec3 getCasterPosition() {
        Vec3 vec3;
        LivingEntity livingEntity = this.env.getCastingEntity();
        if (livingEntity != null && (vec3 = livingEntity.m_20182_()) != null) {
            Vec3 it2 = vec3;
            boolean bl2 = false;
            return it2;
        }
        if (this.env instanceof CircleCastEnv) {
            BlockEntityAbstractImpetus blockEntityAbstractImpetus = ((CircleCastEnv)this.env).getImpetus();
            return blockEntityAbstractImpetus != null && (blockEntityAbstractImpetus = blockEntityAbstractImpetus.m_58899_()) != null ? blockEntityAbstractImpetus.m_252807_() : null;
        }
        return null;
    }
}

