/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.handling.VSEntityManager;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.EntityLerper;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b.\u0010/J%\u0010\b\u001a\u00020\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000b\u001a\u00020\n*\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u000e\u001a\u00020\r*\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u00020\n*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0013\u001a\u00020\r*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0017\u001a\u00020\r*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010$\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\r2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J9\u0010'\u001a\u00020&2\b\u0010 \u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\r2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lorg/valkyrienskies/mod/common/util/EntityDragger;", "", "", "Lnet/minecraft/world/entity/Entity;", "entities", "", "preTick", "", "dragEntitiesWithShips", "(Ljava/lang/Iterable;Z)V", "Lnet/minecraft/world/phys/Vec3;", "serversideEyePosition", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/Vec3;", "", "serversideEyeRotation", "(Lnet/minecraft/world/entity/Entity;)D", "default", "serversideEyePositionOrDefault", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "serversideEyeRotationOrDefault", "(Lnet/minecraft/world/entity/Entity;D)D", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "serversideWorldEyeRotationOrDefault", "(Lnet/minecraft/world/entity/Entity;Lorg/valkyrienskies/core/api/ships/Ship;D)D", "vec3", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/level/Level;", "cLevel", "backOff", "(Lnet/minecraft/world/phys/Vec3;Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/phys/Vec3;", "level", "step", "Lnet/minecraft/core/Direction;", "dir", "isValidWalkablePosition", "(Lnet/minecraft/world/level/Level;Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/world/entity/player/Player;DLnet/minecraft/core/Direction;)Z", "Lnet/minecraft/world/level/ClipContext;", "stepTowardsEdge", "(Lnet/minecraft/world/level/Level;Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/world/entity/player/Player;DLnet/minecraft/core/Direction;)Lnet/minecraft/world/level/ClipContext;", "entity", "isDraggable", "(Lnet/minecraft/world/entity/Entity;)Z", "ADDED_MOVEMENT_DECAY", "D", "<init>", "()V", "valkyrienskies-120"})
public final class EntityDragger {
    @NotNull
    public static final EntityDragger INSTANCE = new EntityDragger();
    private static final double ADDED_MOVEMENT_DECAY = 0.9;

    private EntityDragger() {
    }

    public final void dragEntitiesWithShips(@NotNull Iterable<? extends Entity> entities, boolean preTick) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        for (Entity entity : entities) {
            double shipData22;
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider");
            EntityDraggingInformation entityDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
            boolean dragTheEntity = false;
            Vector3dc addedMovement = null;
            double addedYRot = 0.0;
            Long shipDraggingEntity = entityDraggingInformation.getLastShipStoodOn();
            if (shipDraggingEntity != null && entity.m_20202_() == null && EntityDragger.isDraggable(entity)) {
                if (entityDraggingInformation.isEntityBeingDraggedByAShip()) {
                    Ship shipData22 = VSGameUtilsKt.getShipObjectWorld(entity.m_9236_()).getAllShips().getById(shipDraggingEntity);
                    if (shipData22 != null) {
                        double newYRotAsDegrees;
                        double addedYRotFromDragging;
                        dragTheEntity = true;
                        Vector3dc entityReferencePos = preTick ? (Vector3dc)new Vector3d(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) : (Vector3dc)new Vector3d(entity.f_19854_, entity.f_19855_, entity.f_19856_);
                        ShipTransform referenceTransform = shipData22 instanceof ClientShip ? ((ClientShip)shipData22).getTransform() : shipData22.getTransform();
                        Vector3d vector3d = referenceTransform.getShipToWorld().transformPosition(shipData22.getPrevTickTransform().getWorldToShip().transformPosition(new Vector3d(entityReferencePos)));
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
                        Vector3dc newPosIdeal = (Vector3dc)vector3d;
                        addedMovement = (Vector3dc)newPosIdeal.sub(entityReferencePos, new Vector3d());
                        double yViewRot = entity.m_146908_();
                        Vector3d entityLookYawOnly = new Vector3d(Math.sin(-Math.toRadians(yViewRot)), 0.0, Math.cos(-Math.toRadians(yViewRot)));
                        Vector3d newLookIdeal = referenceTransform.getShipToWorld().transformDirection(shipData22.getPrevTickTransform().getWorldToShip().transformDirection(entityLookYawOnly));
                        double newXRot = Math.asin(-newLookIdeal.y());
                        double xRotCos = Math.cos(newXRot);
                        double newYRot = -Math.atan2(newLookIdeal.x() / xRotCos, newLookIdeal.z() / xRotCos);
                        double entityYRotCorrected = (double)entity.m_146908_() % 360.0;
                        if (entityYRotCorrected <= -180.0) {
                            entityYRotCorrected += 360.0;
                        }
                        if (entityYRotCorrected >= 180.0) {
                            entityYRotCorrected -= 360.0;
                        }
                        if ((addedYRotFromDragging = (newYRotAsDegrees = Math.toDegrees(newYRot)) - entityYRotCorrected) <= -180.0) {
                            addedYRotFromDragging += 360.0;
                        }
                        if (addedYRotFromDragging >= 180.0) {
                            addedYRotFromDragging -= 360.0;
                        }
                        addedYRot = addedYRotFromDragging;
                    }
                } else {
                    addedMovement = (Vector3dc)new Vector3d(entityDraggingInformation.getAddedMovementLastTick());
                    addedYRot = 0.0;
                }
            }
            if (dragTheEntity && addedMovement != null && addedMovement.isFinite() && !Double.isInfinite(shipData22 = addedYRot) && !Double.isNaN(shipData22)) {
                AABB newBB = entity.m_20191_().m_82383_(ValkyrienSkies.toMinecraft(addedMovement));
                entity.m_20011_(newBB);
                entity.m_6034_(entity.m_20185_() + addedMovement.x(), entity.m_20186_() + addedMovement.y(), entity.m_20189_() + addedMovement.z());
                if (entityDraggingInformation.getShouldImpulseMovement() && (!entity.m_9236_().f_46443_ || entity instanceof LocalPlayer)) {
                    Vector3d acceleration = new Vector3d(entityDraggingInformation.getAddedMovementLastTick()).sub(addedMovement);
                    entity.m_5997_(acceleration.x, acceleration.y, acceleration.z);
                }
                entityDraggingInformation.setAddedMovementLastTick(addedMovement);
                double d2 = addedYRot;
                if (!Double.isInfinite(d2) && !Double.isNaN(d2)) {
                    if (!entity.m_9236_().m_5776_()) {
                        if (!(entity instanceof ServerPlayer)) {
                            entity.m_146922_((entity.m_146908_() + (float)addedYRot + 360.0f) % 360.0f);
                            entity.m_5616_((entity.m_6080_() + (float)addedYRot + 360.0f) % 360.0f);
                            if (entity instanceof LivingEntity) {
                                ((LivingEntity)entity).f_20883_ = (((LivingEntity)entity).f_20883_ + (float)addedYRot + 360.0f) % 360.0f;
                            }
                        } else {
                            entity.m_146922_(Mth.m_14177_((float)(entity.m_146908_() + (float)addedYRot)));
                            ((ServerPlayer)entity).f_20885_ = Mth.m_14177_((float)(((ServerPlayer)entity).f_20885_ + (float)addedYRot));
                            ((ServerPlayer)entity).f_20883_ = Mth.m_14177_((float)(((ServerPlayer)entity).f_20883_ + (float)addedYRot));
                        }
                    } else if (!entity.m_6109_() && !(entity instanceof Player)) {
                        entity.m_146922_(Mth.m_14177_((float)(entity.m_146908_() + (float)addedYRot)));
                        entity.m_5616_(Mth.m_14177_((float)(entity.m_6080_() + (float)addedYRot)));
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).f_20883_ = Mth.m_14177_((float)(((LivingEntity)entity).f_20883_ + (float)addedYRot));
                        }
                    } else {
                        entity.m_146922_(entity.m_146908_() + (float)addedYRot);
                        entity.m_5616_(entity.m_6080_() + (float)addedYRot);
                        if (entity instanceof LivingEntity) {
                            ((LivingEntity)entity).f_20883_ += (float)addedYRot;
                        }
                    }
                    entityDraggingInformation.setAddedYawRotLastTick(addedYRot);
                }
            } else if ((!entity.m_9236_().f_46443_ || entity instanceof LocalPlayer) && entityDraggingInformation.getAddedMovementLastTick().length() > 0.001) {
                entity.m_5997_(entityDraggingInformation.getAddedMovementLastTick().x(), entityDraggingInformation.getAddedMovementLastTick().y(), entityDraggingInformation.getAddedMovementLastTick().z());
                entityDraggingInformation.setAddedMovementLastTick((Vector3dc)new Vector3d());
                entityDraggingInformation.setAddedYawRotLastTick(0.0);
            }
            int n2 = entityDraggingInformation.getTicksSinceStoodOnShip();
            entityDraggingInformation.setTicksSinceStoodOnShip(n2 + 1);
            entityDraggingInformation.setMountedToEntity(entity.m_20202_() != null);
        }
    }

    public static /* synthetic */ void dragEntitiesWithShips$default(EntityDragger entityDragger, Iterable iterable, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        entityDragger.dragEntitiesWithShips(iterable, bl2);
    }

    @NotNull
    public final Vec3 serversideEyePosition(@NotNull Entity $this$serversideEyePosition) {
        Intrinsics.checkNotNullParameter((Object)$this$serversideEyePosition, (String)"<this>");
        if ($this$serversideEyePosition instanceof ServerPlayer && $this$serversideEyePosition instanceof IEntityDraggingInformationProvider && ((IEntityDraggingInformationProvider)$this$serversideEyePosition).getDraggingInformation().isEntityBeingDraggedByAShip() && ((IEntityDraggingInformationProvider)$this$serversideEyePosition).getDraggingInformation().getServerRelativePlayerPosition() != null) {
            Vector3dc vector3dc = ((IEntityDraggingInformationProvider)$this$serversideEyePosition).getDraggingInformation().getServerRelativePlayerPosition();
            Intrinsics.checkNotNull((Object)vector3dc);
            return ValkyrienSkies.toMinecraft(vector3dc);
        }
        Vec3 vec3 = $this$serversideEyePosition.m_146892_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        return vec3;
    }

    public final double serversideEyeRotation(@NotNull Entity $this$serversideEyeRotation) {
        Intrinsics.checkNotNullParameter((Object)$this$serversideEyeRotation, (String)"<this>");
        if ($this$serversideEyeRotation instanceof ServerPlayer && $this$serversideEyeRotation instanceof IEntityDraggingInformationProvider && ((IEntityDraggingInformationProvider)$this$serversideEyeRotation).getDraggingInformation().isEntityBeingDraggedByAShip() && ((IEntityDraggingInformationProvider)$this$serversideEyeRotation).getDraggingInformation().getServerRelativePlayerYaw() != null) {
            Double d2 = ((IEntityDraggingInformationProvider)$this$serversideEyeRotation).getDraggingInformation().getServerRelativePlayerYaw();
            Intrinsics.checkNotNull((Object)d2);
            return d2 * 180.0 / Math.PI;
        }
        return $this$serversideEyeRotation.m_146908_();
    }

    @NotNull
    public final Vec3 serversideEyePositionOrDefault(@NotNull Entity $this$serversideEyePositionOrDefault, @NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)$this$serversideEyePositionOrDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"default");
        if ($this$serversideEyePositionOrDefault instanceof ServerPlayer && $this$serversideEyePositionOrDefault instanceof IEntityDraggingInformationProvider && ((IEntityDraggingInformationProvider)$this$serversideEyePositionOrDefault).getDraggingInformation().isEntityBeingDraggedByAShip() && ((IEntityDraggingInformationProvider)$this$serversideEyePositionOrDefault).getDraggingInformation().getServerRelativePlayerPosition() != null) {
            Vector3dc vector3dc = ((IEntityDraggingInformationProvider)$this$serversideEyePositionOrDefault).getDraggingInformation().getServerRelativePlayerPosition();
            Intrinsics.checkNotNull((Object)vector3dc);
            return ValkyrienSkies.toMinecraft(vector3dc);
        }
        return vec3;
    }

    public final double serversideEyeRotationOrDefault(@NotNull Entity $this$serversideEyeRotationOrDefault, double d2) {
        Intrinsics.checkNotNullParameter((Object)$this$serversideEyeRotationOrDefault, (String)"<this>");
        if ($this$serversideEyeRotationOrDefault instanceof ServerPlayer && $this$serversideEyeRotationOrDefault instanceof IEntityDraggingInformationProvider && ((IEntityDraggingInformationProvider)$this$serversideEyeRotationOrDefault).getDraggingInformation().isEntityBeingDraggedByAShip() && ((IEntityDraggingInformationProvider)$this$serversideEyeRotationOrDefault).getDraggingInformation().getServerRelativePlayerYaw() != null) {
            Double d3 = ((IEntityDraggingInformationProvider)$this$serversideEyeRotationOrDefault).getDraggingInformation().getServerRelativePlayerYaw();
            Intrinsics.checkNotNull((Object)d3);
            return Math.toDegrees(d3);
        }
        return d2;
    }

    public final double serversideWorldEyeRotationOrDefault(@NotNull Entity $this$serversideWorldEyeRotationOrDefault, @NotNull Ship ship, double d2) {
        Intrinsics.checkNotNullParameter((Object)$this$serversideWorldEyeRotationOrDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        if ($this$serversideWorldEyeRotationOrDefault instanceof ServerPlayer && $this$serversideWorldEyeRotationOrDefault instanceof IEntityDraggingInformationProvider && ((IEntityDraggingInformationProvider)$this$serversideWorldEyeRotationOrDefault).getDraggingInformation().isEntityBeingDraggedByAShip() && ((IEntityDraggingInformationProvider)$this$serversideWorldEyeRotationOrDefault).getDraggingInformation().getServerRelativePlayerYaw() != null) {
            Double d3 = ((IEntityDraggingInformationProvider)$this$serversideWorldEyeRotationOrDefault).getDraggingInformation().getServerRelativePlayerYaw();
            Intrinsics.checkNotNull((Object)d3);
            return EntityLerper.INSTANCE.yawToWorld(ship, d3);
        }
        return d2;
    }

    @JvmStatic
    @NotNull
    public static final Vec3 backOff(@NotNull Vec3 vec3, @NotNull Ship ship, @NotNull Player player, @NotNull Level cLevel) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"vec3");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)cLevel, (String)"cLevel");
        Vector3d transformedVec = ship.getWorldToShip().transformDirection((Vector3dc)ValkyrienSkies.toJOML(vec3), new Vector3d());
        double d2 = transformedVec.x;
        double e2 = transformedVec.y;
        double f2 = transformedVec.z;
        while (!(d2 == 0.0) && !INSTANCE.isValidWalkablePosition(cLevel, ship, player, d2, Direction.EAST)) {
            if (d2 < 0.025 && d2 >= -0.025) {
                d2 = 0.0;
                continue;
            }
            if (d2 > 0.0) {
                d2 -= 0.025;
                continue;
            }
            d2 += 0.025;
        }
        while (!(f2 == 0.0) && !INSTANCE.isValidWalkablePosition(cLevel, ship, player, f2, Direction.SOUTH)) {
            if (f2 < 0.025 && f2 >= -0.025) {
                f2 = 0.0;
                continue;
            }
            if (f2 > 0.0) {
                f2 -= 0.025;
                continue;
            }
            f2 += 0.025;
        }
        while (!(e2 == 0.0) && !INSTANCE.isValidWalkablePosition(cLevel, ship, player, e2, Direction.UP)) {
            if (e2 < 0.025 && e2 >= -0.025) {
                e2 = 0.0;
                continue;
            }
            if (e2 > 0.0) {
                e2 -= 0.025;
                continue;
            }
            e2 += 0.025;
        }
        while (!(d2 == 0.0 || f2 == 0.0 || e2 == 0.0 || INSTANCE.isValidWalkablePosition(cLevel, ship, player, d2, Direction.EAST) || INSTANCE.isValidWalkablePosition(cLevel, ship, player, f2, Direction.SOUTH) || INSTANCE.isValidWalkablePosition(cLevel, ship, player, e2, Direction.UP))) {
            d2 = d2 < 0.025 && d2 >= -0.025 ? 0.0 : (d2 > 0.0 ? (d2 -= 0.025) : (d2 += 0.025));
            f2 = f2 < 0.025 && f2 >= -0.025 ? 0.0 : (f2 > 0.0 ? (f2 -= 0.025) : (f2 += 0.025));
            if (e2 < 0.025 && e2 >= -0.025) {
                e2 = 0.0;
                continue;
            }
            if (e2 > 0.0) {
                e2 -= 0.025;
                continue;
            }
            e2 += 0.025;
        }
        double motionLength = Math.sqrt(d2 * d2 + e2 * e2 + f2 * f2);
        Vector3d vector3d = ship.getShipToWorld().transformDirection(new Vector3d(d2, e2, f2)).normalize().mul(motionLength);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
        return ValkyrienSkies.toMinecraft((Vector3dc)vector3d);
    }

    private final boolean isValidWalkablePosition(Level level, Ship ship, Player player, double step, Direction dir) {
        ClipContext clipContext = this.stepTowardsEdge(level, ship, player, step, dir);
        BlockHitResult result = level.m_45547_(clipContext);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockPos blockPos = result.m_82425_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        LoadedShip hitShip = VSGameUtilsKt.getLoadedShipManagingPos(level, (Vec3i)blockPos);
        if (hitShip != null) {
            Vec3i vec3i = result.m_82434_().m_122436_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
            Vector3d hitSide = VectorConversionsMCKt.toJOMLD(vec3i);
            Vector3dc upDir = (Vector3dc)new Vector3d(0.0, 1.0, 0.0);
            Vector3d hitSideInWorld = hitShip.getShipToWorld().transformDirection((Vector3dc)hitSide, new Vector3d()).normalize();
            double dot = hitSideInWorld.dot(upDir);
            if (dot < 0.5 && dot > 0.001) {
                return false;
            }
        }
        return true;
    }

    private final ClipContext stepTowardsEdge(Level level, Ship ship, Player player, double step, Direction dir) {
        Vec3 vec3 = player.m_20182_();
        Vector3d vector3d = ship.getTransform().getShipToWorld().transformDirection(new Vector3d((Vector3fc)dir.m_253071_())).normalize().mul(step);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
        Vec3 potentialPosition = vec3.m_82549_(ValkyrienSkies.toMinecraft((Vector3dc)vector3d));
        Vector3dc downDirInShip = (Vector3dc)ship.getWorldToShip().transformDirection((Vector3dc)new Vector3d(0.0, -1.0, 0.0), new Vector3d()).normalize().mul((double)player.m_274421_());
        Intrinsics.checkNotNull((Object)potentialPosition);
        Vector3d vector3d2 = ValkyrienSkies.toJOML(potentialPosition).add(downDirInShip, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"add(...)");
        Vector3dc maxDistPos = (Vector3dc)vector3d2;
        return new ClipContext(potentialPosition, ValkyrienSkies.toMinecraft(maxDistPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
    }

    @JvmStatic
    public static final boolean isDraggable(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return !VSEntityManager.isShipyardEntity(entity) && entity instanceof IEntityDraggingInformationProvider && ((IEntityDraggingInformationProvider)entity).vs$shouldDrag();
    }
}

