/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.assembly;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.internal.VsiCore;
import org.valkyrienskies.core.internal.world.VsiServerShipWorld;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.BlockStateInfo;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.AssemblyUtil;
import org.valkyrienskies.mod.common.util.SplittingDisablerAttachment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ5\u0010\n\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ?\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/valkyrienskies/mod/common/assembly/ShipAssembler;", "", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "prevState", "newState", "", "triggerBlockChange", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V", "state", "", "isValidShipBlock", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "", "blocks", "removeOriginal", "", "scale", "shouldDisableSplitting", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "assembleToShip", "(Lnet/minecraft/world/level/Level;Ljava/util/List;ZDZ)Lorg/valkyrienskies/core/api/ships/ServerShip;", "<init>", "()V", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nShipAssembler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipAssembler.kt\norg/valkyrienskies/mod/common/assembly/ShipAssembler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class ShipAssembler {
    @NotNull
    public static final ShipAssembler INSTANCE = new ShipAssembler();

    private ShipAssembler() {
    }

    public final void triggerBlockChange(@Nullable Level level, @Nullable BlockPos pos, @Nullable BlockState prevState, @Nullable BlockState newState) {
        Level level2 = level;
        Intrinsics.checkNotNull((Object)level2);
        BlockPos blockPos = pos;
        Intrinsics.checkNotNull((Object)blockPos);
        BlockState blockState = prevState;
        Intrinsics.checkNotNull((Object)blockState);
        BlockState blockState2 = newState;
        Intrinsics.checkNotNull((Object)blockState2);
        BlockStateInfo.INSTANCE.onSetBlock(level2, blockPos, blockState, blockState2);
    }

    public final boolean isValidShipBlock(@Nullable BlockState state) {
        if (state != null) {
            return !state.m_60795_();
        }
        return true;
    }

    @NotNull
    public final ServerShip assembleToShip(@NotNull Level level, @NotNull List<? extends BlockPos> blocks, boolean removeOriginal, double scale, boolean shouldDisableSplitting) {
        ServerShip newShip;
        block18: {
            Object object;
            BlockPos shipPos;
            BlockPos relative;
            Object object2;
            Vector3i vector3i;
            Object v0;
            ServerLevel serverLevel;
            ServerLevel sLevel;
            block17: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
                boolean bl2 = level instanceof ServerLevel;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-ShipAssembler$assembleToShip$232 = false;
                    String $i$a$-assert-ShipAssembler$assembleToShip$232 = "Can't create ships clientside!";
                    throw new AssertionError((Object)$i$a$-assert-ShipAssembler$assembleToShip$232);
                }
                sLevel = (ServerLevel)level;
                if (blocks.isEmpty()) {
                    throw new IllegalArgumentException("No blocks to assemble.");
                }
                Iterable iterable = blocks;
                serverLevel = sLevel;
                Iterable iterable2 = iterable;
                for (Object t2 : iterable2) {
                    BlockPos it2 = (BlockPos)t2;
                    boolean bl3 = false;
                    if (!(!sLevel.m_8055_(it2).m_60795_())) continue;
                    v0 = t2;
                    break block17;
                }
                v0 = null;
            }
            BlockPos blockPos = v0;
            if (blockPos == null) {
                throw new IllegalArgumentException("Existing ship");
            }
            LoadedServerShip existingShip = VSGameUtilsKt.getLoadedShipManagingPos(serverLevel, (Vec3i)blockPos);
            BlockPos structureCornerMin = null;
            BlockPos structureCornerMax = null;
            boolean hasSolids = false;
            for (BlockPos blockPos2 : blocks) {
                if (!this.isValidShipBlock(((ServerLevel)level).m_8055_(blockPos2))) continue;
                if (structureCornerMin == null) {
                    structureCornerMin = blockPos2;
                    structureCornerMax = blockPos2;
                } else {
                    structureCornerMin = AssemblyUtil.INSTANCE.getMinCorner(structureCornerMin, blockPos2);
                    BlockPos blockPos3 = structureCornerMax;
                    Intrinsics.checkNotNull((Object)blockPos3);
                    structureCornerMax = AssemblyUtil.INSTANCE.getMaxCorner(blockPos3, blockPos2);
                }
                hasSolids = true;
            }
            if (!hasSolids) {
                throw new IllegalArgumentException("No solid blocks found in the structure");
            }
            BlockPos blockPos4 = structureCornerMin;
            Intrinsics.checkNotNull(blockPos4);
            BlockPos blockPos5 = structureCornerMax;
            Intrinsics.checkNotNull(blockPos5);
            Vector3ic contraptionOGPos = (Vector3ic)AssemblyUtil.INSTANCE.getMiddle(blockPos4, blockPos5);
            if (existingShip != null) {
                Vector3d vector3d = existingShip.getShipToWorld().transformPosition(new Vector3d(contraptionOGPos));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
                BlockPos doubleVer = BlockPos.m_274446_((Position)((Position)ValkyrienSkies.toMinecraft((Vector3dc)vector3d)));
                vector3i = new Vector3i(doubleVer.m_123341_(), doubleVer.m_123342_(), doubleVer.m_123343_());
            } else {
                vector3i = new Vector3i(contraptionOGPos);
            }
            Vector3i vector3i2 = vector3i;
            MinecraftServer minecraftServer = ((ServerLevel)level).m_7654_();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            newShip = VSGameUtilsKt.getShipObjectWorld(minecraftServer).createNewShipAtBlock((Vector3ic)vector3i2, false, scale, VSGameUtilsKt.getDimensionId(level));
            if (shouldDisableSplitting && (object2 = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(newShip.getId())) != null && (object2 = (SplittingDisablerAttachment)object2.getAttachment(SplittingDisablerAttachment.class)) != null) {
                ((SplittingDisablerAttachment)object2).disableSplitting();
            }
            Matrix4dc matrix4dc = newShip.getWorldToShip();
            Vec3 vec3 = new BlockPos(vector3i2.x, vector3i2.y, vector3i2.z).m_252807_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            Vector3d contraptionShipPos = matrix4dc.transformPosition(ValkyrienSkies.toJOML(vec3));
            BlockPos contraptionBlockPos = BlockPos.m_274561_((double)contraptionShipPos.x, (double)contraptionShipPos.y, (double)contraptionShipPos.z);
            boolean centerBlockReplaced = false;
            for (BlockPos blockPos6 : blocks) {
                if (!this.isValidShipBlock(((ServerLevel)level).m_8055_(blockPos6))) continue;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos6.m_121996_((Vec3i)new BlockPos(contraptionOGPos.x(), contraptionOGPos.y(), contraptionOGPos.z())), (String)"subtract(...)");
                Intrinsics.checkNotNullExpressionValue((Object)contraptionBlockPos.m_121955_((Vec3i)relative), (String)"offset(...)");
                AssemblyUtil.INSTANCE.copyBlock(level, blockPos6, shipPos);
                if (!relative.equals((Object)BlockPos.f_121853_)) continue;
                centerBlockReplaced = true;
            }
            if (removeOriginal) {
                for (BlockPos blockPos7 : blocks) {
                    if (!this.isValidShipBlock(((ServerLevel)level).m_8055_(blockPos7))) continue;
                    AssemblyUtil.INSTANCE.removeBlock(level, blockPos7);
                }
            }
            for (BlockPos blockPos8 : blocks) {
                Intrinsics.checkNotNullExpressionValue((Object)blockPos8.m_121996_((Vec3i)new BlockPos(contraptionOGPos.x(), contraptionOGPos.y(), contraptionOGPos.z())), (String)"subtract(...)");
                Intrinsics.checkNotNullExpressionValue((Object)contraptionBlockPos.m_121955_((Vec3i)relative), (String)"offset(...)");
                BlockState blockState = ((ServerLevel)level).m_8055_(shipPos);
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                AssemblyUtil.INSTANCE.updateBlock(level, blockPos8, shipPos, blockState);
            }
            Vec3 vec32 = new BlockPos(contraptionOGPos.x(), contraptionOGPos.y(), contraptionOGPos.z()).m_252807_();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
            Vector3d shipPos2 = ValkyrienSkies.toJOML(vec32);
            if (existingShip != null) {
                MinecraftServer minecraftServer2 = sLevel.m_7654_();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer2, (String)"getServer(...)");
                VsiServerShipWorld vsiServerShipWorld = VSGameUtilsKt.getShipObjectWorld(minecraftServer2);
                VsiCore vsiCore = VSGameUtilsKt.getVsCore();
                Vector3d vector3d = existingShip.getShipToWorld().transformPosition((Vector3dc)shipPos2, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
                vsiServerShipWorld.teleportShip(newShip, VsiCore.newShipTeleportData$default(vsiCore, (Vector3dc)vector3d, existingShip.getTransform().getShipToWorldRotation(), existingShip.getVelocity(), existingShip.getOmega(), existingShip.getChunkClaimDimension(), existingShip.getTransform().getShipToWorldScaling().x(), null, 64, null));
            } else {
                MinecraftServer minecraftServer3 = sLevel.m_7654_();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer3, (String)"getServer(...)");
                VSGameUtilsKt.getShipObjectWorld(minecraftServer3).teleportShip(newShip, VsiCore.newShipTeleportData$default(VSGameUtilsKt.getVsCore(), (Vector3dc)shipPos2, null, null, null, null, null, null, 126, null));
            }
            if (!shouldDisableSplitting || (object = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(newShip.getId())) == null || (object = (SplittingDisablerAttachment)object.getAttachment(SplittingDisablerAttachment.class)) == null) break block18;
            ((SplittingDisablerAttachment)object).enableSplitting();
        }
        return newShip;
    }

    public static /* synthetic */ ServerShip assembleToShip$default(ShipAssembler shipAssembler, Level level, List list, boolean bl2, double d2, boolean bl3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        return shipAssembler.assembleToShip(level, list, bl2, d2, bl3);
    }
}

