/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.assembly;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.valkyrienskies.mod.common.assembly.AssemblyUtilKt;
import org.valkyrienskies.mod.common.assembly.ShipAssembler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b,\u0010-J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J-\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001a\u0010\u001eJ\u0015\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010&\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010'J\u001d\u0010)\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004\u00a2\u0006\u0004\b)\u0010*J\u001d\u0010)\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c\u00a2\u0006\u0004\b)\u0010+\u00a8\u0006."}, d2={"Lorg/valkyrienskies/mod/common/assembly/AssemblyUtil;", "", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "setBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "removeBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "from", "to", "copyBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)V", "fromPos", "toPos", "toState", "updateBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "x", "y", "z", "toBlockPos", "(DDD)Lnet/minecraft/core/BlockPos;", "Lorg/joml/Vector3d;", "vec", "(Lorg/joml/Vector3d;)Lnet/minecraft/core/BlockPos;", "Lorg/joml/Vector3i;", "v", "Lnet/minecraft/core/Direction;", "getVecDirection", "(Lorg/joml/Vector3i;)Lnet/minecraft/core/Direction;", "pos1", "pos2", "getMinCorner", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "getMaxCorner", "getMiddle", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lorg/joml/Vector3i;", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "<init>", "()V", "valkyrienskies-120"})
public final class AssemblyUtil {
    @NotNull
    public static final AssemblyUtil INSTANCE = new AssemblyUtil();

    private AssemblyUtil() {
    }

    public final void setBlock(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ChunkAccess chunkAccess = level.m_46865_(pos);
        Intrinsics.checkNotNull((Object)chunkAccess, (String)"null cannot be cast to non-null type net.minecraft.world.level.chunk.LevelChunk");
        LevelChunk chunk = (LevelChunk)chunkAccess;
        LevelChunkSection section = chunk.m_183278_(chunk.m_151564_(pos.m_123342_()));
        BlockState oldState = level.m_8055_(pos);
        section.m_62986_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF, state);
        ShipAssembler.INSTANCE.triggerBlockChange(level, pos, oldState, state);
    }

    public final void removeBlock(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        level.m_46747_(pos);
        level.m_46865_(pos).m_6978_(pos, Blocks.f_50016_.m_49966_(), false);
    }

    public final void copyBlock(@NotNull Level level, @NotNull BlockPos from, @NotNull BlockPos to2) {
        block2: {
            BlockEntity newBlockentity;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to2, (String)"to");
            BlockState state = level.m_8055_(from);
            BlockEntity blockentity = level.m_7702_(from);
            level.m_46865_(to2).m_6978_(to2, state, false);
            if (level.m_183326_().m_183582_(from, (Object)state.m_60734_())) {
                level.m_183326_().m_183393_(new ScheduledTick((Object)state.m_60734_(), to2, 0L, 0L));
            }
            if (!state.m_155947_() || blockentity == null) break block2;
            CompoundTag compoundTag = blockentity.m_187481_();
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithId(...)");
            CompoundTag data = compoundTag;
            level.m_151523_(blockentity);
            BlockEntity blockEntity = newBlockentity = level.m_7702_(to2);
            if (blockEntity != null) {
                blockEntity.m_142466_(data);
            }
        }
    }

    public final void updateBlock(@NotNull Level level, @NotNull BlockPos fromPos, @NotNull BlockPos toPos, @NotNull BlockState toState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        Intrinsics.checkNotNullParameter((Object)toPos, (String)"toPos");
        Intrinsics.checkNotNullParameter((Object)toState, (String)"toState");
        int flags = 11;
        int recursionLeft = 511;
        level.m_6550_(fromPos, toState, AssemblyUtilKt.access$getAIR$p());
        level.m_7260_(fromPos, toState, AssemblyUtilKt.access$getAIR$p(), flags);
        level.m_6289_(fromPos, AssemblyUtilKt.access$getAIR$p().m_60734_());
        AssemblyUtilKt.access$getAIR$p().m_60762_((LevelAccessor)level, fromPos, flags, recursionLeft - 1);
        AssemblyUtilKt.access$getAIR$p().m_60705_((LevelAccessor)level, fromPos, flags, recursionLeft);
        AssemblyUtilKt.access$getAIR$p().m_60762_((LevelAccessor)level, fromPos, flags, recursionLeft);
        level.m_7726_().m_7827_().m_7174_(fromPos);
        level.m_6550_(toPos, AssemblyUtilKt.access$getAIR$p(), toState);
        level.m_7260_(toPos, AssemblyUtilKt.access$getAIR$p(), toState, flags);
        level.m_6289_(toPos, toState.m_60734_());
        if (!level.f_46443_ && toState.m_60807_()) {
            level.m_46717_(toPos, toState.m_60734_());
        }
        level.m_7726_().m_7827_().m_7174_(toPos);
    }

    @NotNull
    public final BlockPos toBlockPos(double x2, double y2, double z2) {
        return new BlockPos(Mth.m_14107_((double)x2), (int)Math.floor(y2), (int)Math.floor(z2));
    }

    @NotNull
    public final BlockPos toBlockPos(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        return this.toBlockPos(vec.x, vec.y, vec.z);
    }

    @NotNull
    public final Direction getVecDirection(@NotNull Vector3i v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        Direction.Axis axis = Direction.Axis.X;
        if (v2.y() != 0) {
            axis = Direction.Axis.Y;
        }
        if (v2.z() != 0) {
            axis = Direction.Axis.Z;
        }
        Direction.AxisDirection direction = v2.x + v2.y + v2.z > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        Direction direction2 = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)direction);
        Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"fromAxisAndDirection(...)");
        return direction2;
    }

    @NotNull
    public final BlockPos getMinCorner(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
        return new BlockPos(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()));
    }

    @NotNull
    public final BlockPos getMaxCorner(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
        return new BlockPos(Math.max(pos1.m_123341_(), pos2.m_123341_()), Math.max(pos1.m_123342_(), pos2.m_123342_()), Math.max(pos1.m_123343_(), pos2.m_123343_()));
    }

    @NotNull
    public final Vector3i getMiddle(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
        double middleX = (double)Math.min(pos1.m_123341_(), pos2.m_123341_()) + (double)((Math.max(pos1.m_123341_(), pos2.m_123341_()) - Math.min(pos1.m_123341_(), pos2.m_123341_()) + 1) / 2);
        double middleY = (double)Math.min(pos1.m_123342_(), pos2.m_123342_()) + (double)((Math.max(pos1.m_123342_(), pos2.m_123342_()) - Math.min(pos1.m_123342_(), pos2.m_123342_()) + 1) / 2);
        double middleZ = (double)Math.min(pos1.m_123343_(), pos2.m_123343_()) + (double)((Math.max(pos1.m_123343_(), pos2.m_123343_()) - Math.min(pos1.m_123343_(), pos2.m_123343_()) + 1) / 2);
        return new Vector3i((int)middleX, (int)middleY, (int)middleZ);
    }

    @NotNull
    public final Vector3d getMiddle(@NotNull Vector3d pos1, @NotNull Vector3d pos2) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
        double middleX = Math.min(pos1.x, pos2.x) + (Math.max(pos1.x, pos2.x) - Math.min(pos1.x, pos2.x)) / 2.0;
        double middleY = Math.min(pos1.y, pos2.y) + (Math.max(pos1.y, pos2.y) - Math.min(pos1.y, pos2.y)) / 2.0;
        double middleZ = Math.min(pos1.z, pos2.z) + (Math.max(pos1.z, pos2.z) - Math.min(pos1.z, pos2.z)) / 2.0;
        return new Vector3d(middleX, middleY, middleZ);
    }
}

