/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging.types.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.spaceeye.vmod.VMConfig;
import net.spaceeye.vmod.reflectable.ReflectableItemDelegate;
import net.spaceeye.vmod.reflectable.ReflectableObject;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.vEntityManaging.ServerLevelExtensionFnsKt;
import net.spaceeye.vmod.vEntityManaging.Tickable;
import net.spaceeye.vmod.vEntityManaging.VEntity;
import net.spaceeye.vmod.vEntityManaging.util.ExtendableVEntity;
import net.spaceeye.vmod.vEntityManaging.util.TickableVEntityExtension;
import net.spaceeye.vmod.vEntityManaging.util.VEAutoSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.internal.world.VsiPhysLevel;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B5\b\u0016\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0004\u0010\u0010J\u0016\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0016J\u0012\u0010;\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0<H\u0016J\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>2\n\u0010?\u001a\u00060\u0007j\u0002`\bH\u0016J \u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\nH\u0016JR\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010B\u001a\u00020C2\u001a\u0010H\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0007j\u0002`\b0I2\"\u0010J\u001a\u001e\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0K0IH\u0016JF\u0010L\u001a\u0002072\u0006\u0010B\u001a\u00020C2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\n0>2\n\u0010N\u001a\u00060\u0007j\u0002`\b2\n\u0010O\u001a\u00060\u0007j\u0002`\b2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\nH\u0016J\u001c\u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002070S0>2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010T\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\n\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010G2\u0006\u0010X\u001a\u00020VH\u0016J\u001e\u0010[\u001a\u00020A2\u0006\u0010\\\u001a\u00020]2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020A0_H\u0016J\u0018\u0010`\u001a\u00020A2\u0006\u0010B\u001a\u00020a2\u0006\u0010b\u001a\u00020\rH\u0016R\u0012\u0010\u0011\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0013\u001a\u00060\u0007j\u0002`\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0019\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR+\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\u0019\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R+\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u0019\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R\u001e\u0010/\u001a\u000600j\u0002`1X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u0010Y\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lnet/spaceeye/vmod/vEntityManaging/types/entities/ThrusterVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity;", "Lnet/spaceeye/vmod/vEntityManaging/Tickable;", "Lnet/spaceeye/vmod/vEntityManaging/util/VEAutoSerializable;", "<init>", "()V", "shipId", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "pos", "Lnet/spaceeye/vmod/utils/Vector3d;", "forceDir", "force", "", "channel", "", "(JLnet/spaceeye/vmod/utils/Vector3d;Lnet/spaceeye/vmod/utils/Vector3d;DLjava/lang/String;)V", "i", "", "<set-?>", "getShipId", "()J", "setShipId", "(J)V", "shipId$delegate", "Lnet/spaceeye/vmod/reflectable/ReflectableItemDelegate;", "getPos", "()Lnet/spaceeye/vmod/utils/Vector3d;", "setPos", "(Lnet/spaceeye/vmod/utils/Vector3d;)V", "pos$delegate", "getForceDir", "setForceDir", "forceDir$delegate", "getForce", "()D", "setForce", "(D)V", "force$delegate", "getChannel", "()Ljava/lang/String;", "setChannel", "(Ljava/lang/String;)V", "channel$delegate", "percentage", "getPercentage", "setPercentage", "compiledForce", "Lorg/joml/Vector3d;", "Lnet/spaceeye/vmod/utils/JVector3d;", "getCompiledForce", "()Lorg/joml/Vector3d;", "setCompiledForce", "(Lorg/joml/Vector3d;)V", "iStillExists", "", "allShips", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "Lorg/valkyrienskies/core/api/ships/Ship;", "iAttachedToShips", "", "iGetAttachmentPoints", "", "qshipId", "iOnScaleBy", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "scaleBy", "scalingCenter", "iCopyVEntity", "Lnet/spaceeye/vmod/vEntityManaging/VEntity;", "mapped", "", "centerPositions", "Lkotlin/Pair;", "iMoveAttachmentPoints", "pointsToMove", "oldShipId", "newShipId", "oldCenter", "newCenter", "iOnMakeVEntity", "Ljava/util/concurrent/CompletableFuture;", "iOnDeleteVEntity", "iNbtSerialize", "Lnet/minecraft/nbt/CompoundTag;", "iNbtDeserialize", "tag", "wasRemoved", "lastPercentage", "serverTick", "server", "Lnet/minecraft/server/MinecraftServer;", "unregister", "Lkotlin/Function0;", "physTick", "Lorg/valkyrienskies/core/internal/world/VsiPhysLevel;", "delta", "VMod"})
@SourceDebugExtension(value={"SMAP\nThrusterVEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrusterVEntity.kt\nnet/spaceeye/vmod/vEntityManaging/types/entities/ThrusterVEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ExtendableVEntity.kt\nnet/spaceeye/vmod/vEntityManaging/util/ExtendableVEntity\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n53#3:109\n808#4,11:110\n1863#4,2:121\n*S KotlinDebug\n*F\n+ 1 ThrusterVEntity.kt\nnet/spaceeye/vmod/vEntityManaging/types/entities/ThrusterVEntity\n*L\n93#1:109\n93#1:110,11\n93#1:121,2\n*E\n"})
public final class ThrusterVEntity
extends ExtendableVEntity
implements Tickable,
VEAutoSerializable {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @JsonIgnore
    private int i;
    @NotNull
    private final ReflectableItemDelegate shipId$delegate;
    @NotNull
    private final ReflectableItemDelegate pos$delegate;
    @NotNull
    private final ReflectableItemDelegate forceDir$delegate;
    @NotNull
    private final ReflectableItemDelegate force$delegate;
    @NotNull
    private final ReflectableItemDelegate channel$delegate;
    private double percentage;
    @NotNull
    private org.joml.Vector3d compiledForce;
    private boolean wasRemoved;
    private double lastPercentage;

    public ThrusterVEntity() {
        int n = this.i;
        this.i = n + 1;
        this.shipId$delegate = this.get(n, -1L).provideDelegate(this, $$delegatedProperties[0]);
        n = this.i;
        this.i = n + 1;
        this.pos$delegate = this.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[1]);
        n = this.i;
        this.i = n + 1;
        this.forceDir$delegate = this.get(n, new Vector3d()).provideDelegate(this, $$delegatedProperties[2]);
        n = this.i;
        this.i = n + 1;
        this.force$delegate = this.get(n, 1.0).provideDelegate(this, $$delegatedProperties[3]);
        n = this.i;
        this.i = n + 1;
        this.channel$delegate = this.get(n, "").provideDelegate(this, $$delegatedProperties[4]);
        this.compiledForce = new org.joml.Vector3d();
        this.lastPercentage = this.percentage;
    }

    public final long getShipId() {
        return ((Number)this.shipId$delegate.getValue(this, $$delegatedProperties[0])).longValue();
    }

    public final void setShipId(long l) {
        this.shipId$delegate.setValue(this, $$delegatedProperties[0], l);
    }

    @NotNull
    public final Vector3d getPos() {
        return (Vector3d)this.pos$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setPos(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.pos$delegate.setValue(this, $$delegatedProperties[1], vector3d);
    }

    @NotNull
    public final Vector3d getForceDir() {
        return (Vector3d)this.forceDir$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setForceDir(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.forceDir$delegate.setValue(this, $$delegatedProperties[2], vector3d);
    }

    public final double getForce() {
        return ((Number)this.force$delegate.getValue(this, $$delegatedProperties[3])).doubleValue();
    }

    public final void setForce(double d) {
        this.force$delegate.setValue(this, $$delegatedProperties[3], d);
    }

    @NotNull
    public final String getChannel() {
        return (String)this.channel$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.channel$delegate.setValue(this, $$delegatedProperties[4], string);
    }

    public final double getPercentage() {
        return this.percentage;
    }

    public final void setPercentage(double d) {
        this.percentage = d;
    }

    @NotNull
    public final org.joml.Vector3d getCompiledForce() {
        return this.compiledForce;
    }

    public final void setCompiledForce(@NotNull org.joml.Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.compiledForce = vector3d;
    }

    public ThrusterVEntity(long shipId, @NotNull Vector3d pos, @NotNull Vector3d forceDir, double force, @NotNull String channel) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)forceDir, (String)"forceDir");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this();
        this.setShipId(shipId);
        this.setPos(pos);
        this.setForceDir(forceDir);
        this.setForce(force);
        this.setChannel(channel);
    }

    @Override
    public boolean iStillExists(@NotNull QueryableShipData<? extends Ship> allShips) {
        Intrinsics.checkNotNullParameter(allShips, (String)"allShips");
        return allShips.contains(this.getShipId());
    }

    @Override
    @NotNull
    public List<Long> iAttachedToShips() {
        Object[] objectArray = new Long[]{this.getShipId()};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Vector3d> iGetAttachmentPoints(long qshipId) {
        return this.getShipId() == qshipId || qshipId == -1L ? CollectionsKt.listOf((Object)new Vector3d(this.getPos())) : CollectionsKt.emptyList();
    }

    @Override
    public void iOnScaleBy(@NotNull ServerLevel level, double scaleBy, @NotNull Vector3d scalingCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)scalingCenter, (String)"scalingCenter");
        if (!VMConfig.INSTANCE.getSERVER().getSCALE_THRUSTERS_THRUST()) {
            return;
        }
        this.setForce(this.getForce() * (scaleBy * scaleBy * scaleBy));
        this.lastPercentage = -1.0;
    }

    @Override
    @Nullable
    public VEntity iCopyVEntity(@NotNull ServerLevel level, @NotNull Map<Long, Long> mapped, @NotNull Map<Long, Pair<Vector3d, Vector3d>> centerPositions) {
        ServerShip serverShip;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(mapped, (String)"mapped");
        Intrinsics.checkNotNullParameter(centerPositions, (String)"centerPositions");
        Long l = mapped.get(this.getShipId());
        if (l == null) {
            return null;
        }
        long nId = l;
        Pair<Vector3d, Vector3d> pair = centerPositions.get(this.getShipId());
        if (pair == null) {
            return null;
        }
        Pair<Vector3d, Vector3d> pair2 = pair;
        Vector3d oldCenter = (Vector3d)pair2.component1();
        Vector3d newCenter = (Vector3d)pair2.component2();
        LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(nId);
        if (loadedServerShip != null) {
            serverShip = (ServerShip)loadedServerShip;
        } else {
            serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(nId);
            if (serverShip == null) {
                return null;
            }
        }
        ServerShip nShip = serverShip;
        Vector3d nPos = this.getPos().minus(oldCenter).plus(newCenter);
        return new ThrusterVEntity(nShip.getId(), nPos, new Vector3d(this.getForceDir()), this.getForce(), this.getChannel());
    }

    @Override
    public boolean iMoveAttachmentPoints(@NotNull ServerLevel level, @NotNull List<Vector3d> pointsToMove, long oldShipId, long newShipId, @NotNull Vector3d oldCenter, @NotNull Vector3d newCenter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(pointsToMove, (String)"pointsToMove");
        Intrinsics.checkNotNullParameter((Object)oldCenter, (String)"oldCenter");
        Intrinsics.checkNotNullParameter((Object)newCenter, (String)"newCenter");
        VEntity vEntity = this.copyVEntity(level, MapsKt.mapOf((Pair)TuplesKt.to((Object)oldShipId, (Object)newShipId)), MapsKt.mapOf((Pair)TuplesKt.to((Object)oldShipId, (Object)TuplesKt.to((Object)oldCenter, (Object)newCenter))));
        Intrinsics.checkNotNull((Object)vEntity);
        VEntity copy = vEntity;
        ServerLevelExtensionFnsKt.removeVEntity(level, this);
        ServerLevelExtensionFnsKt.makeVEntityWithId(level, copy, this.getMID(), (Function1<? super Integer, Unit>)((Function1)ThrusterVEntity::iMoveAttachmentPoints$lambda$0));
        return false;
    }

    @Override
    @NotNull
    public List<CompletableFuture<Boolean>> iOnMakeVEntity(@NotNull ServerLevel level) {
        CompletableFuture<Boolean> completableFuture;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CompletableFuture<Boolean> it = completableFuture = new CompletableFuture<Boolean>();
        boolean bl = false;
        it.complete(VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(this.getShipId()) != null);
        return CollectionsKt.listOf(completableFuture);
    }

    @Override
    public void iOnDeleteVEntity(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.wasRemoved = true;
    }

    @Override
    @Nullable
    public CompoundTag iNbtSerialize() {
        CompoundTag tag;
        block0: {
            CompoundTag compoundTag = tag = VEAutoSerializable.DefaultImpls.iNbtSerialize(this);
            if (compoundTag == null) break block0;
            compoundTag.m_128347_("percentage", this.percentage);
        }
        return tag;
    }

    @Override
    @Nullable
    public VEntity iNbtDeserialize(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.percentage = tag.m_128459_("percentage");
        return VEAutoSerializable.DefaultImpls.iNbtDeserialize(this, tag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serverTick(@NotNull MinecraftServer server, @NotNull Function0<Unit> unregister) {
        void $this$filterIsInstanceTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter(unregister, (String)"unregister");
        if (this.wasRemoved) {
            unregister.invoke();
            return;
        }
        ExtendableVEntity this_$iv = this;
        boolean $i$f$getExtensionsOfType = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getExtensions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof TickableVEntityExtension)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TickableVEntityExtension it = (TickableVEntityExtension)element$iv;
            boolean bl = false;
            it.tick(server);
        }
        if (this.lastPercentage == this.percentage) {
            return;
        }
        this.lastPercentage = this.percentage;
        this.compiledForce = this.getForceDir().times(this.getForce() * this.percentage).toJomlVector3d();
    }

    @Override
    public void physTick(@NotNull VsiPhysLevel level, double delta) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        PhysShip physShip = level.getShipById(this.getShipId());
        if (physShip == null) {
            return;
        }
        PhysShip ship = physShip;
        ship.applyBodyForce((Vector3dc)this.compiledForce, (Vector3dc)this.getPos().toJomlVector3d());
    }

    @Override
    public boolean getAlwaysTick() {
        return Tickable.DefaultImpls.getAlwaysTick(this);
    }

    @Override
    @NotNull
    public <T> ReflectableItemDelegate<T> get(int pos, @NotNull T t) {
        return VEAutoSerializable.DefaultImpls.get(this, pos, t);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public CompoundTag tSerialize() {
        return VEAutoSerializable.DefaultImpls.tSerialize(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void tDeserialize(@NotNull CompoundTag tag) {
        VEAutoSerializable.DefaultImpls.tDeserialize(this, tag);
    }

    @Override
    @JsonIgnore
    @NotNull
    public CompoundTag tGetBuffer() {
        return VEAutoSerializable.DefaultImpls.tGetBuffer(this);
    }

    @Override
    @JsonIgnore
    @Nullable
    public ReflectableObject getReflectObjectOverride() {
        return VEAutoSerializable.DefaultImpls.getReflectObjectOverride(this);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getAllReflectableItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getAllReflectableItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    @NotNull
    public List<ReflectableItemDelegate<?>> getReflectableItemsWithoutDataclassConstructorItems(boolean processSubReflectables, @NotNull Function1<? super ReflectableItemDelegate<?>, Boolean> filterBy) {
        return VEAutoSerializable.DefaultImpls.getReflectableItemsWithoutDataclassConstructorItems(this, processSubReflectables, filterBy);
    }

    @Override
    @JsonIgnore
    @ApiStatus.NonExtendable
    public void setFromVararg(@NotNull Object[] items) {
        VEAutoSerializable.DefaultImpls.setFromVararg(this, items);
    }

    private static final Unit iMoveAttachmentPoints$lambda$0(Integer it) {
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "shipId", "getShipId()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "pos", "getPos()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "forceDir", "getForceDir()Lnet/spaceeye/vmod/utils/Vector3d;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "force", "getForce()D", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ThrusterVEntity.class, "channel", "getChannel()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

