/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.vEntityManaging;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.server.level.ServerLevel;
import net.spaceeye.vmod.vEntityManaging.ServerLevelExtensionFnsKt;
import net.spaceeye.vmod.vEntityManaging.ShipData;
import net.spaceeye.vmod.vEntityManaging.VEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.impl.game.ShipTeleportDataImpl;
import org.valkyrienskies.core.internal.ShipTeleportData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u0012\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R!\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u00190\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/spaceeye/vmod/vEntityManaging/LoadingGroup;", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "vEntitiesToLoad", "", "Lnet/spaceeye/vmod/vEntityManaging/VEntity;", "neededShipIds", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipDataStatus", "", "Lnet/spaceeye/vmod/vEntityManaging/ShipData;", "<init>", "(Lnet/minecraft/server/level/ServerLevel;Ljava/util/List;Ljava/util/Set;Ljava/util/Map;)V", "getLevel", "()Lnet/minecraft/server/level/ServerLevel;", "getVEntitiesToLoad", "()Ljava/util/List;", "getNeededShipIds", "()Ljava/util/Set;", "getShipDataStatus", "()Ljava/util/Map;", "shipRefs", "Lorg/valkyrienskies/core/api/ships/ServerShip;", "setLoadedId", "", "ship", "applyVEntities", "VMod"})
public final class LoadingGroup {
    @NotNull
    private final ServerLevel level;
    @NotNull
    private final List<VEntity> vEntitiesToLoad;
    @NotNull
    private final Set<Long> neededShipIds;
    @NotNull
    private final Map<Long, ShipData> shipDataStatus;
    @NotNull
    private final Map<Long, ServerShip> shipRefs;

    public LoadingGroup(@NotNull ServerLevel level, @NotNull List<VEntity> vEntitiesToLoad, @NotNull Set<Long> neededShipIds, @NotNull Map<Long, ShipData> shipDataStatus) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(vEntitiesToLoad, (String)"vEntitiesToLoad");
        Intrinsics.checkNotNullParameter(neededShipIds, (String)"neededShipIds");
        Intrinsics.checkNotNullParameter(shipDataStatus, (String)"shipDataStatus");
        this.level = level;
        this.vEntitiesToLoad = vEntitiesToLoad;
        this.neededShipIds = neededShipIds;
        this.shipDataStatus = shipDataStatus;
        this.shipRefs = new LinkedHashMap();
    }

    @NotNull
    public final ServerLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final List<VEntity> getVEntitiesToLoad() {
        return this.vEntitiesToLoad;
    }

    @NotNull
    public final Set<Long> getNeededShipIds() {
        return this.neededShipIds;
    }

    @NotNull
    public final Map<Long, ShipData> getShipDataStatus() {
        return this.shipDataStatus;
    }

    public final void setLoadedId(@NotNull ServerShip ship) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        if (this.neededShipIds.isEmpty()) {
            return;
        }
        if (!this.neededShipIds.remove(ship.getId())) {
            return;
        }
        this.shipRefs.computeIfAbsent(ship.getId(), arg_0 -> LoadingGroup.setLoadedId$lambda$1(arg_0 -> LoadingGroup.setLoadedId$lambda$0(ship, arg_0), arg_0));
        this.shipDataStatus.computeIfAbsent(ship.getId(), arg_0 -> LoadingGroup.setLoadedId$lambda$3(arg_0 -> LoadingGroup.setLoadedId$lambda$2(ship, arg_0), arg_0));
        ship.setStatic(true);
        if (this.neededShipIds.isEmpty()) {
            this.applyVEntities();
            this.vEntitiesToLoad.clear();
        }
    }

    private final void applyVEntities() {
        Function0 finishFn = () -> LoadingGroup.applyVEntities$lambda$4(this);
        Ref.IntRef numToLoad = new Ref.IntRef();
        numToLoad.element = this.vEntitiesToLoad.size();
        for (VEntity entity : this.vEntitiesToLoad) {
            ServerLevelExtensionFnsKt.makeVEntityWithId(this.level, entity, entity.getMID(), (Function1<? super Integer, Unit>)((Function1)arg_0 -> LoadingGroup.applyVEntities$lambda$5(numToLoad, finishFn, arg_0)));
        }
    }

    private static final ServerShip setLoadedId$lambda$0(ServerShip $ship, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $ship;
    }

    private static final ServerShip setLoadedId$lambda$1(Function1 $tmp0, Object p0) {
        return (ServerShip)$tmp0.invoke(p0);
    }

    private static final ShipData setLoadedId$lambda$2(ServerShip $ship, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ShipData.Companion.fromShip($ship);
    }

    private static final ShipData setLoadedId$lambda$3(Function1 $tmp0, Object p0) {
        return (ShipData)$tmp0.invoke(p0);
    }

    private static final Unit applyVEntities$lambda$4(LoadingGroup this$0) {
        Iterator<Map.Entry<Long, ServerShip>> iterator = this$0.shipRefs.entrySet().iterator();
        while (iterator.hasNext()) {
            ShipData data;
            ServerShip ship = iterator.next().getValue();
            if (this$0.shipDataStatus.get(ship.getId()) == null) continue;
            ship.setStatic(data.isStatic());
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)this$0.level).teleportShip(ship, (ShipTeleportData)new ShipTeleportDataImpl(ship.getTransform().getPositionInWorld(), ship.getTransform().getShipToWorldRotation(), (Vector3dc)data.getVelocity(), (Vector3dc)data.getOmega(), ship.getChunkClaimDimension(), Double.valueOf(ship.getTransform().getShipToWorldScaling().x()), null, 64, null));
            this$0.shipDataStatus.remove(ship.getId());
        }
        this$0.shipRefs.clear();
        return Unit.INSTANCE;
    }

    private static final Unit applyVEntities$lambda$5(Ref.IntRef $numToLoad, Function0 $finishFn, Integer it) {
        int n = $numToLoad.element;
        $numToLoad.element = n + -1;
        if ($numToLoad.element > 0) {
            return Unit.INSTANCE;
        }
        $finishFn.invoke();
        return Unit.INSTANCE;
    }
}

