/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.toolgun;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.config.ExternalDataUtil;
import net.spaceeye.vmod.toolgun.PlayerAccessMangerState;
import net.spaceeye.vmod.toolgun.PlayerAccessState;
import net.spaceeye.vmod.utils.GetMapperKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\fJ\u0016\u0010-\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020\fJ\u0016\u0010-\u001a\u00020+2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\fJ\u000e\u0010/\u001a\u00020&2\u0006\u0010.\u001a\u00020\fJ\u001c\u00100\u001a\u00020&2\u0006\u0010.\u001a\u00020\f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\u000e\u00102\u001a\u00020+2\u0006\u0010.\u001a\u00020\fJ\u000e\u00103\u001a\u00020&2\u0006\u0010,\u001a\u00020\fJ\u0016\u00104\u001a\u00020&2\u0006\u0010.\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fJ\u0016\u00105\u001a\u00020&2\u0006\u0010.\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fJ\u0006\u00106\u001a\u00020&J\u0006\u00107\u001a\u00020&R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010RH\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u00122\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R<\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00122\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u0018R0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lnet/spaceeye/vmod/toolgun/PlayerAccessManager;", "", "<init>", "()V", "state", "Lnet/spaceeye/vmod/toolgun/PlayerAccessMangerState;", "getState", "()Lnet/spaceeye/vmod/toolgun/PlayerAccessMangerState;", "setState", "(Lnet/spaceeye/vmod/toolgun/PlayerAccessMangerState;)V", "allPermissionsList", "", "", "getAllPermissionsList", "()Ljava/util/List;", "setAllPermissionsList", "(Ljava/util/List;)V", "value", "", "", "rolesPermissions", "getRolesPermissions", "()Ljava/util/Map;", "setRolesPermissions", "(Ljava/util/Map;)V", "Ljava/util/UUID;", "Lnet/spaceeye/vmod/toolgun/PlayerAccessState;", "playersRoles", "getPlayersRoles", "setPlayersRoles", "allRoles", "getAllRoles", "setAllRoles", "allPermissions", "getAllPermissions", "()Ljava/util/Set;", "defaultRoleName", "afterInit", "", "getPlayerState", "player", "Lnet/minecraft/server/level/ServerPlayer;", "hasPermission", "", "permission", "setPlayerRole", "role", "addRole", "setRole", "permissions", "removeRole", "addPermission", "addPermissionToRole", "removePermissionFromRole", "save", "load", "VMod"})
@SourceDebugExtension(value={"SMAP\nPlayerAccessManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerAccessManager.kt\nnet/spaceeye/vmod/toolgun/PlayerAccessManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n381#2,7:197\n774#3:204\n865#3,2:205\n*S KotlinDebug\n*F\n+ 1 PlayerAccessManager.kt\nnet/spaceeye/vmod/toolgun/PlayerAccessManager\n*L\n114#1:197,7\n185#1:204\n185#1:205,2\n*E\n"})
public final class PlayerAccessManager {
    @NotNull
    public static final PlayerAccessManager INSTANCE = new PlayerAccessManager();
    @NotNull
    private static PlayerAccessMangerState state = new PlayerAccessMangerState();
    @NotNull
    private static List<String> allPermissionsList = new ArrayList();
    @NotNull
    private static final Set<String> allPermissions = new LinkedHashSet();
    @NotNull
    public static final String defaultRoleName = "default";

    private PlayerAccessManager() {
    }

    @NotNull
    public final PlayerAccessMangerState getState() {
        return state;
    }

    public final void setState(@NotNull PlayerAccessMangerState playerAccessMangerState) {
        Intrinsics.checkNotNullParameter((Object)playerAccessMangerState, (String)"<set-?>");
        state = playerAccessMangerState;
    }

    @NotNull
    public final List<String> getAllPermissionsList() {
        return allPermissionsList;
    }

    public final void setAllPermissionsList(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        allPermissionsList = list;
    }

    @NotNull
    public final Map<String, Set<String>> getRolesPermissions() {
        return state.getRolesPermissions();
    }

    public final void setRolesPermissions(@NotNull Map<String, Set<String>> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        state.setRolesPermissions(value);
    }

    @NotNull
    public final Map<UUID, PlayerAccessState> getPlayersRoles() {
        return state.getPlayersRoles();
    }

    public final void setPlayersRoles(@NotNull Map<UUID, PlayerAccessState> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        state.setPlayersRoles(value);
    }

    @NotNull
    public final List<String> getAllRoles() {
        return state.getAllRoles();
    }

    public final void setAllRoles(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        state.setAllRoles(value);
    }

    @NotNull
    public final Set<String> getAllPermissions() {
        return allPermissions;
    }

    public final synchronized void afterInit() {
        this.addRole(defaultRoleName);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized PlayerAccessState getPlayerState(ServerPlayer player) {
        Object object;
        void $this$getOrPut$iv;
        Map<UUID, PlayerAccessState> map2 = this.getPlayersRoles();
        UUID key$iv = player.m_20148_();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            UUID uUID = player.m_20148_();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            String string = player.m_36316_().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PlayerAccessState answer$iv = new PlayerAccessState(uUID, string, defaultRoleName);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PlayerAccessState)object;
    }

    public final synchronized boolean hasPermission(@NotNull ServerPlayer player, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (player.m_20310_(4)) {
            return true;
        }
        PlayerAccessState state = this.getPlayerState(player);
        Set<String> set = this.getRolesPermissions().get(state.getRole());
        if (set == null) {
            return false;
        }
        Set<String> permissions = set;
        return permissions.contains(permission);
    }

    public final synchronized boolean setPlayerRole(@NotNull ServerPlayer player, @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        if (!this.getRolesPermissions().containsKey(role)) {
            return false;
        }
        PlayerAccessState state = this.getPlayerState(player);
        state.setRole(role);
        return true;
    }

    public final synchronized boolean setPlayerRole(@NotNull UUID player, @NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        PlayerAccessState playerAccessState = this.getPlayersRoles().get(player);
        if (playerAccessState == null) {
            return false;
        }
        PlayerAccessState state = playerAccessState;
        if (!this.getRolesPermissions().containsKey(role)) {
            return false;
        }
        state.setRole(role);
        return true;
    }

    public final synchronized void addRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        if (this.getRolesPermissions().containsKey(role)) {
            return;
        }
        Set permissions = new LinkedHashSet();
        permissions.addAll((Collection)allPermissions);
        this.getRolesPermissions().put(role, permissions);
        this.getAllRoles().add(role);
    }

    public final synchronized void setRole(@NotNull String role, @NotNull Set<String> permissions) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        this.getRolesPermissions().put(role, permissions);
    }

    public final synchronized boolean removeRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        if (Intrinsics.areEqual((Object)role, (Object)defaultRoleName)) {
            return false;
        }
        return this.getRolesPermissions().remove(role) != null;
    }

    public final synchronized void addPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (allPermissions.contains(permission)) {
            throw new AssertionError((Object)"Permission already exists");
        }
        allPermissions.add(permission);
        allPermissionsList.add(permission);
    }

    public final synchronized void addPermissionToRole(@NotNull String role, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (!allPermissions.contains(permission)) {
            throw new AssertionError((Object)"Permission wasn't registered");
        }
        Set<String> set = this.getRolesPermissions().get(role);
        if (set == null) {
            throw new AssertionError((Object)"Role doesn't exist");
        }
        set.add(permission);
    }

    public final synchronized void removePermissionFromRole(@NotNull String role, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (!allPermissions.contains(permission)) {
            throw new AssertionError((Object)"Permission wasn't registered");
        }
        Set<String> set = this.getRolesPermissions().get(role);
        if (set == null) {
            throw new AssertionError((Object)"Role doesn't exist");
        }
        set.remove(permission);
    }

    public final synchronized void save() {
        ObjectMapper mapper = GetMapperKt.getMapper();
        byte[] data = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)state);
        Intrinsics.checkNotNull((Object)data);
        ExternalDataUtil.INSTANCE.writeObject("role_data.json", data);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void load() {
        ObjectMapper mapper = GetMapperKt.getMapper();
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            byte[] byArray = ExternalDataUtil.INSTANCE.readObject("role_data.json");
            if (byArray == null) {
                VMKt.ELOG("Failed to load role data as role_data.json doesn't exist!");
                return;
            }
            byte[] data = byArray;
            PlayerAccessMangerState obj = (PlayerAccessMangerState)mapper.readValue(data, PlayerAccessMangerState.class);
            Set allRolesSet = CollectionsKt.toSet((Iterable)this.getAllRoles());
            Iterable iterable = obj.getAllRoles();
            List<String> list = this.getAllRoles();
            boolean $i$f$filter = false;
            void var7_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!allRolesSet.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv);
            this.setRolesPermissions(obj.getRolesPermissions());
            this.setPlayersRoles(obj.getPlayersRoles());
        }
        catch (Exception e) {
            VMKt.ELOG("Failed to load role data because of exception:\n" + ExceptionsKt.stackTraceToString((Throwable)e));
        }
        catch (Error e) {
            VMKt.ELOG("Failed to load role data because of error:\n" + ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    private static final void _init_$lambda$0(ServerPlayer it) {
        Intrinsics.checkNotNull((Object)it);
        INSTANCE.getPlayerState(it);
    }

    private static final void _init_$lambda$1(MinecraftServer it) {
        INSTANCE.save();
    }

    private static final void _init_$lambda$2(MinecraftServer it) {
        INSTANCE.load();
    }

    static {
        PlayerEvent.PLAYER_JOIN.register(PlayerAccessManager::_init_$lambda$0);
        LifecycleEvent.SERVER_STOPPING.register(PlayerAccessManager::_init_$lambda$1);
        LifecycleEvent.SERVER_STARTING.register(PlayerAccessManager::_init_$lambda$2);
    }
}

