/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.shipAttachments;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.spaceeye.vmod.physgun.PlayerPhysgunState;
import net.spaceeye.vmod.utils.RotateVecByQuatKt;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipPhysicsListener;
import org.valkyrienskies.core.api.world.PhysLevel;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lnet/spaceeye/vmod/shipAttachments/PhysgunController;", "Lorg/valkyrienskies/core/api/ships/ShipPhysicsListener;", "<init>", "()V", "sharedState", "Lnet/spaceeye/vmod/physgun/PlayerPhysgunState;", "getSharedState", "()Lnet/spaceeye/vmod/physgun/PlayerPhysgunState;", "setSharedState", "(Lnet/spaceeye/vmod/physgun/PlayerPhysgunState;)V", "physTick", "", "physShip", "Lorg/valkyrienskies/core/api/ships/PhysShip;", "physLevel", "Lorg/valkyrienskies/core/api/world/PhysLevel;", "Companion", "VMod"})
@SourceDebugExtension(value={"SMAP\nPhysgunController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysgunController.kt\nnet/spaceeye/vmod/shipAttachments/PhysgunController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1863#2,2:201\n1863#2,2:203\n*S KotlinDebug\n*F\n+ 1 PhysgunController.kt\nnet/spaceeye/vmod/shipAttachments/PhysgunController\n*L\n42#1:201,2\n180#1:203,2\n*E\n"})
public final class PhysgunController
implements ShipPhysicsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonIgnore
    @Nullable
    private PlayerPhysgunState sharedState;

    @Nullable
    public final PlayerPhysgunState getSharedState() {
        return this.sharedState;
    }

    public final void setSharedState(@Nullable PlayerPhysgunState playerPhysgunState) {
        this.sharedState = playerPhysgunState;
    }

    /*
     * WARNING - void declaration
     */
    public void physTick(@NotNull PhysShip physShip, @NotNull PhysLevel physLevel) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)physShip, (String)"physShip");
        Intrinsics.checkNotNullParameter((Object)physLevel, (String)"physLevel");
        PlayerPhysgunState playerPhysgunState = this.sharedState;
        if (playerPhysgunState == null) {
            return;
        }
        PlayerPhysgunState state = playerPhysgunState;
        double pConst = state.getPConst();
        double dConst = state.getDConst();
        double iConst = state.getIConst();
        ReentrantLock lock = state.getLock();
        if (!lock.tryLock()) {
            return;
        }
        if (state.getMainShipId() == -1L) {
            this.sharedState = null;
            lock.unlock();
            return;
        }
        List shipsToInfluence = new ArrayList();
        Iterable $this$forEach$iv2 = state.getCaughtShipIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            PhysShip physShip2 = physLevel.getShipById(it);
            if (physShip2 == null) continue;
            shipsToInfluence.add(physShip2);
        }
        Vector3d idealPos = state.getPlayerPos().plus(state.getPlayerDir().times(state.getDistanceFromPlayer()));
        org.joml.Vector3d vector3d = physShip.getTransform().getShipToWorld().transformPosition(state.getFromPos().x, state.getFromPos().y, state.getFromPos().z, new org.joml.Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transformPosition(...)");
        Vector3d currentPos = new Vector3d(vector3d);
        Vector3d idealPosDiff = idealPos.minus(currentPos);
        Vector3d posDiff = idealPosDiff.times(pConst);
        double mass = physShip.getMass();
        Vector3d force = posDiff.minus(new Vector3d(physShip.getVelocity()).times(dConst)).times(mass);
        physShip.applyInvariantForce((Vector3dc)force.toJomlVector3d());
        Quaterniond rotDiff = state.getIdealRotation().mul((Quaterniondc)physShip.getTransform().getShipToWorldRotation().invert(new Quaterniond()), new Quaterniond()).normalize().invert();
        Vector3d rotDiffVector = new Vector3d(rotDiff.x * 2.0, rotDiff.y * 2.0, rotDiff.z * 2.0).smul(pConst);
        if (rotDiff.w > 0.0) {
            rotDiffVector.smul(-1.0);
        }
        rotDiffVector.minusAssign(new Vector3d(physShip.getOmega()).smul(dConst));
        org.joml.Vector3d torque = physShip.getTransform().getShipToWorldRotation().transform(physShip.getMomentOfInertia().transform(physShip.getTransform().getShipToWorldRotation().transformInverse(rotDiffVector.toJomlVector3d())));
        Intrinsics.checkNotNull((Object)torque);
        physShip.applyInvariantTorque((Vector3dc)torque);
        Iterable iterable = shipsToInfluence;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysShip it = (PhysShip)element$iv;
            boolean bl = false;
            org.joml.Vector3d dir = idealPos.minus(new Vector3d(it.getTransform().getPositionInWorld())).toJomlVector3d();
            Intrinsics.checkNotNull((Object)rotDiff);
            org.joml.Vector3d rotatedDir = RotateVecByQuatKt.rotateVecByQuat(dir, (Quaterniondc)rotDiff);
            org.joml.Vector3d vector3d2 = rotatedDir.sub((Vector3dc)dir);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
            Vector3d diff = new Vector3d(vector3d2).times(iConst);
            double mass2 = it.getMass();
            Vector3d force2 = diff.plus(posDiff).minus(new Vector3d(it.getVelocity()).times(dConst)).times(mass2);
            it.applyInvariantForce((Vector3dc)force2.toJomlVector3d());
        }
        lock.unlock();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/spaceeye/vmod/shipAttachments/PhysgunController$Companion;", "", "<init>", "()V", "getOrCreate", "Lnet/spaceeye/vmod/shipAttachments/PhysgunController;", "ship", "Lorg/valkyrienskies/core/api/ships/LoadedServerShip;", "VMod"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PhysgunController getOrCreate(@NotNull LoadedServerShip ship) {
            Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
            PhysgunController physgunController = (PhysgunController)ship.getAttachment(PhysgunController.class);
            if (physgunController == null) {
                PhysgunController physgunController2;
                PhysgunController it = physgunController2 = new PhysgunController();
                boolean bl = false;
                ship.setAttachment((Object)it);
                physgunController = physgunController2;
            }
            return physgunController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

