/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.textures;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.server.packs.resources.ResourceManager;
import net.spaceeye.vmod.rendering.RenderingUtils;
import net.spaceeye.vmod.rendering.textures.GIFReader;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\u0006\u0010/\u001a\u00020+J6\u00100\u001a\u00020+2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013J6\u00108\u001a\u00020+2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00132\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020:R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u001a\u0010!\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010\u0017R\u001a\u0010$\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0015\"\u0004\b&\u0010\u0017R\u001a\u0010'\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010\u0017\u00a8\u0006?"}, d2={"Lnet/spaceeye/vmod/rendering/textures/SlidingFrameTexture;", "Lnet/minecraft/client/renderer/texture/AbstractTexture;", "texture", "Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureWithData;", "<init>", "(Lnet/spaceeye/vmod/rendering/textures/GIFReader$NativeTextureWithData;)V", "image", "Lcom/mojang/blaze3d/platform/NativeImage;", "getImage", "()Lcom/mojang/blaze3d/platform/NativeImage;", "setImage", "(Lcom/mojang/blaze3d/platform/NativeImage;)V", "delays", "", "getDelays", "()[I", "setDelays", "([I)V", "width", "", "getWidth", "()I", "setWidth", "(I)V", "height", "getHeight", "setHeight", "spriteWidth", "getSpriteWidth", "setSpriteWidth", "spriteHeight", "getSpriteHeight", "setSpriteHeight", "widthTiles", "getWidthTiles", "setWidthTiles", "heightTiles", "getHeightTiles", "setHeightTiles", "numFrames", "getNumFrames", "setNumFrames", "load", "", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "close", "setAsShaderTexture", "blit", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "frameNum", "x", "y", "uWidth", "vHeight", "draw", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "Companion", "VMod"})
public final class SlidingFrameTexture
extends AbstractTexture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private NativeImage image;
    @NotNull
    private int[] delays;
    private int width;
    private int height;
    private int spriteWidth;
    private int spriteHeight;
    private int widthTiles;
    private int heightTiles;
    private int numFrames;

    public SlidingFrameTexture(@NotNull GIFReader.NativeTextureWithData texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.image = texture.getImage();
        this.delays = texture.getDelays();
        this.width = texture.getFrameWidth();
        this.height = texture.getFrameHeight();
        this.spriteWidth = texture.getSpriteWidth();
        this.spriteHeight = texture.getSpriteHeight();
        this.widthTiles = texture.getWidthTiles();
        this.heightTiles = texture.getHeightTiles();
        this.numFrames = texture.getNumFrames();
        RenderSystem.recordRenderCall(() -> SlidingFrameTexture._init_$lambda$0(this));
    }

    @NotNull
    public final NativeImage getImage() {
        return this.image;
    }

    public final void setImage(@NotNull NativeImage nativeImage) {
        Intrinsics.checkNotNullParameter((Object)nativeImage, (String)"<set-?>");
        this.image = nativeImage;
    }

    @NotNull
    public final int[] getDelays() {
        return this.delays;
    }

    public final void setDelays(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.delays = nArray;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final int getSpriteWidth() {
        return this.spriteWidth;
    }

    public final void setSpriteWidth(int n) {
        this.spriteWidth = n;
    }

    public final int getSpriteHeight() {
        return this.spriteHeight;
    }

    public final void setSpriteHeight(int n) {
        this.spriteHeight = n;
    }

    public final int getWidthTiles() {
        return this.widthTiles;
    }

    public final void setWidthTiles(int n) {
        this.widthTiles = n;
    }

    public final int getHeightTiles() {
        return this.heightTiles;
    }

    public final void setHeightTiles(int n) {
        this.heightTiles = n;
    }

    public final int getNumFrames() {
        return this.numFrames;
    }

    public final void setNumFrames(int n) {
        this.numFrames = n;
    }

    public void m_6704_(@Nullable ResourceManager resourceManager) {
    }

    public void close() {
        this.image.close();
        this.m_117964_();
    }

    public final void setAsShaderTexture() {
        RenderSystem._setShaderTexture((int)0, (int)this.m_117963_());
    }

    public final void blit(@NotNull PoseStack pose, int frameNum, int x, int y, int uWidth, int vHeight) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        this.setAsShaderTexture();
        Companion.innerDraw(pose, new Vector3d(x, y, 0), new Vector3d(x, y + vHeight, 0), new Vector3d(x + uWidth, y + vHeight, 0), new Vector3d(x + uWidth, y, 0), (float)(this.width * (frameNum % this.widthTiles + 0)) / (float)this.spriteWidth, (float)(this.width * (frameNum % this.widthTiles + 1)) / (float)this.spriteWidth, (float)(this.height * (frameNum / this.widthTiles + 0)) / (float)this.spriteHeight, (float)(this.height * (frameNum / this.widthTiles + 1)) / (float)this.spriteHeight);
    }

    public final void draw(@NotNull PoseStack pose, int frameNum, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
        Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
        this.setAsShaderTexture();
        Companion.innerDraw(pose, lu, ld, rd, ru, (float)(this.width * (frameNum % this.widthTiles + 0)) / (float)this.spriteWidth, (float)(this.width * (frameNum % this.widthTiles + 1)) / (float)this.spriteWidth, (float)(this.height * (frameNum / this.widthTiles + 0)) / (float)this.spriteHeight, (float)(this.height * (frameNum / this.widthTiles + 1)) / (float)this.spriteHeight);
    }

    private static final void _init_$lambda$0(SlidingFrameTexture this$0) {
        TextureUtil.prepareImage((int)this$0.m_117963_(), (int)0, (int)this$0.image.m_84982_(), (int)this$0.image.m_85084_());
        this$0.image.m_85013_(0, 0, 0, 0, 0, this$0.image.m_84982_(), this$0.image.m_85084_(), false, false, false, true);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"Lnet/spaceeye/vmod/rendering/textures/SlidingFrameTexture$Companion;", "", "<init>", "()V", "innerDraw", "", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "minU", "", "maxU", "minV", "maxV", "VMod"})
    public static final class Companion {
        private Companion() {
        }

        public final void innerDraw(@NotNull PoseStack pose, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float minU, float maxU, float minV, float maxV) {
            Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
            Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
            Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
            Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
            Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
            RenderSystem.setShader(GameRenderer::m_172817_);
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            Intrinsics.checkNotNull((Object)bufferBuilder);
            VertexConsumer vertexConsumer = (VertexConsumer)bufferBuilder;
            Intrinsics.checkNotNull((Object)matrix4f);
            RenderingUtils.Quad.drawQuad(vertexConsumer, matrix4f, 255, 255, 255, 255, 0, 0, lu, ld, rd, ru, minU, maxU, minV, maxV);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

