/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.textures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.spaceeye.vmod.rendering.textures.AnimatedGIFTexture;
import net.spaceeye.vmod.rendering.textures.GIFArray;
import net.spaceeye.vmod.rendering.textures.GIFReader;
import net.spaceeye.vmod.rendering.textures.SlidingFrameTexture;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 =2\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020 H\u0016J^\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002012\b\b\u0002\u00103\u001a\u0002012\b\b\u0002\u00104\u001a\u000201J^\u00105\u001a\u00020 2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\f2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002072\u0006\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\b\b\u0002\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u0002012\b\b\u0002\u00103\u001a\u0002012\b\b\u0002\u00104\u001a\u000201J\u0006\u0010;\u001a\u00020<R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006>"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFTexture;", "Lnet/minecraft/client/renderer/texture/AbstractTexture;", "<init>", "()V", "sprites", "", "Lnet/spaceeye/vmod/rendering/textures/GIFArray;", "getSprites", "()Ljava/util/List;", "setSprites", "(Ljava/util/List;)V", "width", "", "getWidth", "()I", "setWidth", "(I)V", "height", "getHeight", "setHeight", "totalFrames", "getTotalFrames", "setTotalFrames", "framesPerSprite", "getFramesPerSprite", "setFramesPerSprite", "loadedSuccessfully", "Ljava/util/concurrent/CompletableFuture;", "", "getLoadedSuccessfully", "()Ljava/util/concurrent/CompletableFuture;", "loadFromBytes", "", "bytes", "", "load", "", "resourceManager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "close", "blit", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "frameNum", "x", "y", "uWidth", "vHeight", "u0", "", "u1", "v0", "v1", "draw", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "animated", "Lnet/spaceeye/vmod/rendering/textures/AnimatedGIFTexture;", "Companion", "VMod"})
@SourceDebugExtension(value={"SMAP\nGIFTexture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GIFTexture.kt\nnet/spaceeye/vmod/rendering/textures/GIFTexture\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1557#2:158\n1628#2,3:159\n1734#2,3:162\n1734#2,3:165\n1863#2,2:168\n*S KotlinDebug\n*F\n+ 1 GIFTexture.kt\nnet/spaceeye/vmod/rendering/textures/GIFTexture\n*L\n85#1:158\n85#1:159,3\n92#1:162,3\n93#1:165,3\n105#1:168,2\n*E\n"})
public final class GIFTexture
extends AbstractTexture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<GIFArray> sprites = new ArrayList();
    private int width;
    private int height;
    private int totalFrames;
    private int framesPerSprite;
    @NotNull
    private final CompletableFuture<Boolean> loadedSuccessfully = new CompletableFuture();
    @NotNull
    private static final ResourceLocation dummyLocation = new ResourceLocation("the_vmod", "missing");
    @NotNull
    private static final ResourceLocation tempTextureLocation = new ResourceLocation("the_vmod", "textures/misc/loading.png");

    @NotNull
    public final List<GIFArray> getSprites() {
        return this.sprites;
    }

    public final void setSprites(@NotNull List<GIFArray> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sprites = list;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final int getTotalFrames() {
        return this.totalFrames;
    }

    public final void setTotalFrames(int n) {
        this.totalFrames = n;
    }

    public final int getFramesPerSprite() {
        return this.framesPerSprite;
    }

    public final void setFramesPerSprite(int n) {
        this.framesPerSprite = n;
    }

    @NotNull
    public final CompletableFuture<Boolean> getLoadedSuccessfully() {
        return this.loadedSuccessfully;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadFromBytes(@NotNull byte[] bytes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        List<GIFReader.NativeTextureWithData> textures = GIFReader.INSTANCE.readGifToTexturesFaster(bytes);
        this.width = textures.get(0).getFrameWidth();
        this.height = textures.get(0).getFrameHeight();
        this.framesPerSprite = textures.get(0).getNumFrames();
        Iterable $this$map$iv = textures;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GIFReader.NativeTextureWithData nativeTextureWithData = (GIFReader.NativeTextureWithData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CompletableFuture());
        }
        List futures = (List)destination$iv$iv;
        Iterator iterator = ((Iterable)textures).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            GIFReader.NativeTextureWithData texture = (GIFReader.NativeTextureWithData)iterator.next();
            GIFArray texture2 = new GIFArray(texture.getPtr(), texture.getFrameWidth(), texture.getFrameHeight(), texture.getNumFrames(), texture.getDelays());
            texture2.upload().thenAccept(arg_0 -> GIFTexture.loadFromBytes$lambda$4(arg_0 -> GIFTexture.loadFromBytes$lambda$3(texture2, futures, i2, this, arg_0), arg_0));
            this.sprites.add(texture2);
            this.totalFrames += texture2.getNumLayers();
        }
    }

    @NotNull
    public Void load(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        throw new NotImplementedError("use loadFromBytes");
    }

    public void close() {
        this.loadedSuccessfully.thenAccept(arg_0 -> GIFTexture.close$lambda$7(arg_0 -> GIFTexture.close$lambda$6(this, arg_0), arg_0));
    }

    public final void blit(@NotNull PoseStack pose, int frameNum, int x, int y, int uWidth, int vHeight, float u0, float u1, float v0, float v1) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        if (!this.loadedSuccessfully.isDone()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)tempTextureLocation);
            GIFTexture.Companion.tempBlit(pose, x, y, uWidth, vHeight);
            return;
        }
        if (!this.loadedSuccessfully.get().booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)dummyLocation);
            GIFTexture.Companion.tempBlit(pose, x, y, uWidth, vHeight);
            return;
        }
        this.sprites.get(frameNum / this.framesPerSprite).blit(pose, frameNum, x, y, uWidth, vHeight, u0, u1, v0, v1);
    }

    public static /* synthetic */ void blit$default(GIFTexture gIFTexture, PoseStack poseStack, int n, int n2, int n3, int n4, int n5, float f, float f2, float f3, float f4, int n6, Object object) {
        if ((n6 & 0x40) != 0) {
            f = 0.0f;
        }
        if ((n6 & 0x80) != 0) {
            f2 = 1.0f;
        }
        if ((n6 & 0x100) != 0) {
            f3 = 0.0f;
        }
        if ((n6 & 0x200) != 0) {
            f4 = 1.0f;
        }
        gIFTexture.blit(poseStack, n, n2, n3, n4, n5, f, f2, f3, f4);
    }

    public final void draw(@NotNull PoseStack pose, int frameNum, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float u0, float u1, float v0, float v1) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
        Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
        if (!this.loadedSuccessfully.isDone()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)tempTextureLocation);
            GIFTexture.Companion.tempDraw(pose, lu, ld, rd, ru);
            return;
        }
        if (!this.loadedSuccessfully.get().booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)dummyLocation);
            GIFTexture.Companion.tempDraw(pose, lu, ld, rd, ru);
            return;
        }
        this.sprites.get(frameNum / this.framesPerSprite).draw(pose, frameNum % this.framesPerSprite, lu, ld, rd, ru, u0, u1, v0, v1);
    }

    public static /* synthetic */ void draw$default(GIFTexture gIFTexture, PoseStack poseStack, int n, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, float f, float f2, float f3, float f4, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            f = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 0x100) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x200) != 0) {
            f4 = 1.0f;
        }
        gIFTexture.draw(poseStack, n, vector3d, vector3d2, vector3d3, vector3d4, f, f2, f3, f4);
    }

    @NotNull
    public final AnimatedGIFTexture animated() {
        return new AnimatedGIFTexture(this);
    }

    private static final Unit loadFromBytes$lambda$3(GIFArray $texture, List $futures, int $i, GIFTexture this$0, Boolean it) {
        CompletableFuture it2;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        block7: {
            $texture.freeRAM();
            ((CompletableFuture)$futures.get($i)).complete(it);
            $this$all$iv = $futures;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it2 = (CompletableFuture)element$iv;
                    boolean bl2 = false;
                    if (it2.isDone()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            boolean bl3;
            CompletableFuture<Boolean> completableFuture;
            block8: {
                $this$all$iv = $futures;
                completableFuture = this$0.loadedSuccessfully;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it2 = (CompletableFuture)element$iv;
                        boolean bl4 = false;
                        Object t = it2.get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                        if (((Boolean)t).booleanValue()) continue;
                        bl3 = false;
                        break block8;
                    }
                    bl3 = true;
                }
            }
            boolean bl5 = bl3;
            completableFuture.complete(bl5);
        }
        return Unit.INSTANCE;
    }

    private static final void loadFromBytes$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit close$lambda$6(GIFTexture this$0, Boolean it) {
        Iterable $this$forEach$iv = this$0.sprites;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GIFArray it2 = (GIFArray)element$iv;
            boolean bl = false;
            it2.close();
        }
        return Unit.INSTANCE;
    }

    private static final void close$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J0\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/spaceeye/vmod/rendering/textures/GIFTexture$Companion;", "", "<init>", "()V", "dummyLocation", "Lnet/minecraft/resources/ResourceLocation;", "tempTextureLocation", "tempBlit", "", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "x", "", "y", "uWidth", "vHeight", "tempDraw", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "VMod"})
    public static final class Companion {
        private Companion() {
        }

        private final void tempBlit(PoseStack pose, int x, int y, int uWidth, int vHeight) {
            SlidingFrameTexture.Companion.innerDraw(pose, new Vector3d(x, y, 0), new Vector3d(x, y + vHeight, 0), new Vector3d(x + uWidth, y + vHeight, 0), new Vector3d(x + uWidth, y, 0), 0.0f, 1.0f, 0.0f, 1.0f);
        }

        private final void tempDraw(PoseStack pose, Vector3d lu, Vector3d ld, Vector3d rd, Vector3d ru) {
            SlidingFrameTexture.Companion.innerDraw(pose, lu, ld, rd, ru, 0.0f, 1.0f, 0.0f, 1.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

