/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.textures;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.spaceeye.vmod.OnFinalize;
import net.spaceeye.vmod.rendering.RenderTypes;
import net.spaceeye.vmod.rendering.RenderingUtils;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0018\u001a\u00020\u00192\u000e\b\u0004\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0084\b\u00f8\u0001\u0000J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dJ\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\b\b\u0002\u0010 \u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u0019J\b\u0010#\u001a\u00020\u0019H\u0014J^\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u00020-2\b\b\u0002\u00100\u001a\u00020-J^\u00101\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-2\b\b\u0002\u0010/\u001a\u00020-2\b\b\u0002\u00100\u001a\u00020-J^\u00107\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\u0006\u0010:\u001a\u00020-2\u0006\u0010;\u001a\u00020-2\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006>"}, d2={"Lnet/spaceeye/vmod/rendering/textures/ArrayTexture;", "Lnet/spaceeye/vmod/OnFinalize;", "ptr", "", "width", "", "height", "numLayers", "<init>", "(JIII)V", "getWidth", "()I", "getHeight", "getNumLayers", "value", "getPtr", "()J", "id", "getId", "uploaded", "", "closed", "getClosed", "()Z", "onRenderThread", "", "fn", "Lkotlin/Function0;", "upload", "Ljava/util/concurrent/CompletableFuture;", "bind", "setAsShaderTexture", "i", "close", "freeRAM", "onFinalize", "blit", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "frameNum", "x", "y", "uWidth", "vHeight", "u0", "", "u1", "v0", "v1", "draw", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "innerDraw", "maxLayers", "currentLayer", "minU", "maxU", "minV", "maxV", "VMod"})
@SourceDebugExtension(value={"SMAP\nArrayTexture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayTexture.kt\nnet/spaceeye/vmod/rendering/textures/ArrayTexture\n*L\n1#1,120:1\n31#1,7:121\n31#1,7:128\n31#1,7:135\n31#1,7:142\n*S KotlinDebug\n*F\n+ 1 ArrayTexture.kt\nnet/spaceeye/vmod/rendering/textures/ArrayTexture\n*L\n41#1:121,7\n61#1:128,7\n65#1:135,7\n70#1:142,7\n*E\n"})
public class ArrayTexture
extends OnFinalize {
    private final int width;
    private final int height;
    private final int numLayers;
    private long ptr;
    private int id;
    private boolean uploaded;
    private boolean closed;

    public ArrayTexture(long ptr, int width, int height, int numLayers) {
        this.width = width;
        this.height = height;
        this.numLayers = numLayers;
        this.ptr = ptr;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumLayers() {
        return this.numLayers;
    }

    public final long getPtr() {
        return this.ptr;
    }

    public final int getId() {
        return this.id;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    protected final void onRenderThread(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$onRenderThread = false;
        if (RenderSystem.isOnRenderThread()) {
            fn.invoke();
            return;
        }
        RenderSystem.recordRenderCall((RenderCall)new RenderCall(fn){
            final /* synthetic */ Function0<Unit> $fn;
            {
                this.$fn = $fn;
            }

            public final void m_83909_() {
                this.$fn.invoke();
            }
        });
    }

    @NotNull
    public final CompletableFuture<Boolean> upload() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ArrayTexture this_$iv = this;
        boolean $i$f$onRenderThread = false;
        if (RenderSystem.isOnRenderThread()) {
            boolean bl = false;
            if (this.uploaded) {
                throw new AssertionError((Object)"uploaded twice");
            }
            this.id = TextureUtil.generateTextureId();
            this.bind();
            GL46.glTexStorage3D((int)35866, (int)1, (int)32856, (int)this.getWidth(), (int)this.getHeight(), (int)this.getNumLayers());
            GL46.glTexSubImage3D((int)35866, (int)0, (int)0, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)this.getNumLayers(), (int)6408, (int)5121, (long)this.getPtr());
            GL46.glTexParameteri((int)35866, (int)10242, (int)10497);
            GL46.glTexParameteri((int)35866, (int)10243, (int)10497);
            GL46.glTexParameteri((int)35866, (int)10240, (int)9728);
            GL46.glTexParameteri((int)35866, (int)10241, (int)9728);
            future.complete(true);
            this.uploaded = true;
        } else {
            RenderSystem.recordRenderCall((RenderCall)new RenderCall(this, future){
                final /* synthetic */ ArrayTexture this$0;
                final /* synthetic */ CompletableFuture $future$inlined;
                {
                    this.this$0 = arrayTexture;
                    this.$future$inlined = completableFuture;
                }

                public final void m_83909_() {
                    boolean bl = false;
                    if (ArrayTexture.access$getUploaded$p(this.this$0)) {
                        throw new AssertionError((Object)"uploaded twice");
                    }
                    ArrayTexture.access$setId$p(this.this$0, TextureUtil.generateTextureId());
                    ArrayTexture.access$bind(this.this$0);
                    GL46.glTexStorage3D((int)35866, (int)1, (int)32856, (int)this.this$0.getWidth(), (int)this.this$0.getHeight(), (int)this.this$0.getNumLayers());
                    GL46.glTexSubImage3D((int)35866, (int)0, (int)0, (int)0, (int)0, (int)this.this$0.getWidth(), (int)this.this$0.getHeight(), (int)this.this$0.getNumLayers(), (int)6408, (int)5121, (long)this.this$0.getPtr());
                    GL46.glTexParameteri((int)35866, (int)10242, (int)10497);
                    GL46.glTexParameteri((int)35866, (int)10243, (int)10497);
                    GL46.glTexParameteri((int)35866, (int)10240, (int)9728);
                    GL46.glTexParameteri((int)35866, (int)10241, (int)9728);
                    this.$future$inlined.complete(true);
                    ArrayTexture.access$setUploaded$p(this.this$0, true);
                }
            });
        }
        return future;
    }

    private final void bind() {
        ArrayTexture this_$iv = this;
        boolean $i$f$onRenderThread = false;
        if (RenderSystem.isOnRenderThread()) {
            boolean bl = false;
            GL46.glBindTexture((int)35866, (int)this.getId());
        } else {
            RenderSystem.recordRenderCall((RenderCall)new RenderCall(this){
                final /* synthetic */ ArrayTexture this$0;
                {
                    this.this$0 = arrayTexture;
                }

                public final void m_83909_() {
                    boolean bl = false;
                    GL46.glBindTexture((int)35866, (int)this.this$0.getId());
                }
            });
        }
    }

    public final void setAsShaderTexture(int i2) {
        ArrayTexture this_$iv = this;
        boolean $i$f$onRenderThread = false;
        if (RenderSystem.isOnRenderThread()) {
            boolean bl = false;
            GL46.glActiveTexture((int)(33984 + i2));
            this.bind();
        } else {
            RenderSystem.recordRenderCall((RenderCall)new RenderCall(i2, this){
                final /* synthetic */ int $i$inlined;
                final /* synthetic */ ArrayTexture this$0;
                {
                    this.$i$inlined = n;
                    this.this$0 = arrayTexture;
                }

                public final void m_83909_() {
                    boolean bl = false;
                    GL46.glActiveTexture((int)(33984 + this.$i$inlined));
                    ArrayTexture.access$bind(this.this$0);
                }
            });
        }
    }

    public static /* synthetic */ void setAsShaderTexture$default(ArrayTexture arrayTexture, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAsShaderTexture");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        arrayTexture.setAsShaderTexture(n);
    }

    public final void close() {
        ArrayTexture this_$iv = this;
        boolean $i$f$onRenderThread = false;
        if (RenderSystem.isOnRenderThread()) {
            boolean bl = false;
            this.closed = true;
            TextureUtil.releaseTextureId((int)this.getId());
            this.freeRAM();
            this.id = -1;
        } else {
            RenderSystem.recordRenderCall((RenderCall)new RenderCall(this){
                final /* synthetic */ ArrayTexture this$0;
                {
                    this.this$0 = arrayTexture;
                }

                public final void m_83909_() {
                    boolean bl = false;
                    ArrayTexture.access$setClosed$p(this.this$0, true);
                    TextureUtil.releaseTextureId((int)this.this$0.getId());
                    this.this$0.freeRAM();
                    ArrayTexture.access$setId$p(this.this$0, -1);
                }
            });
        }
    }

    public final void freeRAM() {
        if (this.ptr == -1L) {
            return;
        }
        MemoryUtil.nmemFree((long)this.ptr);
        this.ptr = -1L;
    }

    @Override
    protected void onFinalize() {
        if (this.closed) {
            return;
        }
        this.close();
    }

    public final void blit(@NotNull PoseStack pose, int frameNum, int x, int y, int uWidth, int vHeight, float u0, float u1, float v0, float v1) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        this.setAsShaderTexture(0);
        this.innerDraw(pose, this.numLayers, frameNum, new Vector3d(x, y, 0), new Vector3d(x, y + vHeight, 0), new Vector3d(x + uWidth, y + vHeight, 0), new Vector3d(x + uWidth, y, 0), u0, u1, v0, v1);
    }

    public static /* synthetic */ void blit$default(ArrayTexture arrayTexture, PoseStack poseStack, int n, int n2, int n3, int n4, int n5, float f, float f2, float f3, float f4, int n6, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: blit");
        }
        if ((n6 & 0x40) != 0) {
            f = 0.0f;
        }
        if ((n6 & 0x80) != 0) {
            f2 = 1.0f;
        }
        if ((n6 & 0x100) != 0) {
            f3 = 0.0f;
        }
        if ((n6 & 0x200) != 0) {
            f4 = 1.0f;
        }
        arrayTexture.blit(poseStack, n, n2, n3, n4, n5, f, f2, f3, f4);
    }

    public final void draw(@NotNull PoseStack pose, int frameNum, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float u0, float u1, float v0, float v1) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
        Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
        this.setAsShaderTexture(0);
        this.innerDraw(pose, this.numLayers, frameNum, lu, ld, rd, ru, u0, u1, v0, v1);
    }

    public static /* synthetic */ void draw$default(ArrayTexture arrayTexture, PoseStack poseStack, int n, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, float f, float f2, float f3, float f4, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n2 & 0x40) != 0) {
            f = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 0x100) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x200) != 0) {
            f4 = 1.0f;
        }
        arrayTexture.draw(poseStack, n, vector3d, vector3d2, vector3d3, vector3d4, f, f2, f3, f4);
    }

    public final void innerDraw(@NotNull PoseStack pose, int maxLayers, int currentLayer, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float minU, float maxU, float minV, float maxV) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
        Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
        RenderTypes.INSTANCE.getTextureArrayFull().setupRenderState();
        Uniform uniform = RenderTypes.INSTANCE.getTextureArrayFull().getUniform("MaxLayers");
        Intrinsics.checkNotNull((Object)uniform);
        uniform.m_142617_(maxLayers);
        Uniform uniform2 = RenderTypes.INSTANCE.getTextureArrayFull().getUniform("CurrentLayer");
        Intrinsics.checkNotNull((Object)uniform2);
        uniform2.m_142617_(currentLayer);
        RenderTypes.INSTANCE.getTextureArrayFull().setSampler("texture_array", -1);
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, RenderTypes.INSTANCE.getVERTEX_FORMAT());
        Intrinsics.checkNotNull((Object)bufferBuilder);
        VertexConsumer vertexConsumer = (VertexConsumer)bufferBuilder;
        Intrinsics.checkNotNull((Object)matrix4f);
        RenderingUtils.Quad.drawQuad(vertexConsumer, matrix4f, 255, 255, 255, 255, 0, 0, lu, ld, rd, ru, minU, maxU, minV, maxV);
        tesselator.m_85914_();
        RenderTypes.INSTANCE.getTextureArrayFull().clearRenderState();
    }
}

