/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering.textures;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.spaceeye.vmod.rendering.textures.GIFTexture;
import net.spaceeye.vmod.utils.Vector3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010JV\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\b\b\u0002\u0010 \u001a\u00020\u00102\b\b\u0002\u0010!\u001a\u00020\u00102\b\b\u0002\u0010\"\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u0010JV\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020&2\b\b\u0002\u0010 \u001a\u00020\u00102\b\b\u0002\u0010!\u001a\u00020\u00102\b\b\u0002\u0010\"\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u0010J\b\u0010*\u001a\u00020\u0019H\u0016J\u0006\u0010+\u001a\u00020\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lnet/spaceeye/vmod/rendering/textures/AnimatedGIFTexture;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "gif", "Lnet/spaceeye/vmod/rendering/textures/GIFTexture;", "<init>", "(Lnet/spaceeye/vmod/rendering/textures/GIFTexture;)V", "getGif", "()Lnet/spaceeye/vmod/rendering/textures/GIFTexture;", "currentFrame", "", "getCurrentFrame", "()I", "setCurrentFrame", "(I)V", "time", "", "getTime", "()F", "setTime", "(F)V", "advanceTime", "", "delta", "blit", "", "pose", "Lcom/mojang/blaze3d/vertex/PoseStack;", "x", "y", "uWidth", "vHeight", "u0", "u1", "v0", "v1", "draw", "lu", "Lnet/spaceeye/vmod/utils/Vector3d;", "ld", "rd", "ru", "close", "reset", "VMod"})
public final class AnimatedGIFTexture
implements AutoCloseable {
    @NotNull
    private final GIFTexture gif;
    private int currentFrame;
    private float time;

    public AnimatedGIFTexture(@NotNull GIFTexture gif) {
        Intrinsics.checkNotNullParameter((Object)((Object)gif), (String)"gif");
        this.gif = gif;
    }

    @NotNull
    public final GIFTexture getGif() {
        return this.gif;
    }

    public final int getCurrentFrame() {
        return this.currentFrame;
    }

    public final void setCurrentFrame(int n) {
        this.currentFrame = n;
    }

    public final float getTime() {
        return this.time;
    }

    public final void setTime(float f) {
        this.time = f;
    }

    public final boolean advanceTime(float delta) {
        if (!this.gif.getLoadedSuccessfully().isDone() || !this.gif.getLoadedSuccessfully().get().booleanValue()) {
            return false;
        }
        this.time += delta / 10.0f;
        int delay2 = this.gif.getSprites().get(this.currentFrame / this.gif.getFramesPerSprite()).getDelays()[this.currentFrame % this.gif.getFramesPerSprite()];
        if (this.time <= (float)delay2) {
            return false;
        }
        if (this.time > 100.0f) {
            this.time = 0.0f;
        }
        do {
            this.time -= (float)delay2;
            int n = this.currentFrame;
            this.currentFrame = n + 1;
            if (this.currentFrame < this.gif.getTotalFrames()) continue;
            this.currentFrame = 0;
        } while (!(this.time <= (float)(delay2 = this.gif.getSprites().get(this.currentFrame / this.gif.getFramesPerSprite()).getDelays()[this.currentFrame % this.gif.getFramesPerSprite()])));
        return true;
    }

    public final void blit(@NotNull PoseStack pose, int x, int y, int uWidth, int vHeight, float u0, float u1, float v0, float v1) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        this.gif.blit(pose, this.currentFrame, x, y, uWidth, vHeight, u0, u1, v0, v1);
    }

    public static /* synthetic */ void blit$default(AnimatedGIFTexture animatedGIFTexture, PoseStack poseStack, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            f = 0.0f;
        }
        if ((n5 & 0x40) != 0) {
            f2 = 1.0f;
        }
        if ((n5 & 0x80) != 0) {
            f3 = 0.0f;
        }
        if ((n5 & 0x100) != 0) {
            f4 = 1.0f;
        }
        animatedGIFTexture.blit(poseStack, n, n2, n3, n4, f, f2, f3, f4);
    }

    public final void draw(@NotNull PoseStack pose, @NotNull Vector3d lu, @NotNull Vector3d ld, @NotNull Vector3d rd, @NotNull Vector3d ru, float u0, float u1, float v0, float v1) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)lu, (String)"lu");
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        Intrinsics.checkNotNullParameter((Object)rd, (String)"rd");
        Intrinsics.checkNotNullParameter((Object)ru, (String)"ru");
        this.gif.draw(pose, this.currentFrame, lu, ld, rd, ru, u0, u1, v0, v1);
    }

    public static /* synthetic */ void draw$default(AnimatedGIFTexture animatedGIFTexture, PoseStack poseStack, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 0x20) != 0) {
            f = 0.0f;
        }
        if ((n & 0x40) != 0) {
            f2 = 1.0f;
        }
        if ((n & 0x80) != 0) {
            f3 = 0.0f;
        }
        if ((n & 0x100) != 0) {
            f4 = 1.0f;
        }
        animatedGIFTexture.draw(poseStack, vector3d, vector3d2, vector3d3, vector3d4, f, f2, f3, f4);
    }

    @Override
    public void close() {
        this.gif.close();
    }

    public final void reset() {
        this.currentFrame = 0;
        this.time = 0.0f;
    }
}

