/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import dev.architectury.networking.NetworkManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.spaceeye.vmod.events.PersistentEvents;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.networking.SynchronisedDataTransmitter;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.rendering.types.PositionDependentRenderer;
import net.spaceeye.vmod.utils.ClosableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J)\u0010\u0012\u001a\u00020\t\"\f\b\u0000\u0010\u0013*\u00020\u0002*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\u0004\u0018\u00010\u0006\"\f\b\u0000\u0010\u0013*\u00020\u0002*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData;", "Lnet/spaceeye/vmod/networking/SynchronisedDataTransmitter;", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "<init>", "()V", "nextPage", "", "idToPage", "", "", "dimToCPosToPage", "", "Lnet/minecraft/world/level/ChunkPos;", "playerUpdates", "", "Ljava/util/UUID;", "getPlayerUpdates", "()Ljava/util/Set;", "addRenderer", "T", "Lnet/spaceeye/vmod/rendering/types/PositionDependentRenderer;", "dimensionId", "render", "(Ljava/lang/String;Lnet/spaceeye/vmod/rendering/types/BaseRenderer;)I", "setRenderer", "id", "renderer", "(ILnet/spaceeye/vmod/rendering/types/BaseRenderer;)Ljava/lang/Long;", "removeRenderer", "(I)Ljava/lang/Long;", "getRenderer", "players", "Lnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData$PlayerState;", "PlayerState", "VMod"})
@SourceDebugExtension(value={"SMAP\nWorldSynchronisedRenderingData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldSynchronisedRenderingData.kt\nnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData\n+ 2 SynchronisedData.kt\nnet/spaceeye/vmod/networking/SynchronisedDataTransmitter\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 RandomExtensionFunctions.kt\nnet/spaceeye/vmod/utils/RandomExtensionFunctionsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n55#2:99\n55#2:108\n55#2:110\n55#2:112\n55#2:122\n1#3:100\n1#3:109\n1#3:111\n1#3:113\n1#3:123\n381#4,7:101\n381#4,7:115\n381#4,7:124\n381#4,7:134\n14#5:114\n1863#6,2:131\n1863#6:133\n1864#6:141\n*S KotlinDebug\n*F\n+ 1 WorldSynchronisedRenderingData.kt\nnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData\n*L\n28#1:99\n36#1:108\n42#1:110\n48#1:112\n75#1:122\n28#1:100\n36#1:109\n42#1:111\n48#1:113\n75#1:123\n30#1:101,7\n66#1:115,7\n77#1:124,7\n90#1:134,7\n64#1:114\n89#1:131,2\n90#1:133\n90#1:141\n*E\n"})
public final class ServerWorldSynchronisedRenderingData
extends SynchronisedDataTransmitter<BaseRenderer> {
    private long nextPage;
    @NotNull
    private Map<Integer, Long> idToPage = new LinkedHashMap();
    @NotNull
    private final Map<String, Map<ChunkPos, Long>> dimToCPosToPage = new LinkedHashMap();
    @NotNull
    private final Set<UUID> playerUpdates = new LinkedHashSet();
    @NotNull
    private Map<UUID, PlayerState> players = new LinkedHashMap();

    public ServerWorldSynchronisedRenderingData() {
        super("world_rendering_data", NetworkManager.Side.C2S, NetworkManager.Side.S2C, 1000000, (Function2<? super FriendlyByteBuf, ? super Serializable, Unit>)((Function2)1.INSTANCE), (Function1<? super FriendlyByteBuf, ? extends Serializable>)((Function1)2.INSTANCE));
        ClosableKt.addCustomServerClosable((Function0<Unit>)((Function0)() -> ServerWorldSynchronisedRenderingData._init_$lambda$6(this)));
        PersistentEvents.INSTANCE.getServerOnTick().on((Function2<PersistentEvents.ServerOnTick, Function0<Unit>, Unit>)((Function2)(arg_0, arg_1) -> ServerWorldSynchronisedRenderingData._init_$lambda$13(this, arg_0, arg_1)));
    }

    @NotNull
    public final Set<UUID> getPlayerUpdates() {
        return this.playerUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends BaseRenderer> int addRenderer(@NotNull String dimensionId, @NotNull T render) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        Intrinsics.checkNotNullParameter(render, (String)"render");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            Object object;
            Map map2;
            Object answer$iv;
            boolean bl = false;
            boolean bl2 = false;
            ChunkPos cpos = ((PositionDependentRenderer)((Object)render)).getRenderingPosition().toChunkPos();
            Map<String, Object> $this$getOrPut$iv = this.dimToCPosToPage;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(dimensionId);
            if (value$iv == null) {
                boolean bl3 = false;
                answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(dimensionId, answer$iv);
                map2 = answer$iv;
            } else {
                map2 = value$iv;
            }
            $this$getOrPut$iv = map2;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(cpos);
            if (value$iv == null) {
                boolean bl4 = false;
                long l = this.nextPage;
                this.nextPage = l + 1L;
                answer$iv = l;
                $this$getOrPut$iv.put((String)cpos, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            long page = ((Number)object).longValue();
            int id2 = this.add$VMod(page, render);
            Integer n = id2;
            Long l = page;
            this.idToPage.put(n, l);
            int n2 = id2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T extends BaseRenderer> Long setRenderer(int id2, @NotNull T renderer) {
        Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            Long l = this.idToPage.get(id2);
            if (l == null) {
                Long l2 = null;
                return l2;
            }
            long l3 = l;
            long page = l3;
            this.set$VMod(page, id2, renderer);
            Long l4 = page;
            return l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Long removeRenderer(int id2) {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            Long l = this.idToPage.get(id2);
            if (l == null) {
                Long l2 = null;
                return l2;
            }
            long l3 = l;
            long page = l3;
            this.idToPage.remove(id2);
            Long l4 = this.remove$VMod(page, id2) ? Long.valueOf(page) : null;
            return l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final BaseRenderer getRenderer(int id2) {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            Long l = this.idToPage.get(id2);
            if (l == null) {
                BaseRenderer baseRenderer = null;
                return baseRenderer;
            }
            long l2 = l;
            long page = l2;
            Map map2 = this.get$VMod(page);
            BaseRenderer baseRenderer = map2 != null ? (BaseRenderer)map2.get(id2) : null;
            return baseRenderer;
        }
    }

    private static final Unit _init_$lambda$6(ServerWorldSynchronisedRenderingData this$0) {
        this$0.close();
        this$0.players.clear();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$13(ServerWorldSynchronisedRenderingData this$0, PersistentEvents.ServerOnTick serverOnTick, Function0 function0) {
        Intrinsics.checkNotNullParameter((Object)serverOnTick, (String)"<destruct>");
        Intrinsics.checkNotNullParameter((Object)function0, (String)"<unused var>");
        MinecraftServer server = serverOnTick.component1();
        int viewDistance = server.m_6846_().m_11312_();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            PlayerState state;
            Object object;
            void $this$getOrPut$iv;
            BlockPos $this$toChunkPos$iv;
            ServerLevel level = player.m_284548_();
            Intrinsics.checkNotNull((Object)level);
            String playerDimension = VSGameUtilsKt.getDimensionId((Level)((Level)level));
            Intrinsics.checkNotNullExpressionValue((Object)player.m_20183_(), (String)"blockPosition(...)");
            boolean $i$f$toChunkPos22 = false;
            ChunkPos curCPos = new ChunkPos($this$toChunkPos$iv);
            Map<UUID, PlayerState> $i$f$toChunkPos22 = this$0.players;
            UUID key$iv = player.m_20148_();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                PlayerState answer$iv = new PlayerState("", new ChunkPos(-999999999, -999999999));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (!Intrinsics.areEqual((Object)(state = (PlayerState)object).getDimension(), (Object)playerDimension)) {
                state.setDimension(playerDimension);
                state.setLastCPos(new ChunkPos(-999999999, -999999999));
            }
            if (Intrinsics.areEqual((Object)state.getLastCPos(), (Object)curCPos) || this$0.dimToCPosToPage.get(playerDimension) == null) continue;
            state.setLastCPos(curCPos);
            SynchronisedDataTransmitter this_$iv = this$0;
            boolean $i$f$lock = false;
            ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
            synchronized (reentrantLock) {
                long it;
                Object object2;
                void $this$getOrPut$iv2;
                boolean bl = false;
                boolean bl2 = false;
                this$0.getUuidToPlayer().put(player.m_20148_(), (Player)player);
                Map<UUID, Map<Long, Map<Integer, byte[]>>> map2 = this$0.getSubscribersSavedChecksums();
                UUID key$iv2 = player.m_20148_();
                boolean $i$f$getOrPut22 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl3 = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                Map playerCached = (Map)object2;
                Set oldCached = playerCached.keySet();
                Set renderPages = new LinkedHashSet();
                Iterator $i$f$getOrPut22 = ChunkPos.m_45596_((ChunkPos)curCPos, (int)viewDistance).iterator();
                while ($i$f$getOrPut22.hasNext()) {
                    Map<ChunkPos, Long> cPosToPage;
                    ChunkPos cPos = (ChunkPos)$i$f$getOrPut22.next();
                    Long l = cPosToPage.get(cPos);
                    if (l == null) {
                        continue;
                    }
                    long page = l;
                    renderPages.add(page);
                }
                Set toRemove = CollectionsKt.subtract((Iterable)oldCached, (Iterable)renderPages);
                Set toAdd = CollectionsKt.subtract((Iterable)renderPages, (Iterable)oldCached);
                Iterable $this$forEach$iv = toRemove;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((Number)element$iv).longValue();
                    boolean bl4 = false;
                    playerCached.remove(it);
                }
                $this$forEach$iv = toAdd;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$getOrPut$iv3;
                    it = ((Number)element$iv).longValue();
                    boolean bl5 = false;
                    Map map3 = playerCached;
                    Long key$iv3 = it;
                    boolean $i$f$getOrPut3 = false;
                    Object value$iv3 = $this$getOrPut$iv3.get(key$iv3);
                    if (value$iv3 != null) continue;
                    boolean bl6 = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv3.put(key$iv3, answer$iv);
                }
                if (!((Collection)toRemove).isEmpty() || !((Collection)toAdd).isEmpty()) {
                    Set<UUID> set = this$0.playerUpdates;
                    UUID uUID = player.m_20148_();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                    set.add(uUID);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData$PlayerState;", "", "dimension", "", "lastCPos", "Lnet/minecraft/world/level/ChunkPos;", "<init>", "(Ljava/lang/String;Lnet/minecraft/world/level/ChunkPos;)V", "getDimension", "()Ljava/lang/String;", "setDimension", "(Ljava/lang/String;)V", "getLastCPos", "()Lnet/minecraft/world/level/ChunkPos;", "setLastCPos", "(Lnet/minecraft/world/level/ChunkPos;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "VMod"})
    private static final class PlayerState {
        @NotNull
        private String dimension;
        @NotNull
        private ChunkPos lastCPos;

        public PlayerState(@NotNull String dimension, @NotNull ChunkPos lastCPos) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)lastCPos, (String)"lastCPos");
            this.dimension = dimension;
            this.lastCPos = lastCPos;
        }

        @NotNull
        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.dimension = string;
        }

        @NotNull
        public final ChunkPos getLastCPos() {
            return this.lastCPos;
        }

        public final void setLastCPos(@NotNull ChunkPos chunkPos) {
            Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"<set-?>");
            this.lastCPos = chunkPos;
        }

        @NotNull
        public final String component1() {
            return this.dimension;
        }

        @NotNull
        public final ChunkPos component2() {
            return this.lastCPos;
        }

        @NotNull
        public final PlayerState copy(@NotNull String dimension, @NotNull ChunkPos lastCPos) {
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)lastCPos, (String)"lastCPos");
            return new PlayerState(dimension, lastCPos);
        }

        public static /* synthetic */ PlayerState copy$default(PlayerState playerState, String string, ChunkPos chunkPos, int n, Object object) {
            if ((n & 1) != 0) {
                string = playerState.dimension;
            }
            if ((n & 2) != 0) {
                chunkPos = playerState.lastCPos;
            }
            return playerState.copy(string, chunkPos);
        }

        @NotNull
        public String toString() {
            return "PlayerState(dimension=" + this.dimension + ", lastCPos=" + this.lastCPos + ")";
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = result * 31 + this.lastCPos.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerState)) {
                return false;
            }
            PlayerState playerState = (PlayerState)other;
            if (!Intrinsics.areEqual((Object)this.dimension, (Object)playerState.dimension)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lastCPos, (Object)playerState.lastCPos);
        }
    }
}

