/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.spaceeye.vmod.networking.Serializable;
import net.spaceeye.vmod.networking.SynchronisedDataTransmitter;
import net.spaceeye.vmod.rendering.ReservedRenderingPages;
import net.spaceeye.vmod.rendering.ServerWorldSynchronisedRenderingData;
import net.spaceeye.vmod.rendering.types.BaseRenderer;
import net.spaceeye.vmod.rendering.types.PositionDependentRenderer;
import net.spaceeye.vmod.rendering.types.TimedRenderer;
import net.spaceeye.vmod.utils.ClosableKt;
import net.spaceeye.vmod.utils.GetNow_msKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002J(\u0010\u0012\u001a\u00020\u000b2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002J2\u0010\u0016\u001a\u00020\u000b2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u00022\u0010\b\u0002\u0010\u0017\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`\u0019J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData;", "Lnet/spaceeye/vmod/networking/SynchronisedDataTransmitter;", "Lnet/spaceeye/vmod/rendering/types/BaseRenderer;", "<init>", "()V", "worldRenderingData", "Lnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData;", "getWorldRenderingData$VMod", "()Lnet/spaceeye/vmod/rendering/ServerWorldSynchronisedRenderingData;", "idToPages", "", "", "", "", "setUpdated", "", "id", "renderer", "setRenderer", "shipIds", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "addRenderer", "dimensionId", "", "Lorg/valkyrienskies/core/api/world/properties/DimensionId;", "removeRenderer", "getRenderer", "trimTimedRenderers", "", "addTimedRenderer", "subscribePlayerToReservedPages", "player", "Lnet/minecraft/server/level/ServerPlayer;", "VMod"})
@SourceDebugExtension(value={"SMAP\nSynchronisedRenderingData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SynchronisedRenderingData.kt\nnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData\n+ 2 SynchronisedData.kt\nnet/spaceeye/vmod/networking/SynchronisedDataTransmitter\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n55#2:263\n55#2:265\n55#2:271\n55#2:277\n55#2:286\n55#2:291\n55#2:295\n1#3:264\n1#3:266\n1#3:270\n1#3:272\n1#3:276\n1#3:278\n1#3:287\n1#3:289\n1#3:292\n1#3:296\n774#4:267\n865#4,2:268\n774#4:273\n865#4,2:274\n1557#4:279\n1628#4,3:280\n1755#4,3:283\n1863#4:288\n1864#4:290\n1863#4,2:293\n1863#4,2:297\n*S KotlinDebug\n*F\n+ 1 SynchronisedRenderingData.kt\nnet/spaceeye/vmod/rendering/ServerSynchronisedRenderingData\n*L\n106#1:263\n116#1:265\n128#1:271\n141#1:277\n151#1:286\n160#1:291\n177#1:295\n106#1:264\n116#1:266\n128#1:272\n141#1:278\n151#1:287\n160#1:292\n177#1:296\n117#1:267\n117#1:268,2\n129#1:273\n129#1:274,2\n148#1:279\n148#1:280,3\n148#1:283,3\n156#1:288\n156#1:290\n172#1:293,2\n183#1:297,2\n*E\n"})
public final class ServerSynchronisedRenderingData
extends SynchronisedDataTransmitter<BaseRenderer> {
    @NotNull
    private final ServerWorldSynchronisedRenderingData worldRenderingData;
    @NotNull
    private Map<Integer, Set<Long>> idToPages;

    public ServerSynchronisedRenderingData() {
        super("rendering_data", NetworkManager.Side.C2S, NetworkManager.Side.S2C, 1000000, (Function2<? super FriendlyByteBuf, ? super Serializable, Unit>)((Function2)1.INSTANCE), (Function1<? super FriendlyByteBuf, ? extends Serializable>)((Function1)2.INSTANCE));
        ClosableKt.addCustomServerClosable((Function0<Unit>)((Function0)() -> ServerSynchronisedRenderingData._init_$lambda$0(this)));
        TickEvent.SERVER_PRE.register(arg_0 -> ServerSynchronisedRenderingData._init_$lambda$1(this, arg_0));
        this.worldRenderingData = new ServerWorldSynchronisedRenderingData();
        this.idToPages = new LinkedHashMap();
    }

    @NotNull
    public final ServerWorldSynchronisedRenderingData getWorldRenderingData$VMod() {
        return this.worldRenderingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setUpdated(int id2, @NotNull BaseRenderer renderer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl2;
            block7: {
                Set<Long> pages;
                block8: {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Set<Long> set = this.idToPages.get(id2);
                    if (set == null) {
                        bl2 = false;
                        break block7;
                    }
                    pages = set;
                    if (!pages.contains(-1L)) break block8;
                    if (!(renderer instanceof PositionDependentRenderer)) {
                        throw new RuntimeException("World Renderers should implement PositionDependentRenderer");
                    }
                    boolean bl5 = this.worldRenderingData.setRenderer(id2, renderer) != null;
                    return bl5;
                }
                this.set$VMod(pages, id2, (Serializable)renderer);
                boolean bl6 = true;
                return bl6;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int setRenderer(@NotNull List<Long> shipIds, int id2, @NotNull BaseRenderer renderer) {
        Intrinsics.checkNotNullParameter(shipIds, (String)"shipIds");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            List list;
            block8: {
                block9: {
                    void $this$filterTo$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    Iterable $this$filter$iv = shipIds;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        long it = ((Number)element$iv$iv).longValue();
                        boolean bl3 = false;
                        if (!(it != -1L)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List it = list = (List)destination$iv$iv;
                    boolean bl4 = false;
                    if (!it.isEmpty()) break block8;
                    if (!(renderer instanceof PositionDependentRenderer)) {
                        throw new RuntimeException("World Renderers should implement PositionDependentRenderer");
                    }
                    Long l = this.worldRenderingData.setRenderer(id2, renderer);
                    if (l != null) {
                        l.longValue();
                        break block9;
                    }
                    int n = id2;
                    return n;
                }
                Integer n = id2;
                this.idToPages.put(n, SetsKt.setOf((Object)-1L));
                int n2 = id2;
                return n2;
            }
            Set idsToUse = CollectionsKt.toSet((Iterable)list);
            this.set$VMod(idsToUse, id2, (Serializable)renderer);
            Integer n = id2;
            this.idToPages.put(n, idsToUse);
            int n3 = id2;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int addRenderer(@NotNull List<Long> shipIds, @NotNull BaseRenderer renderer, @Nullable String dimensionId) {
        Intrinsics.checkNotNullParameter(shipIds, (String)"shipIds");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            Iterable $this$filter$iv;
            block7: {
                void $this$filterTo$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                $this$filter$iv = shipIds;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    long it = ((Number)element$iv$iv).longValue();
                    boolean bl3 = false;
                    if (!(it != -1L)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable it = $this$filter$iv = (List)destination$iv$iv;
                boolean bl4 = false;
                if (!it.isEmpty() && (it.size() != 1 || !it.contains(-1L))) break block7;
                if (!(renderer instanceof PositionDependentRenderer)) {
                    throw new RuntimeException("World Renderers should implement PositionDependentRenderer");
                }
                if (dimensionId == null) {
                    throw new RuntimeException("World Renderers need non-null dimensionId");
                }
                int id2 = this.worldRenderingData.addRenderer(dimensionId, renderer);
                Integer n = id2;
                this.idToPages.put(n, SetsKt.setOf((Object)-1L));
                int n2 = id2;
                return n2;
            }
            Set idsToUse = CollectionsKt.toSet((Iterable)$this$filter$iv);
            int id3 = this.add$VMod(idsToUse, (Serializable)renderer);
            Integer n = id3;
            this.idToPages.put(n, idsToUse);
            int n3 = id3;
            return n3;
        }
    }

    public static /* synthetic */ int addRenderer$default(ServerSynchronisedRenderingData serverSynchronisedRenderingData, List list, BaseRenderer baseRenderer, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return serverSynchronisedRenderingData.addRenderer(list, baseRenderer, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean removeRenderer(int id2) {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl;
            block11: {
                void $this$any$iv;
                void $this$mapTo$iv$iv;
                Set<Long> pageIds;
                block10: {
                    Set<Long> set;
                    block9: {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (this.idToPages.get(id2) != null) break block9;
                        boolean bl4 = false;
                        return bl4;
                    }
                    pageIds = set;
                    this.idToPages.remove(id2);
                    if (!pageIds.contains(-1L)) break block10;
                    boolean bl5 = this.worldRenderingData.removeRenderer(id2) != null;
                    return bl5;
                }
                Iterable $this$map$iv = pageIds;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void pageId;
                    long l = ((Number)item$iv$iv).longValue();
                    Collection collection = destination$iv$iv;
                    boolean bl6 = false;
                    collection.add(this.remove$VMod((long)pageId, id2));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl7 = false;
                        if (!it) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean bl8 = bl;
            return bl8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final BaseRenderer getRenderer(int id2) {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            long pageId;
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            Set<Long> set = this.idToPages.get(id2);
            if (set == null) {
                return null;
            }
            Set<Long> pagesId = set;
            if (pagesId.contains(-1L)) {
                return this.worldRenderingData.getRenderer(id2);
            }
            Iterable $this$forEach$iv = pagesId;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                Object element$iv = iterator.next();
                pageId = ((Number)element$iv).longValue();
                boolean bl3 = false;
            } while ((object = this.get$VMod(pageId)) == null || (object = (BaseRenderer)object.get(id2)) == null);
            Object it = object;
            boolean bl4 = false;
            return it;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void trimTimedRenderers() {
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            Map map2 = this.get$VMod(-2L);
            if (map2 == null) {
                return;
            }
            Map page = map2;
            if (page.isEmpty()) {
                return;
            }
            List toRemove = new ArrayList();
            long current = GetNow_msKt.getNow_ms();
            try {
                for (Map.Entry entry2 : page.entrySet()) {
                    int k = ((Number)entry2.getKey()).intValue();
                    BaseRenderer item = (BaseRenderer)entry2.getValue();
                    if (!(item instanceof TimedRenderer)) {
                        toRemove.add(k);
                        continue;
                    }
                    if (((TimedRenderer)((Object)item)).getTimestampOfBeginning() + ((TimedRenderer)((Object)item)).getActiveFor_ms() >= current) continue;
                    toRemove.add(k);
                }
                Iterable $this$forEach$iv = toRemove;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    this.remove$VMod(-2L, it);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int addTimedRenderer(@NotNull BaseRenderer renderer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        SynchronisedDataTransmitter this_$iv = this;
        boolean $i$f$lock = false;
        ReentrantLock reentrantLock = SynchronisedDataTransmitter.access$getLock(this_$iv);
        synchronized (reentrantLock) {
            boolean bl = false;
            boolean bl2 = false;
            this.trimTimedRenderers();
            n = this.add$VMod(-2L, (Serializable)renderer);
        }
        return n;
    }

    public final void subscribePlayerToReservedPages(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterable $this$forEach$iv = ReservedRenderingPages.INSTANCE.getReservedPages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            UUID uUID = player.m_20148_();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.subscribeTo$VMod(uUID, (Player)player, it);
        }
    }

    private static final Unit _init_$lambda$0(ServerSynchronisedRenderingData this$0) {
        this$0.close();
        this$0.idToPages.clear();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(ServerSynchronisedRenderingData this$0, MinecraftServer it) {
        this$0.synchronizeUpdates();
        this$0.worldRenderingData.synchronizeUpdates();
        this$0.worldRenderingData.completeSynchronize(this$0.worldRenderingData.getPlayerUpdates());
    }
}

