/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.spaceeye.vmod.mixin.BlockRenderDispatcherAccessor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001eR\u001b\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000f\u001a\n \u0006*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lnet/spaceeye/vmod/rendering/RenderingStuff;", "", "<init>", "()V", "blockRenderer", "Lnet/minecraft/client/renderer/block/BlockRenderDispatcher;", "kotlin.jvm.PlatformType", "getBlockRenderer", "()Lnet/minecraft/client/renderer/block/BlockRenderDispatcher;", "Lnet/minecraft/client/renderer/block/BlockRenderDispatcher;", "blockBuffer", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "getBlockBuffer", "()Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "random", "Lnet/minecraft/util/RandomSource;", "Lnet/minecraft/util/RandomSource;", "renderSingleBlock", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "color", "Ljava/awt/Color;", "VMod"})
@SourceDebugExtension(value={"SMAP\nCustomRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomRendering.kt\nnet/spaceeye/vmod/rendering/RenderingStuff\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n13402#2:209\n13403#2:212\n1863#3,2:210\n1863#3,2:213\n*S KotlinDebug\n*F\n+ 1 CustomRendering.kt\nnet/spaceeye/vmod/rendering/RenderingStuff\n*L\n65#1:209\n65#1:212\n66#1:210,2\n71#1:213,2\n*E\n"})
public final class RenderingStuff {
    @NotNull
    public static final RenderingStuff INSTANCE = new RenderingStuff();
    private static final BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
    private static final MultiBufferSource.BufferSource blockBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
    private static final RandomSource random = RandomSource.m_216327_();

    private RenderingStuff() {
    }

    public final BlockRenderDispatcher getBlockRenderer() {
        return blockRenderer;
    }

    public final MultiBufferSource.BufferSource getBlockBuffer() {
        return blockBuffer;
    }

    public final void renderSingleBlock(@NotNull BlockState state, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay, @NotNull Color color) {
        RenderShape renderShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        RenderShape renderShape2 = renderShape = state.m_60799_();
        switch (renderShape2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[renderShape2.ordinal()]) {
            case 1: {
                BakedModel bakedModel = blockRenderer.m_110910_(state);
                Intrinsics.checkNotNullExpressionValue((Object)bakedModel, (String)"getBlockModel(...)");
                BakedModel bakedModel2 = bakedModel;
                VertexConsumer consumer = bufferSource.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)false));
                PoseStack.Pose pose = poseStack.m_85850_();
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                Intrinsics.checkNotNullExpressionValue((Object)LevelRenderer.f_109434_, (String)"DIRECTIONS");
                Object $this$forEach$iv = LevelRenderer.f_109434_;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Direction direction = (Direction)element$iv;
                    boolean bl = false;
                    List list = bakedModel2.m_213637_(state, direction, random);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        BakedQuad quad = (BakedQuad)element$iv2;
                        boolean bl2 = false;
                        consumer.m_85987_(pose, quad, r, g, b, packedLight, packedOverlay);
                    }
                }
                List list = bakedModel2.m_213637_(state, null, random);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getQuads(...)");
                $this$forEach$iv = list;
                $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    BakedQuad quad = (BakedQuad)element$iv;
                    boolean bl = false;
                    consumer.m_85987_(pose, quad, r, g, b, packedLight, packedOverlay);
                }
                break;
            }
            case 2: {
                BlockRenderDispatcher blockRenderDispatcher = blockRenderer;
                Intrinsics.checkNotNull((Object)blockRenderDispatcher, (String)"null cannot be cast to non-null type net.spaceeye.vmod.mixin.BlockRenderDispatcherAccessor");
                ((BlockRenderDispatcherAccessor)blockRenderDispatcher).getBlockEntityRenderer().m_108829_(new ItemStack((ItemLike)state.m_60734_()), ItemDisplayContext.NONE, poseStack, bufferSource, packedLight, packedOverlay);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void renderSingleBlock$default(RenderingStuff renderingStuff, BlockState blockState, PoseStack poseStack, MultiBufferSource multiBufferSource, int n, int n2, Color color, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            color = new Color(255, 255, 255, 255);
        }
        renderingStuff.renderSingleBlock(blockState, poseStack, multiBufferSource, n, n2, color);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenderShape.values().length];
            try {
                nArray[RenderShape.MODEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderShape.ENTITYBLOCK_ANIMATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderShape.INVISIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

