/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.gif;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import net.spaceeye.vmod.gif.GIFMetadata;
import org.w3c.dom.Node;

public class GIFStreamMetadata
extends GIFMetadata {
    static final String nativeMetadataFormatName = "javax_imageio_gif_stream_1.0";
    static final String[] versionStrings = new String[]{"87a", "89a"};
    public String version;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int colorResolution;
    public int pixelAspectRatio;
    public int backgroundColorIndex;
    public boolean sortFlag;
    static final String[] colorTableSizes = new String[]{"2", "4", "8", "16", "32", "64", "128", "256"};
    public byte[] globalColorTable = null;

    protected GIFStreamMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        super(standardMetadataFormatSupported, nativeMetadataFormatName, nativeMetadataFormatClassName, extraMetadataFormatNames, extraMetadataFormatClassNames);
    }

    public GIFStreamMetadata() {
        this(true, nativeMetadataFormatName, "com.sun.imageio.plugins.gif.GIFStreamMetadataFormat", null, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node2 = new IIOMetadataNode("Version");
        node2.setAttribute("value", this.version);
        root.appendChild(node2);
        node2 = new IIOMetadataNode("LogicalScreenDescriptor");
        node2.setAttribute("logicalScreenWidth", this.logicalScreenWidth == -1 ? "" : Integer.toString(this.logicalScreenWidth));
        node2.setAttribute("logicalScreenHeight", this.logicalScreenHeight == -1 ? "" : Integer.toString(this.logicalScreenHeight));
        node2.setAttribute("colorResolution", this.colorResolution == -1 ? "" : Integer.toString(this.colorResolution));
        node2.setAttribute("pixelAspectRatio", Integer.toString(this.pixelAspectRatio));
        root.appendChild(node2);
        if (this.globalColorTable != null) {
            node2 = new IIOMetadataNode("GlobalColorTable");
            int numEntries = this.globalColorTable.length / 3;
            node2.setAttribute("sizeOfGlobalColorTable", Integer.toString(numEntries));
            node2.setAttribute("backgroundColorIndex", Integer.toString(this.backgroundColorIndex));
            node2.setAttribute("sortFlag", this.sortFlag ? "TRUE" : "FALSE");
            for (int i2 = 0; i2 < numEntries; ++i2) {
                IIOMetadataNode entry2 = new IIOMetadataNode("ColorTableEntry");
                entry2.setAttribute("index", Integer.toString(i2));
                int r = this.globalColorTable[3 * i2] & 0xFF;
                int g = this.globalColorTable[3 * i2 + 1] & 0xFF;
                int b = this.globalColorTable[3 * i2 + 2] & 0xFF;
                entry2.setAttribute("red", Integer.toString(r));
                entry2.setAttribute("green", Integer.toString(g));
                entry2.setAttribute("blue", Integer.toString(b));
                node2.appendChild(entry2);
            }
            root.appendChild(node2);
        }
        return root;
    }

    @Override
    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("ColorSpaceType");
        node2.setAttribute("name", "RGB");
        chroma_node.appendChild(node2);
        node2 = new IIOMetadataNode("BlackIsZero");
        node2.setAttribute("value", "TRUE");
        chroma_node.appendChild(node2);
        if (this.globalColorTable != null) {
            node2 = new IIOMetadataNode("Palette");
            int numEntries = this.globalColorTable.length / 3;
            for (int i2 = 0; i2 < numEntries; ++i2) {
                IIOMetadataNode entry2 = new IIOMetadataNode("PaletteEntry");
                entry2.setAttribute("index", Integer.toString(i2));
                entry2.setAttribute("red", Integer.toString(this.globalColorTable[3 * i2] & 0xFF));
                entry2.setAttribute("green", Integer.toString(this.globalColorTable[3 * i2 + 1] & 0xFF));
                entry2.setAttribute("blue", Integer.toString(this.globalColorTable[3 * i2 + 2] & 0xFF));
                node2.appendChild(entry2);
            }
            chroma_node.appendChild(node2);
            node2 = new IIOMetadataNode("BackgroundIndex");
            node2.setAttribute("value", Integer.toString(this.backgroundColorIndex));
            chroma_node.appendChild(node2);
        }
        return chroma_node;
    }

    @Override
    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("CompressionTypeName");
        node2.setAttribute("value", "lzw");
        compression_node.appendChild(node2);
        node2 = new IIOMetadataNode("Lossless");
        node2.setAttribute("value", "TRUE");
        compression_node.appendChild(node2);
        return compression_node;
    }

    @Override
    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("SampleFormat");
        node2.setAttribute("value", "Index");
        data_node.appendChild(node2);
        node2 = new IIOMetadataNode("BitsPerSample");
        node2.setAttribute("value", this.colorResolution == -1 ? "" : Integer.toString(this.colorResolution));
        data_node.appendChild(node2);
        return data_node;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("PixelAspectRatio");
        float aspectRatio = 1.0f;
        if (this.pixelAspectRatio != 0) {
            aspectRatio = (float)(this.pixelAspectRatio + 15) / 64.0f;
        }
        node2.setAttribute("value", Float.toString(aspectRatio));
        dimension_node.appendChild(node2);
        node2 = new IIOMetadataNode("ImageOrientation");
        node2.setAttribute("value", "Normal");
        dimension_node.appendChild(node2);
        node2 = new IIOMetadataNode("HorizontalScreenSize");
        node2.setAttribute("value", this.logicalScreenWidth == -1 ? "" : Integer.toString(this.logicalScreenWidth));
        dimension_node.appendChild(node2);
        node2 = new IIOMetadataNode("VerticalScreenSize");
        node2.setAttribute("value", this.logicalScreenHeight == -1 ? "" : Integer.toString(this.logicalScreenHeight));
        dimension_node.appendChild(node2);
        return dimension_node;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode document_node = new IIOMetadataNode("Document");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("FormatVersion");
        node2.setAttribute("value", this.version);
        document_node.appendChild(node2);
        return document_node;
    }

    @Override
    public IIOMetadataNode getStandardTextNode() {
        return null;
    }

    @Override
    public IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    @Override
    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    protected void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    protected void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

