/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod.gif;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import kotlin.NotImplementedError;
import net.spaceeye.vmod.gif.GIFImageMetadata;
import net.spaceeye.vmod.gif.GIFStreamMetadata;
import net.spaceeye.vmod.utils.UnsafeGetter;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

public class GIFImageReader
extends ImageReader {
    ImageInputStream stream = null;
    boolean gotHeader = false;
    GIFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    GIFImageMetadata imageMetadata = null;
    List<Long> imageStartPosition = new ArrayList<Long>();
    int imageMetadataLength;
    int numImages = -1;
    byte[] block = new byte[255];
    int blockLength = 0;
    int bitPos = 0;
    int nextByte = 0;
    int initCodeSize;
    int clearCode;
    int eofCode;
    int next32Bits = 0;
    boolean lastBlockFound = false;
    BufferedImage theImage = null;
    WritableRaster theTile = null;
    int width = -1;
    int height = -1;
    int streamX = -1;
    int streamY = -1;
    int rowsDone = 0;
    int interlacePass = 0;
    private byte[] fallbackColorTable = null;
    static final int[] interlaceIncrement = new int[]{8, 8, 4, 2, -1};
    static final int[] interlaceOffset = new int[]{0, 4, 2, 1, -1};
    private final Unsafe unsafe = UnsafeGetter.getUnsafe();
    List<ImageTypeSpecifier> imageTypeSpecifierList = new ArrayList<ImageTypeSpecifier>(1);
    Rectangle sourceRegion;
    Point destinationOffset;
    Rectangle destinationRegion;
    boolean decodeThisRow = true;
    int destY = 0;
    byte[] rowBuf;
    int currentIndex = 0;
    int[] prefix = new int[4096];
    byte[] suffix = new byte[4096];
    byte[] initial = new byte[4096];
    int[] length = new int[4096];
    byte[] string = new byte[4096];
    ImageReadParam defaultReadParam = this.getDefaultReadParam();
    private static byte[] defaultPalette = null;

    public GIFImageReader(ImageReaderSpi originatingProvider) throws NoSuchFieldException, IllegalAccessException {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input != null) {
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)input;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && allowSearch) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (allowSearch) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = imageIndex;
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        if (this.currentIndex - 1 == imageIndex && this.imageMetadata != null) {
            return this.imageMetadata.imageWidth;
        }
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageWidth;
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        if (this.currentIndex - 1 == imageIndex && this.imageMetadata != null) {
            return this.imageMetadata.imageHeight;
        }
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageHeight;
    }

    private ImageTypeSpecifier createIndexed(byte[] r, byte[] g, byte[] b, int bits) {
        SampleModel sampleModel;
        IndexColorModel colorModel;
        if (this.imageMetadata.transparentColorFlag) {
            int idx = Math.min(this.imageMetadata.transparentColorIndex, r.length - 1);
            colorModel = new IndexColorModel(bits, r.length, r, g, b, idx);
        } else {
            colorModel = new IndexColorModel(bits, r.length, r, g, b);
        }
        if (bits == 8) {
            int[] bandOffsets = new int[]{0};
            sampleModel = new PixelInterleavedSampleModel(0, 1, 1, 1, 1, bandOffsets);
        } else {
            sampleModel = new MultiPixelPackedSampleModel(0, 1, 1, bits);
        }
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        int length;
        byte[] colorTable;
        if (this.currentIndex - 1 != imageIndex || this.imageMetadata == null) {
            this.checkIndex(imageIndex);
            int index = this.locateImage(imageIndex);
            if (index != imageIndex) {
                throw new IndexOutOfBoundsException();
            }
            this.readMetadata();
        }
        if (this.imageMetadata.localColorTable != null) {
            colorTable = this.imageMetadata.localColorTable;
            this.fallbackColorTable = this.imageMetadata.localColorTable;
        } else {
            colorTable = this.streamMetadata.globalColorTable;
        }
        if (colorTable == null) {
            if (this.fallbackColorTable == null) {
                this.processWarningOccurred("Use default color table.");
                this.fallbackColorTable = GIFImageReader.getDefaultPalette();
            }
            colorTable = this.fallbackColorTable;
        }
        int bits = (length = colorTable.length / 3) == 2 ? 1 : (length == 4 ? 2 : (length == 8 || length == 16 ? 4 : 8));
        int lutLength = 1 << bits;
        byte[] r = new byte[lutLength];
        byte[] g = new byte[lutLength];
        byte[] b = new byte[lutLength];
        int rgbIndex = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            r[i2] = colorTable[rgbIndex++];
            g[i2] = colorTable[rgbIndex++];
            b[i2] = colorTable[rgbIndex++];
        }
        if (this.imageTypeSpecifierList.isEmpty()) {
            this.imageTypeSpecifierList.add(this.createIndexed(r, g, b, bits));
        } else {
            this.imageTypeSpecifierList.set(0, this.createIndexed(r, g, b, bits));
        }
        return this.imageTypeSpecifierList.iterator();
    }

    private byte[] getColorTable(int imageIndex) throws IIOException {
        byte[] colorTable;
        if (this.currentIndex - 1 != imageIndex || this.imageMetadata == null) {
            this.checkIndex(imageIndex);
            int index = this.locateImage(imageIndex);
            if (index != imageIndex) {
                throw new IndexOutOfBoundsException();
            }
            this.readMetadata();
        }
        if (this.imageMetadata.localColorTable != null) {
            colorTable = this.imageMetadata.localColorTable;
            this.fallbackColorTable = this.imageMetadata.localColorTable;
        } else {
            colorTable = this.streamMetadata.globalColorTable;
        }
        if (colorTable == null) {
            if (this.fallbackColorTable == null) {
                this.processWarningOccurred("Use default color table.");
                this.fallbackColorTable = GIFImageReader.getDefaultPalette();
            }
            colorTable = this.fallbackColorTable;
        }
        return colorTable;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    @Override
    public GIFStreamMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    @Override
    public GIFImageMetadata getImageMetadata(int imageIndex) throws IIOException {
        if (this.currentIndex - 1 == imageIndex && this.imageMetadata != null) {
            return this.imageMetadata;
        }
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException("Bad image index!");
        }
        this.readMetadata();
        return this.imageMetadata;
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int codeSize, int codeMask) throws IOException {
        if (this.bitPos + codeSize > 32) {
            return this.eofCode;
        }
        int code = this.next32Bits >> this.bitPos & codeMask;
        this.bitPos += codeSize;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                int nbytes;
                this.blockLength = this.stream.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return code;
                }
                int off = 0;
                for (int left2 = this.blockLength; left2 > 0; left2 -= nbytes) {
                    nbytes = this.stream.read(this.block, off, left2);
                    if (nbytes == -1) {
                        throw new IIOException("Invalid block length for LZW encoded image data");
                    }
                    off += nbytes;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return code;
    }

    public void initializeStringTable(int[] prefix, byte[] suffix, byte[] initial, int[] length) {
        int i2;
        int numEntries = 1 << this.initCodeSize;
        for (i2 = 0; i2 < numEntries; ++i2) {
            prefix[i2] = -1;
            suffix[i2] = (byte)i2;
            initial[i2] = (byte)i2;
            length[i2] = 1;
        }
        for (i2 = numEntries; i2 < 4096; ++i2) {
            prefix[i2] = -1;
            length[i2] = 1;
        }
    }

    private void computeDecodeThisRow() {
        this.decodeThisRow = this.destY < this.destinationRegion.y + this.destinationRegion.height && this.streamY >= this.sourceRegion.y && this.streamY < this.sourceRegion.y + this.sourceRegion.height;
    }

    private void outputPixels(byte[] string, int len) {
        if (this.imageMetadata.interlaceFlag && (this.interlacePass < 0 || this.interlacePass > 3)) {
            return;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (this.streamX >= this.sourceRegion.x) {
                this.rowBuf[this.streamX - this.sourceRegion.x] = string[i2];
            }
            ++this.streamX;
            if (this.streamX != this.width) continue;
            ++this.rowsDone;
            if (this.decodeThisRow) {
                int width = Math.min(this.sourceRegion.width, this.destinationRegion.width);
                int destX = this.destinationRegion.x;
                this.theTile.setDataElements(destX, this.destY, width, 1, this.rowBuf);
            }
            this.streamX = 0;
            if (this.imageMetadata.interlaceFlag) {
                this.streamY += interlaceIncrement[this.interlacePass];
                if (this.streamY >= this.height) {
                    ++this.interlacePass;
                    if (this.interlacePass > 3) {
                        return;
                    }
                    this.streamY = interlaceOffset[this.interlacePass];
                }
            } else {
                ++this.streamY;
            }
            this.destY = this.destinationRegion.y + this.streamY - this.sourceRegion.y;
            this.computeDecodeThisRow();
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new GIFStreamMetadata();
        try {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[] signature = new byte[6];
            this.stream.readFully(signature);
            StringBuilder version = new StringBuilder(3);
            version.append((char)signature[3]);
            version.append((char)signature[4]);
            version.append((char)signature[5]);
            this.streamMetadata.version = version.toString();
            this.streamMetadata.logicalScreenWidth = this.stream.readUnsignedShort();
            this.streamMetadata.logicalScreenHeight = this.stream.readUnsignedShort();
            int packedFields = this.stream.readUnsignedByte();
            boolean globalColorTableFlag = (packedFields & 0x80) != 0;
            this.streamMetadata.colorResolution = (packedFields >> 4 & 7) + 1;
            this.streamMetadata.sortFlag = (packedFields & 8) != 0;
            int numGCTEntries = 1 << (packedFields & 7) + 1;
            this.streamMetadata.backgroundColorIndex = this.stream.readUnsignedByte();
            this.streamMetadata.pixelAspectRatio = this.stream.readUnsignedByte();
            if (globalColorTableFlag) {
                this.streamMetadata.globalColorTable = new byte[3 * numGCTEntries];
                this.stream.readFully(this.streamMetadata.globalColorTable);
            } else {
                this.streamMetadata.globalColorTable = null;
            }
            this.imageStartPosition.add(this.stream.getStreamPosition());
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading header!", e);
        }
        this.gotHeader = true;
    }

    private boolean skipImage() throws IIOException {
        try {
            while (true) {
                int length;
                int blockType;
                if ((blockType = this.stream.readUnsignedByte()) == 44) {
                    this.stream.skipBytes(8);
                    int packedFields = this.stream.readUnsignedByte();
                    if ((packedFields & 0x80) != 0) {
                        int bits = (packedFields & 7) + 1;
                        this.stream.skipBytes(3 * (1 << bits));
                    }
                    this.stream.skipBytes(1);
                    length = 0;
                    do {
                        length = this.stream.readUnsignedByte();
                        this.stream.skipBytes(length);
                    } while (length > 0);
                    return true;
                }
                if (blockType == 59) {
                    return false;
                }
                if (blockType == 33) {
                    int label = this.stream.readUnsignedByte();
                    length = 0;
                    do {
                        length = this.stream.readUnsignedByte();
                        this.stream.skipBytes(length);
                    } while (length > 0);
                    continue;
                }
                if (blockType == 0) {
                    return false;
                }
                int length2 = 0;
                do {
                    length2 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(length2);
                } while (length2 > 0);
            }
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            throw new IIOException("I/O error locating image!", e);
        }
    }

    private int locateImage(int imageIndex) throws IIOException {
        this.readHeader();
        try {
            int index;
            Long l = this.imageStartPosition.get(index);
            this.stream.seek(l);
            for (index = Math.min(imageIndex, this.imageStartPosition.size() - 1); index < imageIndex; ++index) {
                if (!this.skipImage()) {
                    return --index;
                }
                Long l1 = this.stream.getStreamPosition();
                this.imageStartPosition.add(l1);
            }
        }
        catch (IOException e) {
            throw new IIOException("Couldn't seek!", e);
        }
        if (this.currIndex != imageIndex) {
            this.imageMetadata = null;
        }
        this.currIndex = imageIndex;
        return imageIndex;
    }

    private byte[] concatenateBlocks() throws IOException {
        int length;
        byte[] data = new byte[]{};
        while ((length = this.stream.readUnsignedByte()) != 0) {
            byte[] newData = new byte[data.length + length];
            System.arraycopy(data, 0, newData, 0, data.length);
            this.stream.readFully(newData, data.length, length);
            data = newData;
        }
        return data;
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        try {
            int blockType;
            this.imageMetadata = new GIFImageMetadata();
            long startPosition = this.stream.getStreamPosition();
            while (true) {
                int length;
                if ((blockType = this.stream.readUnsignedByte()) == 44) {
                    this.imageMetadata.imageLeftPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageTopPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.imageHeight = this.stream.readUnsignedShort();
                    int idPackedFields = this.stream.readUnsignedByte();
                    boolean localColorTableFlag = (idPackedFields & 0x80) != 0;
                    this.imageMetadata.interlaceFlag = (idPackedFields & 0x40) != 0;
                    this.imageMetadata.sortFlag = (idPackedFields & 0x20) != 0;
                    int numLCTEntries = 1 << (idPackedFields & 7) + 1;
                    if (localColorTableFlag) {
                        this.imageMetadata.localColorTable = new byte[3 * numLCTEntries];
                        this.stream.readFully(this.imageMetadata.localColorTable);
                    } else {
                        this.imageMetadata.localColorTable = null;
                    }
                    this.imageMetadataLength = (int)(this.stream.getStreamPosition() - startPosition);
                    return;
                }
                if (blockType != 33) break;
                int label = this.stream.readUnsignedByte();
                if (label == 249) {
                    int gceLength = this.stream.readUnsignedByte();
                    int gcePackedFields = this.stream.readUnsignedByte();
                    this.imageMetadata.disposalMethod = gcePackedFields >> 2 & 3;
                    this.imageMetadata.userInputFlag = (gcePackedFields & 2) != 0;
                    this.imageMetadata.transparentColorFlag = (gcePackedFields & 1) != 0;
                    this.imageMetadata.delayTime = this.stream.readUnsignedShort();
                    this.imageMetadata.transparentColorIndex = this.stream.readUnsignedByte();
                    int n = this.stream.readUnsignedByte();
                    continue;
                }
                if (label == 1) {
                    int length2 = this.stream.readUnsignedByte();
                    this.imageMetadata.hasPlainTextExtension = true;
                    this.imageMetadata.textGridLeft = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridTop = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridHeight = this.stream.readUnsignedShort();
                    this.imageMetadata.characterCellWidth = this.stream.readUnsignedByte();
                    this.imageMetadata.characterCellHeight = this.stream.readUnsignedByte();
                    this.imageMetadata.textForegroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.textBackgroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.text = this.concatenateBlocks();
                    continue;
                }
                if (label == 254) {
                    byte[] comment = this.concatenateBlocks();
                    if (this.imageMetadata.comments == null) {
                        this.imageMetadata.comments = new ArrayList<byte[]>();
                    }
                    this.imageMetadata.comments.add(comment);
                    continue;
                }
                if (label == 255) {
                    int blockSize = this.stream.readUnsignedByte();
                    byte[] applicationID = new byte[8];
                    byte[] authCode = new byte[3];
                    byte[] blockData = new byte[blockSize];
                    this.stream.readFully(blockData);
                    int offset2 = this.copyData(blockData, 0, applicationID);
                    offset2 = this.copyData(blockData, offset2, authCode);
                    byte[] applicationData = this.concatenateBlocks();
                    if (offset2 < blockSize) {
                        int len = blockSize - offset2;
                        byte[] data = new byte[len + applicationData.length];
                        System.arraycopy(blockData, offset2, data, 0, len);
                        System.arraycopy(applicationData, 0, data, len, applicationData.length);
                        applicationData = data;
                    }
                    if (this.imageMetadata.applicationIDs == null) {
                        this.imageMetadata.applicationIDs = new ArrayList<byte[]>();
                        this.imageMetadata.authenticationCodes = new ArrayList<byte[]>();
                        this.imageMetadata.applicationData = new ArrayList<byte[]>();
                    }
                    this.imageMetadata.applicationIDs.add(applicationID);
                    this.imageMetadata.authenticationCodes.add(authCode);
                    this.imageMetadata.applicationData.add(applicationData);
                    continue;
                }
                do {
                    length = this.stream.readUnsignedByte();
                    this.stream.skipBytes(length);
                } while (length > 0);
            }
            if (blockType == 59) {
                throw new IndexOutOfBoundsException("Attempt to read past end of image sequence!");
            }
            throw new IIOException("Unexpected block type " + blockType + "!");
        }
        catch (IIOException iioe) {
            throw iioe;
        }
        catch (IOException ioe) {
            throw new IIOException("I/O error reading image metadata!", ioe);
        }
    }

    private int copyData(byte[] src, int offset2, byte[] dst) {
        int len = dst.length;
        int rest = src.length - offset2;
        if (len > rest) {
            len = rest;
        }
        System.arraycopy(src, offset2, dst, 0, len);
        return offset2 + len;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) {
        throw new NotImplementedError("Use GIFImageReader.readNext");
    }

    @Nullable
    public BufferedImage readNext(int frameWidth, int frameHeight, int bufferFrameStartPos, ByteBuffer textureBuffer, int prevBufferFrameStartPos, ByteBuffer prevTextureBuffer) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        int imageIndex = this.currentIndex++;
        this.readMetadata();
        this.width = this.imageMetadata.imageWidth;
        this.height = this.imageMetadata.imageHeight;
        int disposal = this.imageMetadata.disposalMethod;
        if (disposal <= 1 && !this.imageMetadata.interlaceFlag) {
            this.directBufferWrite(bufferFrameStartPos, textureBuffer, prevBufferFrameStartPos, prevTextureBuffer, imageIndex, frameWidth, frameHeight);
            return null;
        }
        Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
        this.theImage = GIFImageReader.getDestination(this.defaultReadParam, imageTypes, this.width, this.height);
        this.theTile = this.theImage.getWritableTile(0, 0);
        this.streamX = 0;
        this.streamY = 0;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        GIFImageReader.computeRegions(this.defaultReadParam, this.width, this.height, this.theImage, this.sourceRegion, this.destinationRegion);
        this.destinationOffset = new Point(this.destinationRegion.x, this.destinationRegion.y);
        this.destY = this.destinationRegion.y + this.streamY - this.sourceRegion.y;
        this.computeDecodeThisRow();
        if (this.rowBuf == null || this.rowBuf.length < this.width) {
            this.rowBuf = new byte[this.width];
        }
        try {
            this.readFrameDataAndInit();
            int NULL_CODE = -1;
            int oldCode = -1;
            int tableIndex = (1 << this.initCodeSize) + 2;
            int codeSize = this.initCodeSize + 1;
            int codeMask = (1 << codeSize) - 1;
            while (true) {
                int code;
                if ((code = this.getCode(codeSize, codeMask)) == this.clearCode) {
                    this.initializeStringTable(this.prefix, this.suffix, this.initial, this.length);
                    tableIndex = (1 << this.initCodeSize) + 2;
                    codeSize = this.initCodeSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    code = this.getCode(codeSize, codeMask);
                    if (code == this.eofCode) {
                        return this.theImage;
                    }
                } else {
                    int newSuffixIndex;
                    if (code == this.eofCode) {
                        return this.theImage;
                    }
                    if (code < tableIndex) {
                        newSuffixIndex = code;
                    } else {
                        newSuffixIndex = oldCode;
                        if (code != tableIndex) {
                            this.processWarningOccurred("Out-of-sequence code!");
                        }
                    }
                    if (-1 != oldCode && tableIndex < 4096) {
                        this.prefix[tableIndex] = oldCode;
                        this.suffix[tableIndex] = this.initial[newSuffixIndex];
                        this.initial[tableIndex] = this.initial[oldCode];
                        this.length[tableIndex] = this.length[oldCode] + 1;
                        if (++tableIndex == 1 << codeSize && tableIndex < 4096) {
                            codeMask = (1 << ++codeSize) - 1;
                        }
                    }
                }
                int c = code;
                int len = this.length[c];
                for (int i2 = len - 1; i2 >= 0; --i2) {
                    this.string[i2] = this.suffix[c];
                    c = this.prefix[c];
                }
                this.outputPixels(this.string, len);
                oldCode = code;
            }
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading image!", e);
        }
    }

    private void readFrameDataAndInit() throws IOException {
        this.initCodeSize = this.stream.readUnsignedByte();
        if (this.initCodeSize < 1 || this.initCodeSize > 8) {
            throw new IIOException("Bad code size:" + this.initCodeSize);
        }
        int left2 = this.blockLength = this.stream.readUnsignedByte();
        int off = 0;
        while (left2 > 0) {
            int nbytes = this.stream.read(this.block, off, left2);
            if (nbytes == -1) {
                throw new IIOException("Invalid block length for LZW encoded image data");
            }
            left2 -= nbytes;
            off += nbytes;
        }
        this.bitPos = 0;
        this.nextByte = 0;
        this.lastBlockFound = false;
        this.interlacePass = 0;
        this.initNext32Bits();
        this.clearCode = 1 << this.initCodeSize;
        this.eofCode = this.clearCode + 1;
        this.initializeStringTable(this.prefix, this.suffix, this.initial, this.length);
    }

    private void directBufferWrite(int bufferFrameStartPos, ByteBuffer textureBuffer, int prevBufferFrameStartPos, ByteBuffer prevTextureBuffer, int imageIndex, int frameWidth, int frameHeight) throws IIOException {
        try {
            int x = this.imageMetadata.imageLeftPosition;
            int y = this.imageMetadata.imageTopPosition;
            byte[] colorTable = this.getColorTable(imageIndex);
            int transparentColorIdx = Math.min(this.imageMetadata.transparentColorIndex * 3, colorTable.length - 1);
            int opaque = -1;
            int endX = x + this.width;
            int endY = y + this.height;
            boolean doDecode = true;
            this.readFrameDataAndInit();
            int NULL_CODE = -1;
            int oldCode = -1;
            int tableIndex = (1 << this.initCodeSize) + 2;
            int codeSize = this.initCodeSize + 1;
            int codeMask = (1 << codeSize) - 1;
            int bufferLen = 0;
            int bufferPos = 0;
            int streamX = 0;
            int streamY = 0;
            long bufferOffset = MemoryUtil.memAddress((ByteBuffer)textureBuffer) + (long)bufferFrameStartPos;
            long prevBufferOffset = MemoryUtil.memAddress((ByteBuffer)prevTextureBuffer) + (long)prevBufferFrameStartPos;
            boolean hasAlpha = prevBufferFrameStartPos < 0 ? false : this.imageMetadata.transparentColorFlag;
            while (true) {
                boolean canDecode;
                boolean bl = canDecode = doDecode && streamY >= y && streamY < endY && streamX >= x && streamX < endX;
                if (canDecode && bufferPos >= bufferLen) {
                    int code = this.getCode(codeSize, codeMask);
                    if (code == this.clearCode) {
                        this.initializeStringTable(this.prefix, this.suffix, this.initial, this.length);
                        tableIndex = (1 << this.initCodeSize) + 2;
                        codeSize = this.initCodeSize + 1;
                        codeMask = (1 << codeSize) - 1;
                        code = this.getCode(codeSize, codeMask);
                        if (code == this.eofCode) {
                            doDecode = false;
                            canDecode = false;
                        }
                    } else if (code == this.eofCode) {
                        doDecode = false;
                        canDecode = false;
                    } else {
                        int newSuffixIndex;
                        if (code < tableIndex) {
                            newSuffixIndex = code;
                        } else {
                            newSuffixIndex = oldCode;
                            if (code != tableIndex) {
                                this.processWarningOccurred("Out-of-sequence code!");
                            }
                        }
                        if (-1 != oldCode && tableIndex < 4096) {
                            this.prefix[tableIndex] = oldCode;
                            this.suffix[tableIndex] = this.initial[newSuffixIndex];
                            this.initial[tableIndex] = this.initial[oldCode];
                            this.length[tableIndex] = this.length[oldCode] + 1;
                            if (++tableIndex == 1 << codeSize && tableIndex < 4096) {
                                codeMask = (1 << ++codeSize) - 1;
                            }
                        }
                    }
                    if (doDecode) {
                        oldCode = code;
                        bufferLen = this.length[code];
                        bufferPos = 0;
                        for (int i2 = bufferLen - 1; i2 >= 0; --i2) {
                            this.string[i2] = this.suffix[code];
                            code = this.prefix[code];
                        }
                    }
                }
                if (canDecode) {
                    int colorIndex = Byte.toUnsignedInt(this.string[bufferPos++]) * 3;
                    if (hasAlpha && transparentColorIdx == colorIndex) {
                        this.unsafe.putByte(bufferOffset++, this.unsafe.getByte(prevBufferOffset++));
                        this.unsafe.putByte(bufferOffset++, this.unsafe.getByte(prevBufferOffset++));
                        this.unsafe.putByte(bufferOffset++, this.unsafe.getByte(prevBufferOffset++));
                        this.unsafe.putByte(bufferOffset++, (byte)-1);
                        ++prevBufferOffset;
                    } else {
                        this.unsafe.putByte(bufferOffset++, colorTable[colorIndex++]);
                        this.unsafe.putByte(bufferOffset++, colorTable[colorIndex++]);
                        this.unsafe.putByte(bufferOffset++, colorTable[colorIndex]);
                        this.unsafe.putByte(bufferOffset++, (byte)-1);
                        prevBufferOffset += 4L;
                    }
                } else {
                    this.unsafe.putByte(bufferOffset++, this.unsafe.getByte(prevBufferOffset++));
                    this.unsafe.putByte(bufferOffset++, this.unsafe.getByte(prevBufferOffset++));
                    this.unsafe.putByte(bufferOffset++, this.unsafe.getByte(prevBufferOffset++));
                    this.unsafe.putByte(bufferOffset++, (byte)-1);
                    ++prevBufferOffset;
                }
                if (++streamX < frameWidth) continue;
                streamX = 0;
                if (++streamY >= frameHeight) break;
            }
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading image!", e);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.imageStartPosition = new ArrayList<Long>();
        this.numImages = -1;
        this.gotHeader = false;
        this.streamMetadata = null;
        this.resetStreamSettingsWithoutMetadata();
    }

    public void resetStreamSettingsWithoutMetadata() {
        this.currIndex = -1;
        this.imageMetadata = null;
        this.blockLength = 0;
        this.bitPos = 0;
        this.nextByte = 0;
        this.next32Bits = 0;
        this.lastBlockFound = false;
        this.theImage = null;
        this.theTile = null;
        this.width = -1;
        this.height = -1;
        this.streamX = -1;
        this.streamY = -1;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.fallbackColorTable = null;
        this.currentIndex = 0;
    }

    private static synchronized byte[] getDefaultPalette() {
        if (defaultPalette == null) {
            BufferedImage img = new BufferedImage(1, 1, 13);
            IndexColorModel icm = (IndexColorModel)img.getColorModel();
            int size = icm.getMapSize();
            byte[] r = new byte[size];
            byte[] g = new byte[size];
            byte[] b = new byte[size];
            icm.getReds(r);
            icm.getGreens(g);
            icm.getBlues(b);
            defaultPalette = new byte[size * 3];
            for (int i2 = 0; i2 < size; ++i2) {
                GIFImageReader.defaultPalette[3 * i2 + 0] = r[i2];
                GIFImageReader.defaultPalette[3 * i2 + 1] = g[i2];
                GIFImageReader.defaultPalette[3 * i2 + 2] = b[i2];
            }
        }
        return defaultPalette;
    }
}

