/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.vmod;

import com.google.common.primitives.Ints;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.platform.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.phys.Vec3;
import net.spaceeye.valkyrien_ship_schematics.interfaces.IShipSchematic;
import net.spaceeye.valkyrien_ship_schematics.interfaces.v1.IShipSchematicDataV1;
import net.spaceeye.vmod.VMConfig;
import net.spaceeye.vmod.VMKt;
import net.spaceeye.vmod.limits.ServerLimits;
import net.spaceeye.vmod.mixin.ChunkStorageAccessor;
import net.spaceeye.vmod.mixin.IOWorkerAccessor;
import net.spaceeye.vmod.mixin.RegionFileStorageAccessor;
import net.spaceeye.vmod.rendering.RenderingData;
import net.spaceeye.vmod.rendering.textures.GIFReader;
import net.spaceeye.vmod.rendering.types.debug.DebugRenderer;
import net.spaceeye.vmod.schematic.VModShipSchematicV2Kt;
import net.spaceeye.vmod.shipAttachments.CustomMassSave;
import net.spaceeye.vmod.shipAttachments.GravityController;
import net.spaceeye.vmod.shipAttachments.PhysgunController;
import net.spaceeye.vmod.shipAttachments.WeightSynchronizer;
import net.spaceeye.vmod.toolgun.PlayerAccessManager;
import net.spaceeye.vmod.toolgun.modes.state.PlayerSchematics;
import net.spaceeye.vmod.utils.GetNow_msKt;
import net.spaceeye.vmod.utils.Vector3d;
import net.spaceeye.vmod.utils.vs.TeleportShipWithConnectedKt;
import net.spaceeye.vmod.utils.vs.TraverseGetConnectedShipsKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.internal.world.VsiServerShipWorld;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.command.RelativeVector3Argument;
import org.valkyrienskies.mod.common.command.ShipArgument;
import org.valkyrienskies.mod.common.command.VSCommandsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJi\u0010\u000b\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u0001H\rH\r \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u0001H\rH\r\u0018\u00010\f0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010!\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010\"\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010#\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010$\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010&\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u001e\u0010)\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 2\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0016\u0010+\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010,\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010-\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010.\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u0010/\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0016\u00100\u001a\u00020\u00122\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J\u0014\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000604R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lnet/spaceeye/vmod/VMCommands;", "", "<init>", "()V", "lt", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "kotlin.jvm.PlatformType", "name", "", "(Ljava/lang/String;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "arg", "Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "T", "type", "Lcom/mojang/brigadier/arguments/ArgumentType;", "(Ljava/lang/String;Lcom/mojang/brigadier/arguments/ArgumentType;)Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "value", "", "permissionLevel", "getPermissionLevel", "()I", "setPermissionLevel", "(I)V", "permissionString", "hasPermission", "", "it", "findClosestShips", "", "Lorg/valkyrienskies/core/api/ships/Ship;", "cc", "Lcom/mojang/brigadier/context/CommandContext;", "teleportCommand", "scaleCommand", "vsDeleteMasslessShips", "saveSchemToServer", "lastName", "loadSchemFromServer", "placeUUID", "Ljava/util/UUID;", "placeServerSchematic", "customName", "setGravityFor", "setGravityForConnected", "setGravityForConnectedAndTouching", "resetGravityFor", "resetGravityForEveryShipIn", "displayShipsInOrder", "registerServerCommands", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "OP", "DEBUG", "VMod"})
@SourceDebugExtension(value={"SMAP\nVMCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,606:1\n774#2:607\n865#2,2:608\n1053#2:610\n774#2:611\n865#2,2:612\n1863#2,2:614\n1611#2,9:616\n1863#2:625\n1864#2:627\n1620#2:628\n1863#2,2:629\n1611#2,9:631\n1863#2:640\n1864#2:642\n1620#2:643\n1863#2,2:644\n1611#2,9:646\n1863#2:655\n1864#2:657\n1620#2:658\n1611#2,9:659\n1863#2:668\n1864#2:670\n1620#2:671\n1863#2,2:672\n1863#2,2:674\n1872#2,3:676\n1#3:626\n1#3:641\n1#3:656\n1#3:669\n*S KotlinDebug\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands\n*L\n110#1:607\n110#1:608,2\n111#1:610\n147#1:611\n147#1:612,2\n148#1:614,2\n224#1:616,9\n224#1:625\n224#1:627\n224#1:628\n236#1:629,2\n246#1:631,9\n246#1:640\n246#1:642\n246#1:643\n258#1:644,2\n268#1:646,9\n268#1:655\n268#1:657\n268#1:658\n280#1:659,9\n280#1:668\n280#1:670\n280#1:671\n281#1:672,2\n289#1:674,2\n206#1:676,3\n224#1:626\n246#1:641\n268#1:656\n280#1:669\n*E\n"})
public final class VMCommands {
    @NotNull
    public static final VMCommands INSTANCE = new VMCommands();
    @NotNull
    public static final String permissionString = "Allow Command Usage";
    @NotNull
    private static String lastName;
    @NotNull
    private static UUID placeUUID;

    private VMCommands() {
    }

    private final LiteralArgumentBuilder<CommandSourceStack> lt(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private final <T> RequiredArgumentBuilder<CommandSourceStack, T> arg(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public final int getPermissionLevel() {
        return VMConfig.INSTANCE.getSERVER().getPERMISSIONS().getVMOD_COMMANDS_PERMISSION_LEVEL();
    }

    public final void setPermissionLevel(int value) {
        VMConfig.INSTANCE.getSERVER().getPERMISSIONS().setVMOD_COMMANDS_PERMISSION_LEVEL(value);
    }

    private final boolean hasPermission(CommandSourceStack it) {
        ServerPlayer serverPlayer;
        try {
            serverPlayer = it.m_81375_();
        }
        catch (Exception e) {
            return false;
        }
        ServerPlayer player = serverPlayer;
        Intrinsics.checkNotNull((Object)player);
        return PlayerAccessManager.INSTANCE.hasPermission(player, permissionString);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Ship> findClosestShips(CommandContext<CommandSourceStack> cc) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel));
        Vec3 vec3 = ((CommandSourceStack)cc.getSource()).m_81371_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        org.joml.Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)vec3);
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        Iterable iterable = (Iterable)VSCommandsKt.getShipWorld((SharedSuggestionProvider)((SharedSuggestionProvider)object)).getAllShips();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ship it = (Ship)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getChunkClaimDimension(), (Object)dimensionId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(pos){
            final /* synthetic */ org.joml.Vector3d $pos$inlined;
            {
                this.$pos$inlined = vector3d;
            }

            public final int compare(T a, T b) {
                Ship it = (Ship)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getTransform().getPositionInWorld().distanceSquared((Vector3dc)this.$pos$inlined));
                it = (Ship)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getTransform().getPositionInWorld().distanceSquared((Vector3dc)this.$pos$inlined)));
            }
        });
    }

    private final int teleportCommand(CommandContext<CommandSourceStack> cc) {
        Quaterniondc quaterniondc;
        Object object = cc.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.commands.CommandSourceStack");
        CommandSourceStack source = (CommandSourceStack)object;
        Ship ship = ShipArgument.Companion.getShip(cc, "ship");
        Intrinsics.checkNotNull((Object)ship, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.ServerShip");
        ServerShip mainShip = (ServerShip)ship;
        Vec3 position = Vec3Argument.m_120844_(cc, (String)"position");
        Object object2 = cc.getSource();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type net.minecraft.commands.CommandSourceStack");
        ServerLevel serverLevel = ((CommandSourceStack)object2).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel));
        try {
            Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<net.minecraft.commands.CommandSourceStack?>");
            quaterniondc = (Quaterniondc)RelativeVector3Argument.Companion.getRelativeVector3(cc, "euler-angles").toEulerRotation(0.0, 0.0, 0.0);
        }
        catch (Exception e) {
            quaterniondc = mainShip.getTransform().getShipToWorldRotation();
        }
        Quaterniondc rotation = quaterniondc;
        ServerLevel serverLevel2 = source.m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"getLevel(...)");
        Intrinsics.checkNotNull((Object)position);
        TeleportShipWithConnectedKt.teleportShipWithConnected(serverLevel2, mainShip, new Vector3d(position), rotation, null, dimensionId);
        return 0;
    }

    private final int scaleCommand(CommandContext<CommandSourceStack> cc) {
        Object object = cc.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.commands.CommandSourceStack");
        CommandSourceStack source = (CommandSourceStack)object;
        ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        String dimensionId = VSGameUtilsKt.getDimensionId((Level)((Level)serverLevel));
        Ship ship = ShipArgument.Companion.getShip(cc, "ship");
        Intrinsics.checkNotNull((Object)ship, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.ServerShip");
        ServerShip mainShip = (ServerShip)ship;
        double scale = DoubleArgumentType.getDouble(cc, (String)"scale");
        ServerLevel serverLevel2 = source.m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"getLevel(...)");
        TeleportShipWithConnectedKt.teleportShipWithConnected(serverLevel2, mainShip, new Vector3d(mainShip.getTransform().getPositionInWorld()), mainShip.getTransform().getShipToWorldRotation(), scale, dimensionId);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int vsDeleteMasslessShips(CommandContext<CommandSourceStack> cc) {
        void $this$filterTo$iv$iv;
        VsiServerShipWorld shipObjectWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((CommandSourceStack)cc.getSource()).m_81372_());
        Iterable $this$filter$iv = (Iterable)shipObjectWorld.getAllShips();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerShip it = (ServerShip)element$iv$iv;
            boolean bl = false;
            if (!(it.getInertiaData().getMass() == 0.0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerShip it = (ServerShip)element$iv;
            boolean bl = false;
            shipObjectWorld.deleteShip(it);
        }
        return 0;
    }

    private final int saveSchemToServer(CommandContext<CommandSourceStack> cc) {
        UUID uUID;
        String name = StringArgumentType.getString(cc, (String)"name");
        try {
            uUID = ((CommandSourceStack)cc.getSource()).m_81375_().m_20148_();
        }
        catch (Exception e) {
            VMKt.ELOG("Failed to save schematic to server because user is not a player");
            return 1;
        }
        UUID uuid = uUID;
        IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.getSchematics().get(uuid);
        if (iShipSchematic == null) {
            VMCommands $this$saveSchemToServer_u24lambda_u244 = this;
            boolean bl = false;
            ((CommandSourceStack)cc.getSource()).m_81375_().m_213846_((Component)Component.m_237113_((String)"Failed to save schematic to sever because player has no schematic chosen. Choose schematic with a toolgun and try again."));
            return 1;
        }
        IShipSchematic schem = iShipSchematic;
        Intrinsics.checkNotNull((Object)name);
        PlayerSchematics.INSTANCE.saveSchematic(name, schem);
        return 0;
    }

    private final int loadSchemFromServer(CommandContext<CommandSourceStack> cc) {
        String name = StringArgumentType.getString(cc, (String)"name");
        UUID uuid = new UUID(0L, 0L);
        Path path = Paths.get("VMod-Schematics/" + name, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.loadSchematic(path);
        if (iShipSchematic == null) {
            VMCommands $this$loadSchemFromServer_u24lambda_u245 = this;
            boolean bl = false;
            VMKt.ELOG("Failed to load schematic because name doesn't exist.");
            return 1;
        }
        IShipSchematic schem = iShipSchematic;
        PlayerSchematics.INSTANCE.getSchematics().put(uuid, schem);
        lastName = name;
        return 0;
    }

    private final int placeServerSchematic(CommandContext<CommandSourceStack> cc, boolean customName) {
        String e2;
        Quaterniond quaterniond;
        UUID uuid = new UUID(0L, 0L);
        Vec3 position = Vec3Argument.m_120844_(cc, (String)"position");
        try {
            Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<net.minecraft.commands.CommandSourceStack?>");
            quaterniond = RelativeVector3Argument.Companion.getRelativeVector3(cc, "rotation").toEulerRotation(0.0, 0.0, 0.0);
        }
        catch (Exception e2) {
            quaterniond = new Quaterniond();
        }
        Quaterniond rotation = quaterniond;
        try {
            e2 = StringArgumentType.getString(cc, (String)"name");
        }
        catch (Exception e3) {
            e2 = lastName;
        }
        String name = e2;
        IShipSchematic iShipSchematic = PlayerSchematics.INSTANCE.getSchematics().get(uuid);
        if (iShipSchematic == null) {
            VMCommands $this$placeServerSchematic_u24lambda_u246 = this;
            boolean bl = false;
            VMKt.ELOG("failed to place schematic because it's null.");
            return 1;
        }
        IShipSchematic schem = iShipSchematic;
        placeUUID = new UUID(placeUUID.getMostSignificantBits(), placeUUID.getLeastSignificantBits() + 1L);
        IShipSchematicDataV1 iShipSchematicDataV1 = (IShipSchematicDataV1)schem;
        ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
        Intrinsics.checkNotNull((Object)position);
        VModShipSchematicV2Kt.placeAt$default(iShipSchematicDataV1, serverLevel, null, placeUUID, new Vector3d(position).toJomlVector3d(), (Quaterniondc)rotation, null, arg_0 -> VMCommands.placeServerSchematic$lambda$8(customName, name, arg_0), 32, null);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int setGravityFor(CommandContext<CommandSourceStack> cc) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        QueryableShipData loaded = VSCommandsKt.getShipWorld((SharedSuggestionProvider)((SharedSuggestionProvider)object)).getLoadedShips();
        double x = DoubleArgumentType.getDouble(cc, (String)"x");
        double y = DoubleArgumentType.getDouble(cc, (String)"y");
        double z = DoubleArgumentType.getDouble(cc, (String)"z");
        Iterable iterable = ships;
        boolean $i$f$mapNotNull = false;
        void var12_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Ship it = (Ship)element$iv$iv;
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int setGravityForConnected(CommandContext<CommandSourceStack> cc) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        QueryableShipData loaded = VSCommandsKt.getShipWorld((SharedSuggestionProvider)((SharedSuggestionProvider)object)).getLoadedShips();
        Set traversed = new LinkedHashSet();
        Iterable $this$forEach$iv = ships;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ship it = (Ship)element$iv;
            boolean bl = false;
            if (traversed.contains(it.getId())) continue;
            traversed.addAll((Collection)TraverseGetConnectedShipsKt.traverseGetConnectedShips$default(it.getId(), traversed, false, 4, null).getTraversedShipIds());
        }
        double x = DoubleArgumentType.getDouble(cc, (String)"x");
        double y = DoubleArgumentType.getDouble(cc, (String)"y");
        double z = DoubleArgumentType.getDouble(cc, (String)"z");
        Iterable iterable = traversed;
        boolean $i$f$mapNotNull = false;
        void var13_16 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int setGravityForConnectedAndTouching(CommandContext<CommandSourceStack> cc) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        QueryableShipData loaded = VSCommandsKt.getShipWorld((SharedSuggestionProvider)((SharedSuggestionProvider)object)).getLoadedShips();
        Set traversed = new LinkedHashSet();
        Iterable $this$forEach$iv = ships;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ship it = (Ship)element$iv;
            boolean bl = false;
            if (traversed.contains(it.getId())) continue;
            Intrinsics.checkNotNull(cc, (String)"null cannot be cast to non-null type com.mojang.brigadier.context.CommandContext<net.minecraft.commands.CommandSourceStack>");
            ServerLevel serverLevel = ((CommandSourceStack)cc.getSource()).m_81372_();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
            traversed.addAll(TraverseGetConnectedShipsKt.traverseGetAllTouchingShips$default(serverLevel, it.getId(), traversed, false, 8, null));
        }
        double x = DoubleArgumentType.getDouble(cc, (String)"x");
        double y = DoubleArgumentType.getDouble(cc, (String)"y");
        double z = DoubleArgumentType.getDouble(cc, (String)"z");
        Iterable iterable = traversed;
        boolean $i$f$mapNotNull = false;
        void var13_16 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int resetGravityFor(CommandContext<CommandSourceStack> cc) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Set ships = ShipArgument.Companion.getShips(cc, "ships");
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        QueryableShipData loaded = VSCommandsKt.getShipWorld((SharedSuggestionProvider)((SharedSuggestionProvider)object)).getLoadedShips();
        Iterable iterable = ships;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LoadedShip it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Ship it = (Ship)element$iv$iv;
            boolean bl2 = false;
            if ((LoadedShip)loaded.getById(it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).reset();
        }
        return 0;
    }

    private final int resetGravityForEveryShipIn(CommandContext<CommandSourceStack> cc) {
        Object object = cc.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        QueryableShipData loaded = VSCommandsKt.getShipWorld((SharedSuggestionProvider)((SharedSuggestionProvider)object)).getLoadedShips();
        Iterable $this$forEach$iv = (Iterable)loaded;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoadedShip it = (LoadedShip)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.valkyrienskies.core.api.ships.LoadedServerShip");
            GravityController.Companion.getOrCreate((LoadedServerShip)it).reset();
        }
        return 0;
    }

    private final int displayShipsInOrder(CommandContext<CommandSourceStack> cc) {
        int e2;
        ServerPlayer serverPlayer;
        try {
            serverPlayer = ((CommandSourceStack)cc.getSource()).m_81375_();
        }
        catch (Exception e2) {
            return 1;
        }
        ServerPlayer player = serverPlayer;
        try {
            e2 = IntegerArgumentType.getInteger(cc, (String)"page") - 1;
        }
        catch (Exception e22) {
            e2 = 0;
        }
        int page = e2;
        List<Ship> ordered = this.findClosestShips(cc);
        int[] e22 = new int[]{page, ordered.size() / 10};
        int e22 = Ints.min((int[])e22);
        int n = 0;
        page = Math.max(e22, n);
        int start = page * 10;
        List ships = new ArrayList();
        Object object = new int[]{start + 10, ordered.size()};
        int i2 = Ints.min((int[])object) - 1;
        if (start <= i2) {
            while (true) {
                ships.add(ordered.get(i2));
                if (i2 == start) break;
                --i2;
            }
        }
        Object string = "";
        object = ships.iterator();
        while (object.hasNext()) {
            Ship ship = (Ship)object.next();
            BlockPos bpos = new Vector3d(ship.getTransform().getPositionInWorld()).toBlockPos();
            string = (String)string + ship.getSlug() + " |||| " + (int)ship.getTransform().getPositionInWorld().distance(player.m_20185_(), player.m_20186_(), player.m_20189_()) + " |||| x=" + bpos.m_123341_() + " y=" + bpos.m_123342_() + " z=" + bpos.m_123343_() + " \n";
        }
        string = (String)string + "Page: " + (page + 1) + "/" + (ordered.size() / 10 + 1);
        player.m_213846_((Component)Component.m_237113_((String)string));
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerServerCommands(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)this.lt("vmod").requires(VMCommands::registerServerCommands$lambda$17);
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder2 = this.lt("teleport");
        RequiredArgumentBuilder requiredArgumentBuilder = this.arg("ship", (ArgumentType)ShipArgument.Companion.ships());
        Vec3Argument vec3Argument = Vec3Argument.m_120841_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3Argument, (String)"vec3(...)");
        LiteralArgumentBuilder literalArgumentBuilder3 = (LiteralArgumentBuilder)literalArgumentBuilder.then(literalArgumentBuilder2.then(requiredArgumentBuilder.then(((RequiredArgumentBuilder)this.arg("position", (ArgumentType)vec3Argument).executes(VMCommands::registerServerCommands$lambda$18)).then(this.arg("euler-angles", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VMCommands::registerServerCommands$lambda$19)))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder4 = this.lt("scale");
        RequiredArgumentBuilder requiredArgumentBuilder2 = this.arg("ship", (ArgumentType)ShipArgument.Companion.ships());
        DoubleArgumentType doubleArgumentType = DoubleArgumentType.doubleArg((double)ServerLimits.INSTANCE.getInstance().getScale().getMinValue(), (double)ServerLimits.INSTANCE.getInstance().getScale().getMaxValue());
        Intrinsics.checkNotNullExpressionValue((Object)doubleArgumentType, (String)"doubleArg(...)");
        LiteralArgumentBuilder literalArgumentBuilder5 = (LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder3.then(literalArgumentBuilder4.then(requiredArgumentBuilder2.then(this.arg("scale", (ArgumentType)doubleArgumentType).executes(VMCommands::registerServerCommands$lambda$20))))).then(this.lt("vs-delete-massless-ships").executes(VMCommands::registerServerCommands$lambda$21));
        LiteralArgumentBuilder literalArgumentBuilder6 = (LiteralArgumentBuilder)this.lt("display-ships-in-order").executes(VMCommands::registerServerCommands$lambda$22);
        IntegerArgumentType integerArgumentType = IntegerArgumentType.integer((int)1);
        Intrinsics.checkNotNullExpressionValue((Object)integerArgumentType, (String)"integer(...)");
        LiteralArgumentBuilder literalArgumentBuilder7 = (LiteralArgumentBuilder)literalArgumentBuilder5.then(literalArgumentBuilder6.then(this.arg("page", (ArgumentType)integerArgumentType).executes(VMCommands::registerServerCommands$lambda$23)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder8 = this.lt("schem");
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder9 = this.lt("save-to-sever");
        StringArgumentType stringArgumentType = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringArgumentType, (String)"string(...)");
        LiteralArgumentBuilder literalArgumentBuilder10 = (LiteralArgumentBuilder)literalArgumentBuilder8.then(literalArgumentBuilder9.then(this.arg("name", (ArgumentType)stringArgumentType).executes(VMCommands::registerServerCommands$lambda$24)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder11 = this.lt("load-from-sever");
        StringArgumentType stringArgumentType2 = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringArgumentType2, (String)"string(...)");
        LiteralArgumentBuilder literalArgumentBuilder12 = (LiteralArgumentBuilder)literalArgumentBuilder10.then(literalArgumentBuilder11.then(this.arg("name", (ArgumentType)stringArgumentType2).executes(VMCommands::registerServerCommands$lambda$25)));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder13 = this.lt("place");
        Vec3Argument vec3Argument2 = Vec3Argument.m_120841_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3Argument2, (String)"vec3(...)");
        RequiredArgumentBuilder requiredArgumentBuilder3 = (RequiredArgumentBuilder)this.arg("position", (ArgumentType)vec3Argument2).executes(VMCommands::registerServerCommands$lambda$26);
        RequiredArgumentBuilder requiredArgumentBuilder4 = (RequiredArgumentBuilder)this.arg("rotation", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VMCommands::registerServerCommands$lambda$27);
        StringArgumentType stringArgumentType3 = StringArgumentType.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringArgumentType3, (String)"string(...)");
        LiteralArgumentBuilder literalArgumentBuilder14 = (LiteralArgumentBuilder)literalArgumentBuilder12.then(literalArgumentBuilder13.then(requiredArgumentBuilder3.then(requiredArgumentBuilder4.then(this.arg("name", (ArgumentType)stringArgumentType3).executes(VMCommands::registerServerCommands$lambda$28)))));
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder15 = this.lt("place-no-custom-name");
        Vec3Argument vec3Argument3 = Vec3Argument.m_120841_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3Argument3, (String)"vec3(...)");
        LiteralArgumentBuilder literalArgumentBuilder16 = (LiteralArgumentBuilder)literalArgumentBuilder7.then(literalArgumentBuilder14.then(literalArgumentBuilder15.then(((RequiredArgumentBuilder)this.arg("position", (ArgumentType)vec3Argument3).executes(VMCommands::registerServerCommands$lambda$29)).then(this.arg("rotation", (ArgumentType)RelativeVector3Argument.Companion.relativeVector3()).executes(VMCommands::registerServerCommands$lambda$30)))));
        LiteralArgumentBuilder literalArgumentBuilder17 = (LiteralArgumentBuilder)this.lt("op").requires(VMCommands::registerServerCommands$lambda$31);
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder18 = this.lt("set-command-permission-level");
        IntegerArgumentType integerArgumentType2 = IntegerArgumentType.integer((int)0, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)integerArgumentType2, (String)"integer(...)");
        ArgumentBuilder argumentBuilder = literalArgumentBuilder16.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder17.then(literalArgumentBuilder18.then(this.arg("level", (ArgumentType)integerArgumentType2).executes(VMCommands::registerServerCommands$lambda$32)))).then(this.lt("clear-vmod-attachments").executes(VMCommands::registerServerCommands$lambda$33))).then(this.lt("prune-shipyard-chunks").executes(VMCommands::registerServerCommands$lambda$34)));
        LiteralArgumentBuilder literalArgumentBuilder19 = (LiteralArgumentBuilder)argumentBuilder;
        CommandDispatcher<CommandSourceStack> commandDispatcher = dispatcher;
        boolean bl = false;
        if (Platform.isDevelopmentEnvironment()) {
            void it;
            it.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)INSTANCE.lt("debug").then(INSTANCE.lt("remove-debug-renderers").executes(VMCommands::registerServerCommands$lambda$38$lambda$35))).then(INSTANCE.lt("test-gif-loader").executes(VMCommands::registerServerCommands$lambda$38$lambda$36))).then(INSTANCE.lt("call-gc").executes(VMCommands::registerServerCommands$lambda$38$lambda$37)));
        }
        commandDispatcher.register((LiteralArgumentBuilder)argumentBuilder);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit placeServerSchematic$lambda$8(boolean $customName, String $name, List ships) {
        Intrinsics.checkNotNullParameter((Object)ships, (String)"ships");
        if (!$customName) {
            return Unit.INSTANCE;
        }
        if (ships.size() == 1) {
            ((ServerShip)ships.get(0)).setSlug($name);
            return Unit.INSTANCE;
        }
        Iterable $this$forEachIndexed$iv = ships;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ServerShip serverShip = (ServerShip)item$iv;
            int i2 = n;
            boolean bl = false;
            it.setSlug($name + i2);
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean registerServerCommands$lambda$17(CommandSourceStack it) {
        if (it.m_6761_(INSTANCE.getPermissionLevel())) return true;
        Intrinsics.checkNotNull((Object)it);
        if (!INSTANCE.hasPermission(it)) return false;
        return true;
    }

    private static final int registerServerCommands$lambda$18(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.teleportCommand((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$19(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.teleportCommand((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$20(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.scaleCommand((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$21(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.vsDeleteMasslessShips((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$22(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.displayShipsInOrder((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$23(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.displayShipsInOrder((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$24(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.saveSchemToServer((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$25(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.loadSchemFromServer((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$26(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, true);
    }

    private static final int registerServerCommands$lambda$27(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, true);
    }

    private static final int registerServerCommands$lambda$28(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, true);
    }

    private static final int registerServerCommands$lambda$29(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, false);
    }

    private static final int registerServerCommands$lambda$30(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.placeServerSchematic((CommandContext<CommandSourceStack>)it, false);
    }

    private static final boolean registerServerCommands$lambda$31(CommandSourceStack it) {
        return it.m_6761_(VMConfig.INSTANCE.getSERVER().getPERMISSIONS().getVMOD_OP_COMMANDS_PERMISSION_LEVEL());
    }

    private static final int registerServerCommands$lambda$32(CommandContext it) {
        INSTANCE.setPermissionLevel(IntegerArgumentType.getInteger((CommandContext)it, (String)"level"));
        return 0;
    }

    private static final int registerServerCommands$lambda$33(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return OP.INSTANCE.clearVmodAttachments((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$34(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return OP.INSTANCE.pruneShipyardChunks((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$38$lambda$35(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return DEBUG.INSTANCE.clearDebugRenderers((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$38$lambda$36(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return DEBUG.INSTANCE.testGIFLoader((CommandContext<CommandSourceStack>)it);
    }

    private static final int registerServerCommands$lambda$38$lambda$37(CommandContext it) {
        System.gc();
        return 0;
    }

    static {
        PlayerAccessManager.INSTANCE.addPermission(permissionString);
        lastName = "a";
        placeUUID = new UUID(0L, 0L);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\n"}, d2={"Lnet/spaceeye/vmod/VMCommands$DEBUG;", "", "<init>", "()V", "clearDebugRenderers", "", "cc", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "testGIFLoader", "VMod"})
    @SourceDebugExtension(value={"SMAP\nVMCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$DEBUG\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,606:1\n1863#2,2:607\n1863#2,2:609\n1797#2,3:611\n1797#2,3:614\n*S KotlinDebug\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$DEBUG\n*L\n396#1:607,2\n419#1:609,2\n424#1:611,3\n425#1:614,3\n*E\n"})
    private static final class DEBUG {
        @NotNull
        public static final DEBUG INSTANCE = new DEBUG();

        private DEBUG() {
        }

        public final int clearDebugRenderers(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            Iterable $this$forEach$iv = RenderingData.INSTANCE.getServer().getAllIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(RenderingData.INSTANCE.getServer().getRenderer(it) instanceof DebugRenderer)) continue;
                RenderingData.INSTANCE.getServer().removeRenderer(it);
            }
            return 0;
        }

        public final int testGIFLoader(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            byte[] bytes = Minecraft.m_91087_().m_91098_().m_215593_(new ResourceLocation("the_vmod", "textures/gif/test_gif2.gif")).m_215507_().readAllBytes();
            ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)10, () -> DEBUG.testGIFLoader$lambda$4(bytes), (int)13, null);
            return 0;
        }

        private static final Unit testGIFLoader$lambda$4(byte[] $bytes) {
            int numRounds = 25;
            int ignoreFirstN = 5;
            long totalTime = 0L;
            int numFrames = 0;
            long numPixels = 0L;
            for (int i2 = 0; i2 < numRounds; ++i2) {
                GIFReader.NativeTextureWithData it;
                int acc;
                Iterable $this$fold$iv;
                int initial$iv;
                VMKt.ELOG("Started loading round " + (i2 + 1) + " out of " + numRounds);
                long start = GetNow_msKt.getNow_ms();
                Intrinsics.checkNotNull((Object)$bytes);
                List<GIFReader.NativeTextureWithData> textures = GIFReader.INSTANCE.readGifToTexturesFaster($bytes);
                long stop = GetNow_msKt.getNow_ms();
                VMKt.ELOG("Stopped loading");
                Iterable $this$forEach$iv = textures;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GIFReader.NativeTextureWithData it2 = (GIFReader.NativeTextureWithData)element$iv;
                    boolean bl = false;
                    it2.getImage().close();
                }
                if (i2 < ignoreFirstN) continue;
                totalTime += stop - start;
                $this$forEach$iv = textures;
                $i$f$forEach = false;
                int n = numFrames;
                boolean $i$f$fold = false;
                int accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    GIFReader.NativeTextureWithData nativeTextureWithData = (GIFReader.NativeTextureWithData)element$iv;
                    acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc + it.getNumFrames();
                }
                void var24_25 = accumulator$iv;
                numFrames = n + var24_25;
                $this$fold$iv = textures;
                initial$iv = 0;
                long l = numPixels;
                $i$f$fold = false;
                accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    it = (GIFReader.NativeTextureWithData)element$iv;
                    acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc + it.getSpriteWidth() * it.getSpriteHeight();
                }
                int n2 = accumulator$iv;
                numPixels = l + (long)n2;
            }
            VMKt.ELOG("\nFrames per second: " + (float)numFrames / (float)totalTime * (float)1000 + "\nms per frame: " + (float)totalTime / (float)numFrames + "\nPixels per second: " + (int)((float)numPixels / (float)totalTime * (float)1000) + "\nProcessed frames: " + numFrames);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\n\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\u000b"}, d2={"Lnet/spaceeye/vmod/VMCommands$OP;", "", "<init>", "()V", "clearVmodAttachments", "", "cc", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/commands/CommandSourceStack;", "deletePhysEntities", "pruneShipyardChunks", "VMod"})
    @SourceDebugExtension(value={"SMAP\nVMCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$OP\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,606:1\n1863#2:607\n1864#2:609\n1863#2:610\n1557#2:611\n1628#2,3:612\n774#2:615\n865#2,2:616\n1557#2:618\n1628#2,3:619\n1611#2,9:622\n1863#2:631\n1557#2:632\n1628#2,3:633\n1864#2:637\n1620#2:638\n1557#2:639\n1628#2,3:640\n774#2:643\n865#2,2:644\n1864#2:646\n1#3:608\n1#3:636\n*S KotlinDebug\n*F\n+ 1 VMCommands.kt\nnet/spaceeye/vmod/VMCommands$OP\n*L\n334#1:607\n334#1:609\n359#1:610\n365#1:611\n365#1:612,3\n366#1:615\n366#1:616,2\n367#1:618\n367#1:619,3\n368#1:622,9\n368#1:631\n368#1:632\n368#1:633,3\n368#1:637\n368#1:638\n369#1:639\n369#1:640,3\n370#1:643\n370#1:644,2\n359#1:646\n368#1:636\n*E\n"})
    private static final class OP {
        @NotNull
        public static final OP INSTANCE = new OP();

        private OP() {
        }

        public final int clearVmodAttachments(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            ServerLevel level = ((CommandSourceStack)cc.getSource()).m_81372_();
            Iterable $this$forEach$iv = (Iterable)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LoadedServerShip it = (LoadedServerShip)element$iv;
                boolean bl = false;
                if ((GravityController)it.getAttachment(GravityController.class) != null) {
                    boolean bl2 = false;
                    it.setAttachment(GravityController.class, null);
                }
                if ((PhysgunController)it.getAttachment(PhysgunController.class) != null) {
                    boolean bl3 = false;
                    it.setAttachment(PhysgunController.class, null);
                }
                if ((CustomMassSave)it.getAttachment(CustomMassSave.class) != null) {
                    boolean bl4 = false;
                    it.setAttachment(CustomMassSave.class, null);
                }
                if ((WeightSynchronizer)it.getAttachment(WeightSynchronizer.class) == null) continue;
                boolean bl5 = false;
                it.setAttachment(WeightSynchronizer.class, null);
            }
            return 0;
        }

        public final int deletePhysEntities(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            ServerLevel level = ((CommandSourceStack)cc.getSource()).m_81372_();
            return 0;
        }

        public final int pruneShipyardChunks(@NotNull CommandContext<CommandSourceStack> cc) {
            Intrinsics.checkNotNullParameter(cc, (String)"cc");
            ThreadsKt.thread$default((boolean)true, (boolean)true, null, null, (int)0, () -> OP.pruneShipyardChunks$lambda$14(cc), (int)28, null);
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit pruneShipyardChunks$lambda$14(CommandContext $cc) {
            Iterable iterable = ((CommandSourceStack)$cc.getSource()).m_81377_().m_129785_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Path path;
                ServerLevel level = (ServerLevel)element$iv;
                boolean bl = false;
                ChunkMap chunkMap = level.m_7726_().f_8325_;
                Intrinsics.checkNotNull((Object)chunkMap, (String)"null cannot be cast to non-null type net.spaceeye.vmod.mixin.ChunkStorageAccessor");
                IOWorker iOWorker = ((ChunkStorageAccessor)chunkMap).vmod$getWorker();
                Intrinsics.checkNotNull((Object)iOWorker, (String)"null cannot be cast to non-null type net.spaceeye.vmod.mixin.IOWorkerAccessor");
                RegionFileStorage regionFileStorage = ((IOWorkerAccessor)iOWorker).vmod$getStorage();
                Intrinsics.checkNotNull((Object)regionFileStorage, (String)"null cannot be cast to non-null type net.spaceeye.vmod.mixin.RegionFileStorageAccessor");
                Intrinsics.checkNotNullExpressionValue((Object)((RegionFileStorageAccessor)regionFileStorage).vmod$getPath(), (String)"vmod$getPath(...)");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                Object object = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path path2 = (Path)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Path path3 = it.getFileName();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getFileName(...)");
                    collection.add(PathsKt.getName((Path)path3));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (!(StringsKt.startsWith$default((String)it, (String)"r.", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)".mca", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"r."), (CharSequence)".mca"));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$mapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    String[] it$iv$iv;
                    String[] stringArray;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl5 = false;
                    String it2 = (String)element$iv$iv;
                    boolean bl6 = false;
                    try {
                        void $this$mapTo$iv$iv2;
                        stringArray = new String[]{"."};
                        Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)it2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$map2 = false;
                        Iterable iterable2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it3;
                            String string = (String)item$iv$iv;
                            Collection collection2 = destination$iv$iv2;
                            boolean bl7 = false;
                            collection2.add(Integer.parseInt((String)it3));
                        }
                        List it4 = (List)destination$iv$iv2;
                        boolean bl8 = false;
                        stringArray = new Pair(it4.get(0), it4.get(1));
                    }
                    catch (Exception exception) {
                        stringArray = null;
                    }
                    if (stringArray == null) continue;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl10 = false;
                    int x = ((Number)it.component1()).intValue();
                    int z = ((Number)it.component2()).intValue();
                    collection.add(new Pair((Object)ChunkPos.m_220337_((int)x, (int)z), (Object)ChunkPos.m_220340_((int)x, (int)z)));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Pair)element$iv$iv;
                    boolean bl11 = false;
                    ChunkPos min = (ChunkPos)it.component1();
                    ChunkPos max = (ChunkPos)it.component2();
                    Intrinsics.checkNotNull((Object)level);
                    if (!(VSGameUtilsKt.isChunkInShipyard((Level)((Level)level), (int)min.f_45578_, (int)min.f_45579_) || VSGameUtilsKt.isChunkInShipyard((Level)((Level)level), (int)max.f_45578_, (int)max.f_45579_))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List regionsToCheck = (List)destination$iv$iv;
                object = ((Iterable)regionsToCheck).iterator();
                int n = 0;
                while (object.hasNext()) {
                    int i2 = n++;
                    Pair bounds = (Pair)object.next();
                    boolean allUnused = true;
                    $this$forEach$iv$iv$iv = ChunkPos.m_45599_((ChunkPos)((ChunkPos)bounds.getFirst()), (ChunkPos)((ChunkPos)bounds.getSecond())).iterator();
                    while ($this$forEach$iv$iv$iv.hasNext()) {
                        ChunkPos cPos = (ChunkPos)$this$forEach$iv$iv$iv.next();
                        Intrinsics.checkNotNull((Object)cPos);
                        if (VSGameUtilsKt.getShipManagingPos((ServerLevel)level, (ChunkPos)cPos) == null) continue;
                        allUnused = false;
                        break;
                    }
                    if (allUnused) {
                        int regX = ((ChunkPos)bounds.getFirst()).m_45610_();
                        int regZ = ((ChunkPos)bounds.getFirst()).m_45612_();
                        Path path4 = path.resolve("r." + regX + "." + regZ + ".mca");
                        Intrinsics.checkNotNull((Object)path4);
                        Files.deleteIfExists(path4);
                        Intrinsics.checkNotNull((Object)level);
                        VMKt.DLOG("Dimension: " + VSGameUtilsKt.getDimensionId((Level)((Level)level)) + " | Removed region " + ((ChunkPos)bounds.getFirst()).m_45610_() + "." + ((ChunkPos)bounds.getFirst()).m_45612_() + " | " + (i2 + 1) + "/" + regionsToCheck.size());
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)level);
                    VMKt.DLOG("Dimension: " + VSGameUtilsKt.getDimensionId((Level)((Level)level)) + " | Processed " + (i2 + 1) + "/" + regionsToCheck.size());
                }
            }
            return Unit.INSTANCE;
        }
    }
}

