/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.markdown;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.spaceeye.elementa.impl.commonmark.Extension;
import net.spaceeye.elementa.impl.commonmark.ext.gfm.strikethrough.Strikethrough;
import net.spaceeye.elementa.impl.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import net.spaceeye.elementa.impl.commonmark.ext.ins.Ins;
import net.spaceeye.elementa.impl.commonmark.ext.ins.InsExtension;
import net.spaceeye.elementa.impl.commonmark.node.AbstractVisitor;
import net.spaceeye.elementa.impl.commonmark.node.BlockQuote;
import net.spaceeye.elementa.impl.commonmark.node.BulletList;
import net.spaceeye.elementa.impl.commonmark.node.Code;
import net.spaceeye.elementa.impl.commonmark.node.CustomBlock;
import net.spaceeye.elementa.impl.commonmark.node.CustomNode;
import net.spaceeye.elementa.impl.commonmark.node.Emphasis;
import net.spaceeye.elementa.impl.commonmark.node.FencedCodeBlock;
import net.spaceeye.elementa.impl.commonmark.node.HardLineBreak;
import net.spaceeye.elementa.impl.commonmark.node.Heading;
import net.spaceeye.elementa.impl.commonmark.node.HtmlInline;
import net.spaceeye.elementa.impl.commonmark.node.Image;
import net.spaceeye.elementa.impl.commonmark.node.IndentedCodeBlock;
import net.spaceeye.elementa.impl.commonmark.node.Link;
import net.spaceeye.elementa.impl.commonmark.node.LinkReferenceDefinition;
import net.spaceeye.elementa.impl.commonmark.node.ListBlock;
import net.spaceeye.elementa.impl.commonmark.node.ListItem;
import net.spaceeye.elementa.impl.commonmark.node.Node;
import net.spaceeye.elementa.impl.commonmark.node.OrderedList;
import net.spaceeye.elementa.impl.commonmark.node.Paragraph;
import net.spaceeye.elementa.impl.commonmark.node.SoftLineBreak;
import net.spaceeye.elementa.impl.commonmark.node.StrongEmphasis;
import net.spaceeye.elementa.impl.commonmark.node.Text;
import net.spaceeye.elementa.impl.commonmark.node.ThematicBreak;
import net.spaceeye.elementa.impl.commonmark.parser.Parser;
import net.spaceeye.elementa.markdown.MarkdownComponent;
import net.spaceeye.elementa.markdown.MarkdownConfig;
import net.spaceeye.elementa.markdown.drawables.BlockquoteDrawable;
import net.spaceeye.elementa.markdown.drawables.Drawable;
import net.spaceeye.elementa.markdown.drawables.DrawableList;
import net.spaceeye.elementa.markdown.drawables.HardBreakDrawable;
import net.spaceeye.elementa.markdown.drawables.HeaderDrawable;
import net.spaceeye.elementa.markdown.drawables.ImageDrawable;
import net.spaceeye.elementa.markdown.drawables.ListDrawable;
import net.spaceeye.elementa.markdown.drawables.ParagraphDrawable;
import net.spaceeye.elementa.markdown.drawables.SoftBreakDrawable;
import net.spaceeye.elementa.markdown.drawables.TextDrawable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u0000 \\2\u00020\u0001:\u0002\\]B\u001f\u0012\u0006\u0010D\u001a\u00020X\u0012\u0006\u0010S\u001a\u00020R\u0012\u0006\u0010J\u001a\u00020I\u00a2\u0006\u0004\bZ\u0010[J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0012J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0015J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0018J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u001bJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u001eJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b\u000b\u0010!J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b\u000b\u0010$J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b\u000b\u0010'J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b\u000b\u0010*J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b\u000b\u0010-J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b\u000b\u00100J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u00102\u001a\u000201H\u0016\u00a2\u0006\u0004\b\u000b\u00103J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b\u000b\u00106J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b\u000b\u00109J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010;\u001a\u00020:H\u0016\u00a2\u0006\u0004\b\u000b\u0010<J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\b\u000b\u0010?J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010A\u001a\u00020@H\u0016\u00a2\u0006\u0004\b\u000b\u0010BJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010D\u001a\u00020CH\u0016\u00a2\u0006\u0004\b\u000b\u0010EJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010G\u001a\u00020FH\u0016\u00a2\u0006\u0004\b\u000b\u0010HR\u0014\u0010J\u001a\u00020I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u001a\u0010N\u001a\b\u0012\u0004\u0012\u00020M0L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020P0L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010OR\u0014\u0010S\u001a\u00020R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0014\u0010V\u001a\u00020U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR\u0014\u0010D\u001a\u00020X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010Y\u00a8\u0006^"}, d2={"Lnet/spaceeye/elementa/markdown/MarkdownRendererImpl;", "Lnet/spaceeye/elementa/impl/commonmark/node/AbstractVisitor;", "", "mark", "()V", "Lnet/spaceeye/elementa/markdown/drawables/DrawableList;", "render", "()Lnet/spaceeye/elementa/markdown/drawables/DrawableList;", "unmarkAndCollect", "Lnet/spaceeye/elementa/impl/commonmark/node/BlockQuote;", "blockQuote", "visit", "(Lnet/spaceeye/elementa/impl/commonmark/node/BlockQuote;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/BulletList;", "bulletList", "(Lnet/spaceeye/elementa/impl/commonmark/node/BulletList;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Code;", "code", "(Lnet/spaceeye/elementa/impl/commonmark/node/Code;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/CustomBlock;", "customBlock", "(Lnet/spaceeye/elementa/impl/commonmark/node/CustomBlock;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/CustomNode;", "customNode", "(Lnet/spaceeye/elementa/impl/commonmark/node/CustomNode;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Emphasis;", "emphasis", "(Lnet/spaceeye/elementa/impl/commonmark/node/Emphasis;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/FencedCodeBlock;", "fencedCodeBlock", "(Lnet/spaceeye/elementa/impl/commonmark/node/FencedCodeBlock;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/HardLineBreak;", "hardLineBreak", "(Lnet/spaceeye/elementa/impl/commonmark/node/HardLineBreak;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Heading;", "heading", "(Lnet/spaceeye/elementa/impl/commonmark/node/Heading;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/HtmlInline;", "htmlInline", "(Lnet/spaceeye/elementa/impl/commonmark/node/HtmlInline;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Image;", "image", "(Lnet/spaceeye/elementa/impl/commonmark/node/Image;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/IndentedCodeBlock;", "indentedCodeBlock", "(Lnet/spaceeye/elementa/impl/commonmark/node/IndentedCodeBlock;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Link;", "link", "(Lnet/spaceeye/elementa/impl/commonmark/node/Link;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/LinkReferenceDefinition;", "linkReferenceDefinition", "(Lnet/spaceeye/elementa/impl/commonmark/node/LinkReferenceDefinition;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/ListItem;", "listItem", "(Lnet/spaceeye/elementa/impl/commonmark/node/ListItem;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/OrderedList;", "orderedList", "(Lnet/spaceeye/elementa/impl/commonmark/node/OrderedList;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Paragraph;", "paragraph", "(Lnet/spaceeye/elementa/impl/commonmark/node/Paragraph;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/SoftLineBreak;", "softLineBreak", "(Lnet/spaceeye/elementa/impl/commonmark/node/SoftLineBreak;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/StrongEmphasis;", "strongEmphasis", "(Lnet/spaceeye/elementa/impl/commonmark/node/StrongEmphasis;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/Text;", "text", "(Lnet/spaceeye/elementa/impl/commonmark/node/Text;)V", "Lnet/spaceeye/elementa/impl/commonmark/node/ThematicBreak;", "thematicBreak", "(Lnet/spaceeye/elementa/impl/commonmark/node/ThematicBreak;)V", "Lnet/spaceeye/elementa/markdown/MarkdownConfig;", "config", "Lnet/spaceeye/elementa/markdown/MarkdownConfig;", "", "Lnet/spaceeye/elementa/markdown/drawables/Drawable;", "drawables", "Ljava/util/List;", "", "marks", "Lnet/spaceeye/elementa/markdown/MarkdownComponent;", "md", "Lnet/spaceeye/elementa/markdown/MarkdownComponent;", "Lnet/spaceeye/elementa/markdown/MarkdownRendererImpl$MutableStyle;", "style", "Lnet/spaceeye/elementa/markdown/MarkdownRendererImpl$MutableStyle;", "", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;Lgg/essential/elementa/markdown/MarkdownComponent;Lgg/essential/elementa/markdown/MarkdownConfig;)V", "Companion", "MutableStyle", "Elementa"})
@SourceDebugExtension(value={"SMAP\nMarkdownRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownRenderer.kt\ngg/essential/elementa/markdown/MarkdownRendererImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1741#2,3:244\n1741#2,3:247\n*S KotlinDebug\n*F\n+ 1 MarkdownRenderer.kt\ngg/essential/elementa/markdown/MarkdownRendererImpl\n*L\n103#1:244,3\n124#1:247,3\n*E\n"})
final class MarkdownRendererImpl
extends AbstractVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final MarkdownComponent md;
    @NotNull
    private final MarkdownConfig config;
    @NotNull
    private final List<Drawable> drawables;
    @NotNull
    private final MutableStyle style;
    @NotNull
    private final List<Integer> marks;
    @NotNull
    private static final List<Extension> extensions;

    public MarkdownRendererImpl(@NotNull String text, @NotNull MarkdownComponent md, @NotNull MarkdownConfig config) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.text = text;
        this.md = md;
        this.config = config;
        this.drawables = new ArrayList();
        this.style = new MutableStyle(false, false, false, false, false, null, 63, null);
        this.marks = new ArrayList();
    }

    private final void mark() {
        this.marks.add(this.drawables.size());
    }

    @NotNull
    public final DrawableList render() {
        Set enabledBlockTypes;
        Set $this$render_u24lambda_u240 = enabledBlockTypes = (Set)new LinkedHashSet();
        boolean bl = false;
        if (this.config.getHeaderConfig().getEnabled()) {
            $this$render_u24lambda_u240.add(Heading.class);
        }
        if (this.config.getCodeBlockConfig().getEnabled()) {
            $this$render_u24lambda_u240.add(FencedCodeBlock.class);
            $this$render_u24lambda_u240.add(IndentedCodeBlock.class);
        }
        if (this.config.getBlockquoteConfig().getEnabled()) {
            $this$render_u24lambda_u240.add(BlockQuote.class);
        }
        if (this.config.getListConfig().getEnabled()) {
            $this$render_u24lambda_u240.add(ListBlock.class);
        }
        Node document = Parser.builder().extensions((Iterable<? extends Extension>)extensions).enabledBlockTypes(enabledBlockTypes).build().parse(this.text);
        document.accept(this);
        return new DrawableList(this.md, this.drawables);
    }

    private final DrawableList unmarkAndCollect() {
        int lastMark = ((Number)this.marks.remove(CollectionsKt.getLastIndex(this.marks))).intValue();
        List slice = CollectionsKt.toList((Iterable)this.drawables.subList(lastMark, this.drawables.size()));
        int n = slice.size();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl = false;
            this.drawables.remove(CollectionsKt.getLastIndex(this.drawables));
        }
        return new DrawableList(this.md, slice);
    }

    @Override
    public void visit(@NotNull Emphasis emphasis) {
        Intrinsics.checkNotNullParameter((Object)emphasis, (String)"emphasis");
        this.style.setItalic(true);
        super.visit(emphasis);
        this.style.setItalic(false);
    }

    @Override
    public void visit(@NotNull StrongEmphasis strongEmphasis) {
        Intrinsics.checkNotNullParameter((Object)strongEmphasis, (String)"strongEmphasis");
        this.style.setBold(true);
        super.visit(strongEmphasis);
        this.style.setBold(false);
    }

    @Override
    public void visit(@NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (text.getFirstChild() != null) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        String string = text.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.literal");
        this.drawables.add(new TextDrawable(this.md, string, this.style.toTextStyle()));
    }

    @Override
    public void visit(@NotNull Paragraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        this.mark();
        super.visit(paragraph);
        this.drawables.add(new ParagraphDrawable(this.md, this.unmarkAndCollect()));
    }

    @Override
    public void visit(@NotNull BlockQuote blockQuote) {
        Intrinsics.checkNotNullParameter((Object)blockQuote, (String)"blockQuote");
        this.mark();
        super.visit(blockQuote);
        this.drawables.add(new BlockquoteDrawable(this.md, this.unmarkAndCollect()));
    }

    @Override
    public void visit(@NotNull BulletList bulletList) {
        boolean bl;
        DrawableList children;
        block4: {
            Intrinsics.checkNotNullParameter((Object)bulletList, (String)"bulletList");
            this.mark();
            super.visit(bulletList);
            children = this.unmarkAndCollect();
            Iterable $this$any$iv = children;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Drawable it = (Drawable)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof DrawableList) && !(it instanceof ListDrawable))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        this.drawables.add(new ListDrawable(this.md, children, false, !bulletList.isTight()));
    }

    @Override
    public void visit(@NotNull ListItem listItem) {
        Intrinsics.checkNotNullParameter((Object)listItem, (String)"listItem");
        this.mark();
        super.visit(listItem);
        this.drawables.add(new DrawableList(this.md, this.unmarkAndCollect()));
    }

    @Override
    public void visit(@NotNull OrderedList orderedList) {
        boolean bl;
        DrawableList children;
        block4: {
            Intrinsics.checkNotNullParameter((Object)orderedList, (String)"orderedList");
            this.mark();
            super.visit(orderedList);
            children = this.unmarkAndCollect();
            Iterable $this$any$iv = children;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Drawable it = (Drawable)element$iv;
                    boolean bl2 = false;
                    if (!(!(it instanceof DrawableList) && !(it instanceof ListDrawable))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        this.drawables.add(new ListDrawable(this.md, children, true, !orderedList.isTight()));
    }

    @Override
    public void visit(@NotNull Code code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.style.setCode(true);
        String string = code.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code.literal");
        this.drawables.add(new TextDrawable(this.md, string, this.style.toTextStyle()));
        this.style.setCode(false);
    }

    @Override
    public void visit(@NotNull FencedCodeBlock fencedCodeBlock) {
        Intrinsics.checkNotNullParameter((Object)fencedCodeBlock, (String)"fencedCodeBlock");
    }

    @Override
    public void visit(@NotNull HardLineBreak hardLineBreak) {
        Intrinsics.checkNotNullParameter((Object)hardLineBreak, (String)"hardLineBreak");
        if (hardLineBreak.getFirstChild() != null) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        this.drawables.add(new HardBreakDrawable(this.md));
    }

    @Override
    public void visit(@NotNull Heading heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        this.mark();
        super.visit(heading);
        DrawableList children = this.unmarkAndCollect();
        this.drawables.add(new HeaderDrawable(this.md, heading.getLevel(), new ParagraphDrawable(this.md, children)));
    }

    @Override
    public void visit(@NotNull ThematicBreak thematicBreak) {
        Intrinsics.checkNotNullParameter((Object)thematicBreak, (String)"thematicBreak");
    }

    @Override
    public void visit(@NotNull HtmlInline htmlInline) {
        Intrinsics.checkNotNullParameter((Object)htmlInline, (String)"htmlInline");
        String string = htmlInline.getLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"htmlInline.literal");
        this.drawables.add(new TextDrawable(this.md, string, this.style.toTextStyle()));
    }

    @Override
    public void visit(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.mark();
        super.visit(image);
        DrawableList fallback = this.unmarkAndCollect();
        this.drawables.add(new ImageDrawable(this.md, new URL(image.getDestination()), fallback));
    }

    @Override
    public void visit(@NotNull IndentedCodeBlock indentedCodeBlock) {
        Intrinsics.checkNotNullParameter((Object)indentedCodeBlock, (String)"indentedCodeBlock");
    }

    @Override
    public void visit(@NotNull Link link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.style.setLinkLocation(link.getDestination());
        super.visit(link);
        this.style.setLinkLocation(null);
    }

    @Override
    public void visit(@NotNull SoftLineBreak softLineBreak) {
        Intrinsics.checkNotNullParameter((Object)softLineBreak, (String)"softLineBreak");
        if (softLineBreak.getFirstChild() != null) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        this.drawables.add(new SoftBreakDrawable(this.md));
    }

    @Override
    public void visit(@NotNull LinkReferenceDefinition linkReferenceDefinition) {
        Intrinsics.checkNotNullParameter((Object)linkReferenceDefinition, (String)"linkReferenceDefinition");
    }

    @Override
    public void visit(@NotNull CustomBlock customBlock) {
        Intrinsics.checkNotNullParameter((Object)customBlock, (String)"customBlock");
    }

    @Override
    public void visit(@NotNull CustomNode customNode) {
        Intrinsics.checkNotNullParameter((Object)customNode, (String)"customNode");
        CustomNode customNode2 = customNode;
        if (customNode2 instanceof Strikethrough) {
            this.style.setStrikethrough(true);
            super.visit(customNode);
            this.style.setStrikethrough(false);
        } else if (customNode2 instanceof Ins) {
            this.style.setUnderline(true);
            super.visit(customNode);
            this.style.setUnderline(false);
        } else {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
    }

    static {
        Object[] objectArray = new Extension[]{StrikethroughExtension.create(), InsExtension.create()};
        extensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lnet/spaceeye/elementa/markdown/MarkdownRendererImpl$Companion;", "", "", "Lnet/spaceeye/elementa/impl/commonmark/Extension;", "kotlin.jvm.PlatformType", "extensions", "Ljava/util/List;", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\b\b\u0002\u0010\f\u001a\u00020\u0002\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJN\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00022\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u000bJ\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR\"\u0010\f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\u001e\u001a\u0004\b\f\u0010\u0004\"\u0004\b\u001f\u0010 R\"\u0010\u0010\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u001e\u001a\u0004\b\u0010\u0010\u0004\"\u0004\b!\u0010 R\"\u0010\r\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u001e\u001a\u0004\b\r\u0010\u0004\"\u0004\b\"\u0010 R\"\u0010\u000e\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u001e\u001a\u0004\b\u000e\u0010\u0004\"\u0004\b#\u0010 R\"\u0010\u000f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u001e\u001a\u0004\b\u000f\u0010\u0004\"\u0004\b$\u0010 R$\u0010\u0011\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010%\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lnet/spaceeye/elementa/markdown/MarkdownRendererImpl$MutableStyle;", "", "", "component1", "()Z", "component2", "component3", "component4", "component5", "", "component6", "()Ljava/lang/String;", "isBold", "isItalic", "isStrikethrough", "isUnderline", "isCode", "linkLocation", "copy", "(ZZZZZLjava/lang/String;)Lnet/spaceeye/elementa/markdown/MarkdownRendererImpl$MutableStyle;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/spaceeye/elementa/markdown/drawables/TextDrawable$Style;", "toTextStyle", "()Lnet/spaceeye/elementa/markdown/drawables/TextDrawable$Style;", "Z", "setBold", "(Z)V", "setCode", "setItalic", "setStrikethrough", "setUnderline", "Ljava/lang/String;", "getLinkLocation", "setLinkLocation", "(Ljava/lang/String;)V", "<init>", "(ZZZZZLjava/lang/String;)V", "Elementa"})
    public static final class MutableStyle {
        private boolean isBold;
        private boolean isItalic;
        private boolean isStrikethrough;
        private boolean isUnderline;
        private boolean isCode;
        @Nullable
        private String linkLocation;

        public MutableStyle(boolean isBold, boolean isItalic, boolean isStrikethrough, boolean isUnderline, boolean isCode, @Nullable String linkLocation) {
            this.isBold = isBold;
            this.isItalic = isItalic;
            this.isStrikethrough = isStrikethrough;
            this.isUnderline = isUnderline;
            this.isCode = isCode;
            this.linkLocation = linkLocation;
        }

        public /* synthetic */ MutableStyle(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            if ((n & 0x10) != 0) {
                bl5 = false;
            }
            if ((n & 0x20) != 0) {
                string = null;
            }
            this(bl, bl2, bl3, bl4, bl5, string);
        }

        public final boolean isBold() {
            return this.isBold;
        }

        public final void setBold(boolean bl) {
            this.isBold = bl;
        }

        public final boolean isItalic() {
            return this.isItalic;
        }

        public final void setItalic(boolean bl) {
            this.isItalic = bl;
        }

        public final boolean isStrikethrough() {
            return this.isStrikethrough;
        }

        public final void setStrikethrough(boolean bl) {
            this.isStrikethrough = bl;
        }

        public final boolean isUnderline() {
            return this.isUnderline;
        }

        public final void setUnderline(boolean bl) {
            this.isUnderline = bl;
        }

        public final boolean isCode() {
            return this.isCode;
        }

        public final void setCode(boolean bl) {
            this.isCode = bl;
        }

        @Nullable
        public final String getLinkLocation() {
            return this.linkLocation;
        }

        public final void setLinkLocation(@Nullable String string) {
            this.linkLocation = string;
        }

        @NotNull
        public final TextDrawable.Style toTextStyle() {
            return new TextDrawable.Style(this.isBold, this.isItalic, this.isStrikethrough, this.isUnderline, this.isCode, this.linkLocation);
        }

        public final boolean component1() {
            return this.isBold;
        }

        public final boolean component2() {
            return this.isItalic;
        }

        public final boolean component3() {
            return this.isStrikethrough;
        }

        public final boolean component4() {
            return this.isUnderline;
        }

        public final boolean component5() {
            return this.isCode;
        }

        @Nullable
        public final String component6() {
            return this.linkLocation;
        }

        @NotNull
        public final MutableStyle copy(boolean isBold, boolean isItalic, boolean isStrikethrough, boolean isUnderline, boolean isCode, @Nullable String linkLocation) {
            return new MutableStyle(isBold, isItalic, isStrikethrough, isUnderline, isCode, linkLocation);
        }

        public static /* synthetic */ MutableStyle copy$default(MutableStyle mutableStyle, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = mutableStyle.isBold;
            }
            if ((n & 2) != 0) {
                bl2 = mutableStyle.isItalic;
            }
            if ((n & 4) != 0) {
                bl3 = mutableStyle.isStrikethrough;
            }
            if ((n & 8) != 0) {
                bl4 = mutableStyle.isUnderline;
            }
            if ((n & 0x10) != 0) {
                bl5 = mutableStyle.isCode;
            }
            if ((n & 0x20) != 0) {
                string = mutableStyle.linkLocation;
            }
            return mutableStyle.copy(bl, bl2, bl3, bl4, bl5, string);
        }

        @NotNull
        public String toString() {
            return "MutableStyle(isBold=" + this.isBold + ", isItalic=" + this.isItalic + ", isStrikethrough=" + this.isStrikethrough + ", isUnderline=" + this.isUnderline + ", isCode=" + this.isCode + ", linkLocation=" + this.linkLocation + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isBold);
            result = result * 31 + Boolean.hashCode(this.isItalic);
            result = result * 31 + Boolean.hashCode(this.isStrikethrough);
            result = result * 31 + Boolean.hashCode(this.isUnderline);
            result = result * 31 + Boolean.hashCode(this.isCode);
            result = result * 31 + (this.linkLocation == null ? 0 : this.linkLocation.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MutableStyle)) {
                return false;
            }
            MutableStyle mutableStyle = (MutableStyle)other;
            if (this.isBold != mutableStyle.isBold) {
                return false;
            }
            if (this.isItalic != mutableStyle.isItalic) {
                return false;
            }
            if (this.isStrikethrough != mutableStyle.isStrikethrough) {
                return false;
            }
            if (this.isUnderline != mutableStyle.isUnderline) {
                return false;
            }
            if (this.isCode != mutableStyle.isCode) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.linkLocation, (Object)mutableStyle.linkLocation);
        }

        public MutableStyle() {
            this(false, false, false, false, false, null, 63, null);
        }
    }
}

