/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.impl.commonmark.internal.inline;

import net.spaceeye.elementa.impl.commonmark.internal.inline.InlineContentParser;
import net.spaceeye.elementa.impl.commonmark.internal.inline.InlineParserState;
import net.spaceeye.elementa.impl.commonmark.internal.inline.ParsedInline;
import net.spaceeye.elementa.impl.commonmark.internal.inline.Position;
import net.spaceeye.elementa.impl.commonmark.internal.inline.Scanner;
import net.spaceeye.elementa.impl.commonmark.internal.util.Parsing;
import net.spaceeye.elementa.impl.commonmark.node.Code;
import net.spaceeye.elementa.impl.commonmark.node.Text;
import net.spaceeye.elementa.impl.commonmark.parser.SourceLines;

public class BackticksInlineParser
implements InlineContentParser {
    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        Position start = scanner.position();
        int openingTicks = scanner.matchMultiple('`');
        Position afterOpening = scanner.position();
        while (scanner.find('`') > 0) {
            Position beforeClosing = scanner.position();
            int count = scanner.matchMultiple('`');
            if (count != openingTicks) continue;
            Code node2 = new Code();
            String content = scanner.getSource(afterOpening, beforeClosing).getContent();
            if ((content = content.replace('\n', ' ')).length() >= 3 && content.charAt(0) == ' ' && content.charAt(content.length() - 1) == ' ' && Parsing.hasNonSpace(content)) {
                content = content.substring(1, content.length() - 1);
            }
            node2.setLiteral(content);
            return ParsedInline.of(node2, scanner.position());
        }
        SourceLines source = scanner.getSource(start, afterOpening);
        Text text = new Text(source.getContent());
        return ParsedInline.of(text, afterOpening);
    }
}

