/*
 * Decompiled with CFR 0.152.
 */
package net.spaceeye.elementa.constraints.animation;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.spaceeye.elementa.ElementaVersion;
import net.spaceeye.elementa.UIComponent;
import net.spaceeye.elementa.components.Window;
import net.spaceeye.elementa.constraints.SuperConstraint;
import net.spaceeye.elementa.constraints.animation.AnimationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B!\b\u0004\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010*\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010\u0004\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\u0005J\r\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u0005J\r\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u0005J\u0017\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001b\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020%8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b*\u0010\u001b\u001a\u0004\b+\u0010\u001d\u0082\u0001\u0007./01234\u00a8\u00065"}, d2={"Lnet/spaceeye/elementa/constraints/animation/AnimationComponent;", "T", "Lnet/spaceeye/elementa/constraints/SuperConstraint;", "", "animationFrame", "()V", "", "getPercentComplete", "()F", "", "isComplete", "()Z", "pause", "resume", "stop", "Lnet/spaceeye/elementa/UIComponent;", "component", "update$Elementa", "(Lnet/spaceeye/elementa/UIComponent;)V", "update", "animationPaused", "Z", "getAnimationPaused", "setAnimationPaused", "(Z)V", "", "delayFrames", "I", "getDelayFrames", "()I", "elapsedFrames", "getElapsedFrames", "setElapsedFrames", "(I)V", "", "lastUpdateTime", "J", "Lnet/spaceeye/elementa/constraints/animation/AnimationStrategy;", "strategy", "Lnet/spaceeye/elementa/constraints/animation/AnimationStrategy;", "getStrategy", "()Lgg/essential/elementa/constraints/animation/AnimationStrategy;", "totalFrames", "getTotalFrames", "<init>", "(Lgg/essential/elementa/constraints/animation/AnimationStrategy;II)V", "Lnet/spaceeye/elementa/constraints/animation/ColorAnimationComponent;", "Lnet/spaceeye/elementa/constraints/animation/FieldAnimationComponent;", "Lnet/spaceeye/elementa/constraints/animation/HeightAnimationComponent;", "Lnet/spaceeye/elementa/constraints/animation/RadiusAnimationComponent;", "Lnet/spaceeye/elementa/constraints/animation/WidthAnimationComponent;", "Lnet/spaceeye/elementa/constraints/animation/XAnimationComponent;", "Lnet/spaceeye/elementa/constraints/animation/YAnimationComponent;", "Elementa"})
public abstract class AnimationComponent<T>
implements SuperConstraint<T> {
    @NotNull
    private final AnimationStrategy strategy;
    private final int totalFrames;
    private final int delayFrames;
    private int elapsedFrames;
    private boolean animationPaused;
    private long lastUpdateTime;

    private AnimationComponent(AnimationStrategy strategy, int totalFrames, int delayFrames) {
        this.strategy = strategy;
        this.totalFrames = totalFrames;
        this.delayFrames = delayFrames;
        this.lastUpdateTime = -1L;
    }

    @NotNull
    public final AnimationStrategy getStrategy() {
        return this.strategy;
    }

    public final int getTotalFrames() {
        return this.totalFrames;
    }

    public final int getDelayFrames() {
        return this.delayFrames;
    }

    public final int getElapsedFrames() {
        return this.elapsedFrames;
    }

    public final void setElapsedFrames(int n) {
        this.elapsedFrames = n;
    }

    public final boolean getAnimationPaused() {
        return this.animationPaused;
    }

    public final void setAnimationPaused(boolean bl) {
        this.animationPaused = bl;
    }

    public final void update$Elementa(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Window window = Window.Companion.ofOrNull(component2);
        if (window == null) {
            return;
        }
        Window window2 = window;
        if (window2.getVersion$Elementa().compareTo((Enum)ElementaVersion.Companion.getV8$Elementa()) < 0) {
            return;
        }
        long now = window2.getAnimationTimeMs();
        if (this.lastUpdateTime == -1L) {
            this.lastUpdateTime = now;
        }
        int dtMs = (int)(now - this.lastUpdateTime);
        this.lastUpdateTime = now;
        if (!this.animationPaused) {
            this.elapsedFrames = RangesKt.coerceAtMost((int)(this.elapsedFrames + dtMs), (int)(this.totalFrames + this.delayFrames));
        }
    }

    @Override
    @Deprecated(message="See [ElementaVersion.V8].")
    public void animationFrame() {
        SuperConstraint.super.animationFrame();
        if (this.isComplete() || this.animationPaused) {
            return;
        }
        int n = this.elapsedFrames;
        this.elapsedFrames = n + 1;
    }

    public final void stop() {
        this.elapsedFrames = this.totalFrames + this.delayFrames;
    }

    public final void pause() {
        this.animationPaused = true;
    }

    public final void resume() {
        this.animationPaused = false;
    }

    public final boolean isComplete() {
        return this.elapsedFrames - this.delayFrames >= this.totalFrames;
    }

    public final float getPercentComplete() {
        return this.strategy.getValue((float)Math.max(this.elapsedFrames - this.delayFrames, 0) / (float)this.totalFrames);
    }

    public /* synthetic */ AnimationComponent(AnimationStrategy strategy, int totalFrames, int delayFrames, DefaultConstructorMarker $constructor_marker) {
        this(strategy, totalFrames, delayFrames);
    }
}

