/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.client.config;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.time.Month;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.config.QuarkConfigHomeScreen;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.quark.base.handler.ContributorRewardHandler;

public class QButton
extends Button {
    private static final int ORANGE = 1;
    private static final int PURPLE = 2;
    private static final int RAINBOW = 3;
    private static final int QUARK = 4;
    private static final List<Celebration> CELEBRATIONS = new ArrayList<Celebration>();
    private final boolean gay;
    private Celebration celebrating;
    private boolean showBubble;

    private static void celebrate(String name, int day, Month month, int tier) {
        QButton.celebrate(name, day, day, month, tier);
    }

    private static void celebrate(String name, int day, int end, Month month, int tier) {
        CELEBRATIONS.add(new Celebration(day, month.getValue(), end - day, tier, name));
    }

    public QButton(int x, int y) {
        super(Button.m_253074_((Component)Component.m_237113_((String)"q"), QButton::click).m_253046_(20, 20).m_252794_(x, y));
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.gay = month == 6;
        for (Celebration c : CELEBRATIONS) {
            if (!c.running(day, month)) continue;
            this.celebrating = c;
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("quark.gui.celebration." + this.celebrating.name))));
            break;
        }
        this.showBubble = !QButton.getQuarkMarkerFile().exists();
    }

    public int getFGColor() {
        return this.gay ? Color.HSBtoRGB(QuarkClient.ticker.total / 200.0f, 1.0f, 1.0f) : 4775356;
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        int iconIndex = Math.min(4, ContributorRewardHandler.localPatronTier);
        if (this.celebrating != null) {
            iconIndex = this.celebrating.tier;
        }
        if (iconIndex > 0) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            int rx = this.m_252754_() - 2;
            int ry = this.m_252907_() - 2;
            int w = 9;
            int h = 9;
            int v = 26;
            if (this.celebrating != null) {
                rx -= 3;
                ry -= 2;
                w = 10;
                h = 10;
                v = 44;
            }
            int u = 256 - iconIndex * w;
            guiGraphics.m_280218_(ClientUtil.GENERAL_ICONS, rx, ry, u, v, w, h);
        }
        if (this.showBubble && QuarkGeneralConfig.enableOnboarding) {
            Font font = Minecraft.m_91087_().f_91062_;
            int cy = this.m_252907_() - 2;
            if (QuarkClient.ticker.total % 20.0f > 10.0f) {
                ++cy;
            }
            ClientUtil.drawChatBubble(guiGraphics, this.m_252754_() + 16, cy, font, I18n.m_118938_((String)"quark.misc.configure_quark_here", (Object[])new Object[0]), this.f_93625_, true);
        }
    }

    private static File getQuarkMarkerFile() {
        return new File(Minecraft.m_91087_().f_91069_, ".qmenu_opened.marker");
    }

    public static void click(Button b) {
        if (b instanceof QButton) {
            QButton qb = (QButton)b;
            if (qb.showBubble) {
                try {
                    QButton.getQuarkMarkerFile().createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Minecraft.m_91087_().m_91152_((Screen)new QuarkConfigHomeScreen(Minecraft.m_91087_().f_91080_));
    }

    static {
        QButton.celebrate("quark", 21, Month.MARCH, 4);
        QButton.celebrate("vm", 29, Month.APRIL, 2);
        QButton.celebrate("minecraft", 18, Month.NOVEMBER, 1);
        QButton.celebrate("vns", 9, Month.APRIL, 1);
        QButton.celebrate("vazkii", 22, Month.NOVEMBER, 1);
        QButton.celebrate("wire", 23, Month.SEPTEMBER, 1);
        QButton.celebrate("anb", 6, Month.JUNE, 1);
        QButton.celebrate("kame", 5, Month.NOVEMBER, 1);
        QButton.celebrate("adrian", 4, Month.MAY, 1);
        QButton.celebrate("train", 16, Month.AUGUST, 1);
        QButton.celebrate("zemmy", 9, Month.JUNE, 1);
        QButton.celebrate("mat", 7, Month.FEBRUARY, 1);
        QButton.celebrate("iad", 6, Month.APRIL, 3);
        QButton.celebrate("iad2", 26, Month.OCTOBER, 3);
        QButton.celebrate("idr", 8, Month.NOVEMBER, 3);
        QButton.celebrate("ld", 8, Month.OCTOBER, 3);
        QButton.celebrate("lvd", 26, Month.APRIL, 3);
        QButton.celebrate("ncod", 11, Month.OCTOBER, 3);
        QButton.celebrate("nbpd", 14, Month.JULY, 3);
        QButton.celebrate("ppad", 24, Month.MAY, 3);
        QButton.celebrate("tdr", 20, Month.NOVEMBER, 3);
        QButton.celebrate("tdv", 31, Month.MARCH, 3);
        QButton.celebrate("zdd", 1, Month.MARCH, 3);
        QButton.celebrate("afd", 1, Month.APRIL, 4);
        QButton.celebrate("wwd", 3, Month.MARCH, 2);
        QButton.celebrate("hw", 31, Month.OCTOBER, 1);
        QButton.celebrate("xmas", 25, Month.DECEMBER, 2);
        QButton.celebrate("iwd", 8, Month.MARCH, 2);
        QButton.celebrate("wpld", 5, Month.MAY, 2);
        QButton.celebrate("iyd", 12, Month.AUGUST, 2);
        QButton.celebrate("hrd", 9, Month.DECEMBER, 2);
        QButton.celebrate("ny", 1, 3, Month.JANUARY, 2);
        QButton.celebrate("edballs", 28, Month.APRIL, 1);
        QButton.celebrate("doyouremember", 21, Month.SEPTEMBER, 1);
        QButton.celebrate("pm", 1, 30, Month.JUNE, 3);
        QButton.celebrate("baw", 16, 22, Month.SEPTEMBER, 3);
        QButton.celebrate("taw", 13, 19, Month.NOVEMBER, 3);
    }

    private record Celebration(int day, int month, int len, int tier, String name) {
        public boolean running(int day, int month) {
            return this.month == month && this.day >= day && this.day <= day + this.len;
        }
    }
}

