/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.entities;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Medium;
import com.codinglitch.simpleradio.api.central.Socket;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundWireEffectPacket;
import com.codinglitch.simpleradio.core.registry.SimpleRadioEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Wire
extends Entity
implements Medium {
    private static final EntityDataAccessor<Optional<UUID>> FROM = SynchedEntityData.m_135353_(Wire.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> FROM_TYPE = SynchedEntityData.m_135353_(Wire.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<UUID>> TO = SynchedEntityData.m_135353_(Wire.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> TO_TYPE = SynchedEntityData.m_135353_(Wire.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int killTime = -1;
    private int deathRowTime = -1;
    private float deathRowPosition = -1.0f;
    private HashMap<UUID, Integer> effectCooldowns = new HashMap();
    public final ArrayList<Effect> effectList = new ArrayList();

    public Wire(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public Wire(Level level) {
        this(SimpleRadioEntities.WIRE, level);
    }

    public static Wire connect(Socket from, Socket to, Level level) {
        UUID toRef;
        if (from.equals(to)) {
            return null;
        }
        RadioRouter fromRouter = from.getRouter();
        if (fromRouter == null) {
            return null;
        }
        RadioRouter toRouter = to.getRouter();
        if (toRouter == null) {
            return null;
        }
        UUID fromRef = fromRouter.getReference();
        if (from.hasWire(fromRef, toRef = toRouter.getReference())) {
            return null;
        }
        if (to.hasWire(fromRef, toRef)) {
            return null;
        }
        Wire wire = new Wire(level);
        wire.m_20219_(new Vec3((Vector3f)fromRouter.location));
        wire.setFrom(fromRouter);
        wire.setTo(toRouter);
        level.m_7967_((Entity)wire);
        from.connect(wire);
        to.connect(wire);
        return wire;
    }

    public RadioRouter transport(RadioRouter source) {
        RadioRouter from = this.getFromRouter();
        RadioRouter to = this.getToRouter();
        if (source == from) {
            return to;
        }
        if (source == to) {
            return from;
        }
        return null;
    }

    public void relay(RadioSource source, Socket originSocket) {
        AtomicReference<Float> placeOfDemise;
        AtomicInteger timeUntilDemise;
        RadioRouter destination;
        if (!this.m_6084_()) {
            return;
        }
        UUID fromRef = this.getFrom().orElse(null);
        UUID toRef = this.getTo().orElse(null);
        String fromType = this.getFromType();
        String toType = this.getToType();
        if (fromRef == null || toRef == null) {
            CommonSimpleRadio.warn("Relaying cancelled; invalid wire [{}] to relay across.", this.m_20148_());
            return;
        }
        RadioRouter from = RadioManager.getRouter(fromRef, fromType);
        RadioRouter to = RadioManager.getRouter(toRef, toType);
        if (from == null || to == null) {
            CommonSimpleRadio.warn("Relaying cancelled; either end was unable to be found.", new Object[0]);
            return;
        }
        Level level = this.m_9236_();
        boolean isReversed = originSocket.getReference().equals(toRef);
        RadioRouter origin = isReversed ? to : from;
        RadioRouter radioRouter = destination = isReversed ? from : to;
        if (source.willShort(destination)) {
            destination.shortCircuit();
            return;
        }
        if (SimpleRadioLibrary.SERVER_CONFIG.wire.transmissionTime != -1 && RadioManager.readQueue(arg_0 -> this.lambda$relay$0(origin, timeUntilDemise = new AtomicInteger(), isReversed, placeOfDemise = new AtomicReference<Float>(Float.valueOf(0.0f)), arg_0))) {
            this.queueDemise(timeUntilDemise.get(), placeOfDemise.get().floatValue());
        }
        if (!level.m_5776_() && !this.effectCooldowns.containsKey(source.owner) && SimpleRadioLibrary.SERVER_CONFIG.wire.effectInterval != -1) {
            for (Player player : level.m_6907_()) {
                if (!(player.m_20270_((Entity)this) <= 100.0f)) continue;
                Services.NETWORKING.sendToPlayer((ServerPlayer)player, new ClientboundWireEffectPacket(this.m_19879_(), isReversed));
            }
            this.effectCooldowns.put(source.owner, SimpleRadioLibrary.SERVER_CONFIG.wire.effectInterval);
        }
        source.travel(from, to, this);
        if (SimpleRadioLibrary.SERVER_CONFIG.wire.transmissionTime == -1) {
            destination.accept(source);
        } else {
            RadioManager.queueSource(source, destination, Math.round((float)((float)SimpleRadioLibrary.SERVER_CONFIG.wire.transmissionTime.intValue() * this.getLength())));
        }
    }

    public float getLength() {
        RadioRouter from = this.getFromRouter();
        if (from == null) {
            return 0.0f;
        }
        RadioRouter to = this.getToRouter();
        if (to == null) {
            return 0.0f;
        }
        return from.getLocation().position().distance((Vector3fc)to.getLocation().position());
    }

    @Nullable
    public RadioRouter getFromRouter() {
        UUID reference = this.getFrom().orElse(null);
        if (reference == null) {
            return null;
        }
        return RadioManager.getRouterSided(reference, this.getFromType(), this.m_9236_().f_46443_);
    }

    public Optional<UUID> getFrom() {
        return (Optional)this.m_20088_().m_135370_(FROM);
    }

    @Nullable
    public String getFromType() {
        String type = (String)this.m_20088_().m_135370_(FROM_TYPE);
        return type.isEmpty() ? null : type;
    }

    public void setFrom(RadioRouter from) {
        this.m_20088_().m_135381_(FROM, Optional.of(from.getReference()));
        if (from.getClass() != RadioRouter.class) {
            this.m_20088_().m_135381_(FROM_TYPE, (Object)from.getClass().getSimpleName());
        }
    }

    @Nullable
    public RadioRouter getToRouter() {
        UUID reference = this.getTo().orElse(null);
        if (reference == null) {
            return null;
        }
        return RadioManager.getRouterSided(reference, this.getToType(), this.m_9236_().f_46443_);
    }

    public Optional<UUID> getTo() {
        return (Optional)this.m_20088_().m_135370_(TO);
    }

    @Nullable
    public String getToType() {
        String type = (String)this.m_20088_().m_135370_(TO_TYPE);
        return type.isEmpty() ? null : type;
    }

    public void setTo(RadioRouter to) {
        this.m_20088_().m_135381_(TO, Optional.of(to.getReference()));
        if (to.getClass() != RadioRouter.class) {
            this.m_20088_().m_135381_(TO_TYPE, (Object)to.getClass().getSimpleName());
        }
    }

    public void burnOut() {
        RadioManager.dequeueSource(queuedSource -> queuedSource.source.wireMedium == this);
        this.m_6074_();
    }

    public void shortCircuit(Vector3f at) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Socket.shortAt(level2, at);
        }
        this.burnOut();
    }

    public void shortCircuit() {
        this.shortCircuit(this.m_20182_().m_252839_());
    }

    public void queueDemise(int time, float position) {
        this.deathRowTime = time;
        this.deathRowPosition = position;
    }

    private void tickDeath() {
        if (this.killTime == 0) {
            this.m_6074_();
        } else {
            this.killTime = this.killTime == -1 ? SimpleRadioLibrary.SERVER_CONFIG.wire.invalidDeathTime : --this.killTime;
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().m_46749_(this.m_20183_())) {
            return;
        }
        this.f_19794_ = true;
        this.effectCooldowns.replaceAll((owner, time) -> time - 1);
        this.effectCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
        UUID fromRef = this.getFrom().orElse(null);
        UUID toRef = this.getTo().orElse(null);
        if (this.m_9236_().f_46443_) {
            int effectDuration = Math.round((float)((float)SimpleRadioLibrary.CLIENT_CONFIG.wire.effectTime.intValue() * this.getLength()));
            Iterator<Effect> iterator = this.effectList.iterator();
            while (iterator.hasNext()) {
                Effect effect = iterator.next();
                if (effect.direction == -1) {
                    if (effect.progress < 0) {
                        iterator.remove();
                    }
                } else if (effect.progress > effectDuration) {
                    iterator.remove();
                }
                effect.progress += effect.direction;
            }
            RadioRouter from = ClientRadioManager.getRouter(fromRef);
            RadioRouter to = ClientRadioManager.getRouter(toRef);
            if (from != null && !from.hasWire(this)) {
                from.connect(this);
            }
            if (to != null && !to.hasWire(this)) {
                to.connect(this);
            }
        } else {
            String fromType = this.getFromType();
            String toType = this.getToType();
            if (fromRef != null && toRef != null) {
                if (fromRef == toRef) {
                    this.m_6074_();
                    return;
                }
                RadioRouter from = RadioManager.getRouter(fromRef, fromType);
                RadioRouter to = RadioManager.getRouter(toRef, toType);
                if (from == null) {
                    if (to != null) {
                        this.m_20219_(new Vec3(to.getLocation().position()));
                    }
                    this.tickDeath();
                    return;
                }
                if (to == null) {
                    this.m_20219_(new Vec3(from.getLocation().position()));
                    this.tickDeath();
                    return;
                }
                if ((double)from.getLocation().position().distance((Vector3fc)to.getLocation().position()) > SimpleRadioLibrary.SERVER_CONFIG.wire.range) {
                    this.tickDeath();
                    return;
                }
                if (this.deathRowTime != -1 && this.deathRowTime-- == 0) {
                    Vector3f position = from.getLocation().position().lerp((Vector3fc)to.getLocation().position(), this.deathRowPosition);
                    this.shortCircuit(position);
                    return;
                }
                if (!from.hasWire(this)) {
                    from.connect(this);
                }
                if (!to.hasWire(this)) {
                    to.connect(this);
                }
                this.killTime = -1;
            } else {
                this.tickDeath();
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)SimpleRadioItems.COPPER_WIRE, 1));
        this.m_9236_().m_7967_((Entity)drop);
        this.cleanUp();
        super.m_142687_(reason);
    }

    public void m_142036_() {
        this.cleanUp();
        super.m_142036_();
    }

    public void cleanUp() {
        RadioRouter to;
        RadioRouter from = this.getFromRouter();
        if (from != null) {
            from.disconnect(this);
        }
        if ((to = this.getToRouter()) != null) {
            to.disconnect(this);
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6000_(double $$0, double $$1, double $$2) {
        return true;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(FROM, Optional.empty());
        this.m_20088_().m_135372_(FROM_TYPE, (Object)"");
        this.m_20088_().m_135372_(TO, Optional.empty());
        this.m_20088_().m_135372_(TO_TYPE, (Object)"");
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("from") && compoundTag.m_128441_("to")) {
            this.m_20088_().m_135381_(FROM, Optional.of(compoundTag.m_128342_("from")));
            this.m_20088_().m_135381_(FROM_TYPE, (Object)compoundTag.m_128461_("fromType"));
            this.m_20088_().m_135381_(TO, Optional.of(compoundTag.m_128342_("to")));
            this.m_20088_().m_135381_(TO_TYPE, (Object)compoundTag.m_128461_("toType"));
        }
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        ((Optional)this.m_20088_().m_135370_(FROM)).ifPresent(uuid -> {
            compoundTag.m_128362_("from", uuid);
            compoundTag.m_128359_("fromType", (String)this.m_20088_().m_135370_(FROM_TYPE));
        });
        ((Optional)this.m_20088_().m_135370_(TO)).ifPresent(uuid -> {
            compoundTag.m_128362_("to", uuid);
            compoundTag.m_128359_("toType", (String)this.m_20088_().m_135370_(TO_TYPE));
        });
    }

    private /* synthetic */ boolean lambda$relay$0(RadioRouter origin, AtomicInteger timeUntilDemise, boolean isReversed, AtomicReference placeOfDemise, RadioManager.QueuedSource queued) {
        if (queued.source.wireMedium.equals(this) && queued.router.equals(origin)) {
            int maxProgress = Math.round((float)((float)SimpleRadioLibrary.SERVER_CONFIG.wire.transmissionTime.intValue() * this.getLength()));
            float progress = (float)queued.time / (float)maxProgress;
            timeUntilDemise.set((int)Math.ceil((float)((float)queued.time / 2.0f)));
            if (isReversed) {
                placeOfDemise.set(Float.valueOf(1.0f - progress));
            } else {
                placeOfDemise.set(Float.valueOf(progress));
            }
            return true;
        }
        return false;
    }

    public static class Effect {
        public int direction = 0;
        public int progress = 0;
    }
}

