/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.registry.renderers;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.api.CatalystRegistry;
import com.codinglitch.simpleradio.api.central.Catalyst;
import com.codinglitch.simpleradio.api.central.Frequencing;
import com.codinglitch.simpleradio.core.registry.blocks.CatalyzingBlockEntity;
import com.codinglitch.simpleradio.core.registry.blocks.ReceiverBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Math;
import org.joml.Vector3f;

public class FrequencingRenderer {
    public static final int FRAME_RATE = 12;

    public static void renderCatalyst(CatalyzingBlockEntity blockEntity, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        poseStack.m_252880_(0.5f, 0.1f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)state.m_61143_((Property)ReceiverBlock.FACING)).m_122435_()));
        Item item = blockEntity.catalyst.associate;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(-0.5f, 0.0f, -0.75f);
            minecraft.m_91289_().m_110912_(blockItem.m_40614_().m_49966_(), poseStack, bufferSource, light, overlay);
        } else {
            minecraft.m_91291_().m_269128_(new ItemStack((ItemLike)item), ItemDisplayContext.FIXED, light, overlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
        }
    }

    public static void renderScreen(CatalyzingBlockEntity blockEntity, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        if (!(blockEntity instanceof Frequencing)) {
            return;
        }
        Frequencing frequencing = (Frequencing)((Object)blockEntity);
        Level level = blockEntity.m_58904_();
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        if (level == null) {
            return;
        }
        if (blockEntity.catalyst == null) {
            List<Catalyst> catalysts = CatalystRegistry.getCatalysts();
            float catalystSize = 8.0f;
            float offset = catalystSize / 2.0f - (float)catalysts.size() / 2.0f * catalystSize;
            for (int i = 0; i < catalysts.size(); ++i) {
                Catalyst catalyst = catalysts.get(i);
                poseStack.m_85836_();
                poseStack.m_252880_(offset + (float)i * catalystSize, 10.0f, 0.0f);
                poseStack.m_85841_(catalystSize, catalystSize, 0.01f);
                minecraft.m_91291_().m_269128_(new ItemStack((ItemLike)catalyst.associate), ItemDisplayContext.GUI, 0xF000F0, overlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
                poseStack.m_85849_();
            }
            String text = I18n.m_118938_((String)"screen.simpleradio.frequencing.catalyst", (Object[])new Object[0]);
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            poseStack.m_252880_(0.5f, -5.0f, 0.0f);
            float width = (float)(-font.m_92895_(text)) / 2.0f;
            font.m_271703_(text, width, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, 255);
            return;
        }
        float time = ((float)level.m_46467_() + Minecraft.m_91087_().m_91296_()) / 20.0f;
        time = Math.floor((float)(time * 12.0f)) / 12.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(24.0f, -5.0f, 0.0f);
        poseStack.m_85841_(10.0f, 10.0f, 0.01f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time * 60.0f));
        minecraft.m_91291_().m_269128_(new ItemStack((ItemLike)blockEntity.catalyst.associate), ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.m_118093_((int)((int)Math.floor((float)((Math.sin((float)(time * 5.0f)) + 1.0f) * 5.0f))), (int)15), poseStack, bufferSource, blockEntity.m_58904_(), 0);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(-28.0f, -4.0f, 0.0f);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        String text = Component.m_237110_((String)"screen.simpleradio.frequencing.efficiency", (Object[])new Object[]{Math.round((float)(blockEntity.catalyst.efficiency * 100.0f))}).getString();
        font.m_271703_(text, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, 255);
        poseStack.m_85849_();
        int antennaPower = frequencing.getAntennaPower();
        String antenna = String.valueOf(frequencing.getAntennaPower());
        float progress = Mth.m_14036_((float)((float)antennaPower / 100.0f), (float)0.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_(-28.0f, 8.0f, 0.0f);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        font.m_271703_(I18n.m_118938_((String)"screen.simpleradio.frequencing.antenna_strength", (Object[])new Object[0]), 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, 255);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(-23.0f + progress * 40.0f, 14.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        float width = -font.m_92895_(antenna) / 2;
        font.m_271703_(antenna, width, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, 255);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(-8.0f, 16.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        Vector3f one = poseStack.m_85850_().m_252922_().transformPosition(new Vector3f(-40.0f, -5.0f, 0.0f));
        Vector3f two = poseStack.m_85850_().m_252922_().transformPosition(new Vector3f(-40.0f, 5.0f, 0.0f));
        Vector3f three = poseStack.m_85850_().m_252922_().transformPosition(new Vector3f(-40.0f + progress * 80.0f, 5.0f, 0.0f));
        Vector3f four = poseStack.m_85850_().m_252922_().transformPosition(new Vector3f(-40.0f + progress * 80.0f, -5.0f, 0.0f));
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)CommonSimpleRadio.id("textures/gui/bars.png")));
        consumer.m_5483_((double)one.x, (double)one.y, (double)one.z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_5483_((double)two.x, (double)two.y, (double)two.z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_5483_((double)three.x, (double)three.y, (double)three.z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(progress, 1.0f).m_86008_(overlay).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_5483_((double)four.x, (double)four.y, (double)four.z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(progress, 0.0f).m_86008_(overlay).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        poseStack.m_85849_();
        String frequency = frequencing.getFrequency(blockEntity).toString();
        poseStack.m_85836_();
        poseStack.m_252880_(-28.0f, -10.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        font.m_271703_(frequency, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, 255);
        poseStack.m_85849_();
    }
}

