/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.mixin.accessors.TNTEntityAccess;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class IEExplosiveEntity
extends PrimedTnt {
    private float size;
    private Explosion.BlockInteraction mode = Explosion.BlockInteraction.DESTROY;
    private boolean isFlaming = false;
    private float explosionDropChance;
    public BlockState block;
    private Component name;
    private static final EntityDataAccessor<BlockState> dataMarker_block = SynchedEntityData.m_135353_(IEExplosiveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Integer> dataMarker_fuse = SynchedEntityData.m_135353_(IEExplosiveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public IEExplosiveEntity(EntityType<IEExplosiveEntity> type, Level world) {
        super(type, world);
    }

    public IEExplosiveEntity(Level world, BlockPos pos, LivingEntity igniter, BlockState blockstate, float size) {
        super((EntityType)IEEntityTypes.EXPLOSIVE.get(), world);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        double jumpingDirection = world.f_46441_.m_188500_() * 2.0 * Math.PI;
        this.m_20334_(-Math.sin(jumpingDirection) * 0.02, 0.2, -Math.cos(jumpingDirection) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        ((TNTEntityAccess)((Object)this)).setOwner(igniter);
        this.size = size;
        this.block = blockstate;
        this.explosionDropChance = 1.0f / size;
        this.setBlockSynced();
    }

    public IEExplosiveEntity setMode(Explosion.BlockInteraction smoke) {
        this.mode = smoke;
        return this;
    }

    public IEExplosiveEntity setFlaming(boolean fire) {
        this.isFlaming = fire;
        return this;
    }

    public IEExplosiveEntity setDropChance(float chance) {
        this.explosionDropChance = chance;
        return this;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(dataMarker_block, (Object)Blocks.f_50016_.m_49966_());
        this.f_19804_.m_135372_(dataMarker_fuse, (Object)0);
    }

    private void setBlockSynced() {
        if (this.block != null) {
            this.f_19804_.m_135381_(dataMarker_block, (Object)this.block);
            this.f_19804_.m_135381_(dataMarker_fuse, (Object)this.m_32100_());
        }
    }

    private void getBlockSynced() {
        this.block = (BlockState)this.f_19804_.m_135370_(dataMarker_block);
        if (this.block.m_60795_()) {
            this.block = null;
        }
        this.m_32085_((Integer)this.f_19804_.m_135370_(dataMarker_fuse));
    }

    @Nonnull
    public Component m_7755_() {
        ItemStack s;
        if (this.block != null && this.name == null && !(s = new ItemStack((ItemLike)this.block.m_60734_(), 1)).m_41619_() && s.m_41720_() != Items.f_41852_) {
            this.name = s.m_41786_();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.m_7755_();
    }

    protected void m_7380_(CompoundTag tagCompound) {
        super.m_7380_(tagCompound);
        tagCompound.m_128350_("explosionPower", this.size);
        tagCompound.m_128405_("explosionSmoke", this.mode.ordinal());
        tagCompound.m_128379_("explosionFire", this.isFlaming);
        if (this.block != null) {
            tagCompound.m_128405_("block", Block.m_49956_((BlockState)this.block));
        }
    }

    protected void m_7378_(CompoundTag tagCompound) {
        super.m_7378_(tagCompound);
        this.size = tagCompound.m_128457_("explosionPower");
        this.mode = Explosion.BlockInteraction.values()[tagCompound.m_128451_("explosionSmoke")];
        this.isFlaming = tagCompound.m_128471_("explosionFire");
        if (tagCompound.m_128425_("block", 3)) {
            this.block = Block.m_49803_((int)tagCompound.m_128451_("block"));
        }
    }

    public void m_8119_() {
        if (this.m_9236_().f_46443_ && this.block == null) {
            this.getBlockSynced();
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        int newFuse = this.m_32100_() - 1;
        this.m_32085_(newFuse);
        if (newFuse <= 0) {
            this.m_146870_();
            IEExplosion explosion = new IEExplosion(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 16.0f), this.m_20189_(), this.size, this.isFlaming, this.mode).setDropChance(this.explosionDropChance);
            if (!ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
                explosion.m_46061_();
                explosion.m_46075_(true);
            }
        } else {
            this.m_20073_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

