/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.mixin.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ByteProcessor;
import java.util.List;
import net.minecraft.network.Varint21FrameDecoder;
import one.pkg.mod.krypton_fnp.shared.network.VarIntByteDecoder;
import one.pkg.mod.krypton_fnp.shared.network.util.WellKnownExceptions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Varint21FrameDecoder.class})
public class Varint21FrameDecoderMixin {
    @Unique
    private final VarIntByteDecoder reader = new VarIntByteDecoder();

    @Inject(method={"decode"}, at={@At(value="HEAD")}, cancellable=true)
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out, CallbackInfo ci) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            ci.cancel();
            return;
        }
        this.reader.reset();
        int varintEnd = in.forEachByte((ByteProcessor)this.reader);
        if (varintEnd == -1) {
            if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
                in.clear();
            }
            ci.cancel();
            return;
        }
        if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
            in.readerIndex(varintEnd);
        } else if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.SUCCESS) {
            int readVarint = this.reader.getReadVarint();
            int bytesRead = this.reader.getBytesRead();
            if (readVarint < 0) {
                in.clear();
                throw WellKnownExceptions.BAD_LENGTH_CACHED;
            }
            if (readVarint == 0) {
                in.readerIndex(varintEnd + 1);
            } else {
                int minimumRead = bytesRead + readVarint;
                if (in.isReadable(minimumRead)) {
                    out.add(in.retainedSlice(varintEnd + 1, readVarint));
                    in.skipBytes(minimumRead);
                }
            }
        } else if (this.reader.getResult() == VarIntByteDecoder.DecodeResult.TOO_BIG) {
            in.clear();
            throw WellKnownExceptions.VARINT_BIG_CACHED;
        }
        ci.cancel();
    }
}

