/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.backwards_compat.FluidHelper;
import io.redspace.ironsspellbooks.registries.RecipeRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class EmptyAlchemistCauldronRecipe
extends Record
implements Recipe<Input> {
    private final ResourceLocation getId;
    private final Ingredient input;
    private final ItemStack result;
    private final FluidStack fluid;
    private final Holder<SoundEvent> emptySound;

    public EmptyAlchemistCauldronRecipe(ResourceLocation getId, Ingredient input, ItemStack result, FluidStack fluid, Holder<SoundEvent> emptySound) {
        this.getId = getId;
        this.input = input;
        this.result = result;
        this.fluid = fluid;
        this.emptySound = emptySound;
    }

    public ItemStack result() {
        return this.result.m_41777_();
    }

    public FluidStack fluid() {
        return this.fluid.copy();
    }

    public boolean matches(Input input, Level level) {
        return this.input.test(input.item()) && input.fluid.getAmount() >= this.fluid.getAmount() && FluidHelper.isSameFluidSameComponents(this.fluid, input.fluid);
    }

    public ItemStack assemble(Input pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.ALCHEMIST_CAULDRON_EMPTY_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_EMPTY_TYPE.get();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{EmptyAlchemistCauldronRecipe.class, "getId;input;result;fluid;emptySound", "getId", "input", "result", "fluid", "emptySound"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EmptyAlchemistCauldronRecipe.class, "getId;input;result;fluid;emptySound", "getId", "input", "result", "fluid", "emptySound"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EmptyAlchemistCauldronRecipe.class, "getId;input;result;fluid;emptySound", "getId", "input", "result", "fluid", "emptySound"}, this, o);
    }

    public ResourceLocation m_6423_() {
        return this.getId;
    }

    public Ingredient input() {
        return this.input;
    }

    public Holder<SoundEvent> emptySound() {
        return this.emptySound;
    }

    public record Input(ItemStack item, FluidStack fluid) implements Container
    {
        public int m_6643_() {
            return 1;
        }

        public boolean m_7983_() {
            return false;
        }

        public ItemStack m_8020_(int index) {
            return this.item;
        }

        public ItemStack m_7407_(int pSlot, int pAmount) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int pSlot) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int pSlot, ItemStack pStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player pPlayer) {
            return false;
        }

        public void m_6211_() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<EmptyAlchemistCauldronRecipe> {
        public EmptyAlchemistCauldronRecipe fromJson(ResourceLocation id, JsonObject recipejson) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)recipejson, (String)"input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)recipejson, (String)"result"));
            FluidStack fluid = (FluidStack)((Pair)FluidStack.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_289747_((JsonObject)recipejson, (String)"fluid")).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0))).getFirst();
            Holder sound = BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11769_);
            if (recipejson.has("sound")) {
                sound = (Holder)((Pair)BuiltInRegistries.f_256894_.m_206110_().decode((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.m_289747_((JsonObject)recipejson, (String)"sound")).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0))).getFirst();
            }
            return new EmptyAlchemistCauldronRecipe(id, input, result, fluid, (Holder<SoundEvent>)sound);
        }

        @Nullable
        public EmptyAlchemistCauldronRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buf);
            Holder sound = BuiltInRegistries.f_256894_.m_263177_((Object)Objects.requireNonNull((SoundEvent)BuiltInRegistries.f_256894_.m_7745_(buf.m_130281_())));
            return new EmptyAlchemistCauldronRecipe(pRecipeId, input, result, fluid, (Holder<SoundEvent>)sound);
        }

        public void toNetwork(FriendlyByteBuf buf, EmptyAlchemistCauldronRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.result);
            recipe.fluid.writeToPacket(buf);
            buf.m_130085_(((SoundEvent)recipe.emptySound.get()).m_11660_());
        }
    }
}

