/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.attribute.IMagicAttribute;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.effect.IMobEffectEndCallback;
import io.redspace.ironsspellbooks.effect.ISyncedMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.item.armor.IArmorCapeProvider;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements MagicData.IExtendedEntity {
    @Unique
    MagicData irons_spellbooks$magicData = null;
    @Unique
    IArmorCapeProvider.CapeData irons_spellbooks$capeData = null;
    @Unique
    private static final List<EquipmentSlot> handSlots = List.of(EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND);
    @Unique
    private static final Predicate<Attribute> allNonBaseAttackAttributes = attribute -> attribute != ForgeMod.ENTITY_REACH.get() && attribute != Attributes.f_22281_ && attribute != Attributes.f_22283_ && attribute != Attributes.f_22282_;
    @Unique
    private static final Predicate<Attribute> onlyIronAttributes = attribute -> attribute instanceof IMagicAttribute;

    @Override
    public IArmorCapeProvider.CapeData irons_spellbooks$getCapData() {
        if (this.irons_spellbooks$capeData == null) {
            this.irons_spellbooks$capeData = new IArmorCapeProvider.CapeData();
        }
        return this.irons_spellbooks$capeData;
    }

    @Override
    public MagicData irons_spellbooks$getMagicData() {
        if (this.irons_spellbooks$magicData == null) {
            LivingEntityMixin livingEntityMixin = this;
            if (livingEntityMixin instanceof Player) {
                Player player = (Player)livingEntityMixin;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    this.irons_spellbooks$magicData = new MagicData(serverplayer);
                } else {
                    this.irons_spellbooks$magicData = new MagicData();
                }
            } else {
                this.irons_spellbooks$magicData = new MagicData(true);
            }
        }
        assert (this.irons_spellbooks$magicData != null);
        return this.irons_spellbooks$magicData;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void irons_spellbooks$saveDataAttachment(CompoundTag pCompound, CallbackInfo ci) {
        if (this.irons_spellbooks$magicData == null) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        this.irons_spellbooks$magicData.saveNBTData(tag, (HolderLookup.Provider)((Entity)this).f_19853_.m_9598_());
        pCompound.m_128365_("irons_spellbooks:magic_data", (Tag)tag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void irons_spellbooks$readDataAttachment(CompoundTag pCompound, CallbackInfo ci) {
        if (!pCompound.m_128441_("irons_spellbooks:magic_data")) {
            return;
        }
        this.irons_spellbooks$getMagicData();
        CompoundTag tag = pCompound.m_128469_("irons_spellbooks:magic_data");
        this.irons_spellbooks$magicData.loadNBTData(tag, (HolderLookup.Provider)((Entity)this).f_19853_.m_9598_());
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")})
    public void irons_spellbooks$onEffectRemoved(MobEffectInstance effectInstance, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (!self.f_19853_.f_46443_) {
            MobEffect mobEffect = effectInstance.m_19544_();
            if (mobEffect instanceof IMobEffectEndCallback) {
                IMobEffectEndCallback mobEffect2 = (IMobEffectEndCallback)mobEffect;
                mobEffect2.onEffectRemoved(self, effectInstance.m_19564_());
            }
            if (effectInstance.m_19544_() instanceof ISyncedMobEffect && (mobEffect = self.f_19853_.m_7726_()) instanceof ServerChunkCache) {
                ServerChunkCache serverChunk = (ServerChunkCache)mobEffect;
                serverChunk.m_8445_((Entity)self, (Packet)new ClientboundRemoveMobEffectPacket(self.m_19879_(), effectInstance.m_19544_()));
            }
        }
    }

    @Inject(method={"onEffectUpdated"}, at={@At(value="HEAD")})
    public void irons_spellbooks$onEffectUpdated(MobEffectInstance effectInstance, boolean forced, Entity entity, CallbackInfo ci) {
        ChunkSource chunkSource;
        LivingEntity self = (LivingEntity)this;
        if (!self.f_19853_.f_46443_ && effectInstance.m_19544_() instanceof ISyncedMobEffect && (chunkSource = self.f_19853_.m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverChunk = (ServerChunkCache)chunkSource;
            serverChunk.m_8445_((Entity)self, (Packet)new ClientboundUpdateMobEffectPacket(self.m_19879_(), effectInstance));
        }
    }

    @Inject(method={"onEffectAdded"}, at={@At(value="HEAD")})
    public void irons_spellbooks$onEffectAdded(MobEffectInstance effectInstance, Entity entity, CallbackInfo ci) {
        ChunkSource chunkSource;
        LivingEntity self = (LivingEntity)this;
        if (!self.f_19853_.f_46443_ && effectInstance.m_19544_() instanceof ISyncedMobEffect && (chunkSource = self.f_19853_.m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverChunk = (ServerChunkCache)chunkSource;
            serverChunk.m_8445_((Entity)self, (Packet)new ClientboundUpdateMobEffectPacket(self.m_19879_(), effectInstance));
        }
    }

    @Inject(method={"updateInvisibilityStatus"}, at={@At(value="TAIL")})
    public void irons_spellbooks$updateInvisibilityStatus(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (self.m_21023_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get())) {
            self.m_6842_(true);
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    public void irons_spellbooks$isCurrentlyGlowing(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (!self.f_19853_.m_5776_() && self.m_21023_((MobEffect)MobEffectRegistry.GUIDING_BOLT.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    public void irons_spellbooks$changeSummonHurtCredit(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        IMagicSummon summon;
        IMagicSummon fromSummon;
        IMagicSummon summon2;
        Entity entity = damageSource.m_7640_();
        IMagicSummon iMagicSummon = entity instanceof IMagicSummon ? (summon2 = (IMagicSummon)entity) : (fromSummon = (entity = damageSource.m_7639_()) instanceof IMagicSummon ? (summon = (IMagicSummon)entity) : null);
        if (fromSummon instanceof LivingEntity) {
            LivingEntity livingSummon = (LivingEntity)fromSummon;
            ((LivingEntity)this).m_6703_(livingSummon);
        }
    }

    @Shadow
    abstract ItemStack m_21244_(EquipmentSlot var1);

    @Unique
    private static Multimap<Attribute, AttributeModifier> filterApplicableAttributes(Multimap<Attribute, AttributeModifier> attributeModifierMap) {
        HashMultimap map = HashMultimap.create();
        for (Attribute attribute : attributeModifierMap.keySet()) {
            Predicate<Attribute> predicate = (Boolean)ServerConfigs.APPLY_ALL_MULTIHAND_ATTRIBUTES.get() != false ? allNonBaseAttackAttributes : onlyIronAttributes;
            if (!predicate.test(attribute)) continue;
            map.putAll((Object)attribute, (Iterable)attributeModifierMap.get((Object)attribute));
        }
        return map;
    }
}

