/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.api.backwards_compat.CodecHelper;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class FurledMapItem
extends Item {
    public static final ResourceKey<Level> OVERWORLD = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld"));
    public static final ResourceKey<Level> NETHER = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"the_nether"));

    public FurledMapItem() {
        super(ItemPropertiesHelper.material().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            level.m_6269_(null, (Entity)player, SoundEvents.f_12493_, player.m_5720_(), 1.0f, 1.0f);
            ItemStack itemStack = player.m_21120_(hand);
            player.m_36335_().m_41524_(itemStack.m_41720_(), 50);
            if (FurledMapData.has(itemStack)) {
                Pair pair;
                FurledMapData furledMapData = FurledMapData.get(itemStack);
                ResourceKey structureResourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)furledMapData.destinationResource);
                Optional<HolderSet.Direct> holder = serverlevel.m_9598_().m_175515_(Registries.f_256944_).m_203636_(structureResourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0}));
                if (furledMapData.dimension().isPresent()) {
                    ResourceKey<Level> dimensionRestriction = furledMapData.dimension().get();
                    if (!serverlevel.m_46472_().equals(dimensionRestriction)) {
                        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"item.irons_spellbooks.furled_map.dimension_fail").m_130940_(ChatFormatting.RED)));
                        return InteractionResultHolder.m_19100_((Object)itemStack);
                    }
                }
                if (holder.isPresent() && (pair = serverlevel.m_7726_().m_8481_().m_223037_(serverlevel, (HolderSet)holder.get(), player.m_20183_(), 100, ((Boolean)ServerConfigs.FURLED_MAPS_SKIP_CHUNKS.get()).booleanValue())) != null) {
                    BlockPos blockpos = (BlockPos)pair.getFirst();
                    ItemStack mapStack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                    MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)mapStack);
                    MapItemSavedData.m_77925_((ItemStack)mapStack, (BlockPos)blockpos, (String)"x", (MapDecoration.Type)MapDecoration.Type.RED_X);
                    furledMapData.descriptionOverride.ifPresent(arg_0 -> ((ItemStack)mapStack).m_41714_(arg_0));
                    FurledMapItem.replaceItem(player, mapStack, hand);
                    return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.f_46443_);
                }
            }
            FurledMapItem.replaceItem(player, new ItemStack((ItemLike)Items.f_42676_), hand);
        }
        return super.m_7203_(level, player, hand);
    }

    private static void replaceItem(Player player, ItemStack itemStack, InteractionHand hand) {
        boolean flag = player.m_150110_().f_35937_;
        if (!flag) {
            player.m_21008_(hand, itemStack);
        } else {
            player.m_150109_().m_36054_(itemStack);
        }
    }

    public static ItemStack of(ResourceLocation structure, MutableComponent descriptor) {
        ItemStack itemStack = new ItemStack((ItemLike)ItemRegistry.FURLED_MAP.get());
        FurledMapData.set(itemStack, new FurledMapData(structure, Optional.empty(), Optional.of(descriptor)));
        FurledMapData.setLoreHelper(itemStack, (Component)Component.m_237110_((String)"item.irons_spellbooks.furled_map_descriptor_framing", (Object[])new Object[]{descriptor}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        return itemStack;
    }

    public static ItemStack of(ResourceLocation structure, ResourceKey<Level> exclusiveDimension, MutableComponent descriptor) {
        return FurledMapItem.of(structure, exclusiveDimension, descriptor, false);
    }

    public static ItemStack of(ResourceLocation structure, ResourceKey<Level> exclusiveDimension, MutableComponent descriptor, boolean ancient) {
        ItemStack itemStack = new ItemStack(ancient ? (ItemLike)ItemRegistry.ANCIENT_FURLED_MAP.get() : (ItemLike)ItemRegistry.FURLED_MAP.get());
        FurledMapData.set(itemStack, new FurledMapData(structure, Optional.of(exclusiveDimension), Optional.of(descriptor)));
        FurledMapData.setLoreHelper(itemStack, (Component)Component.m_237110_((String)"item.irons_spellbooks.furled_map_descriptor_framing", (Object[])new Object[]{descriptor}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        return itemStack;
    }

    public record FurledMapData(ResourceLocation destinationResource, Optional<ResourceKey<Level>> dimension, Optional<Component> descriptionOverride) {
        public static final String NBT = "irons_spellbooks:furled_map_data";
        public static final String LEGACY_NBT = "furledMapData";
        public static final String FURLED_MAP_LOCATION = "destination";
        public static final String FURLED_MAP_DESCRIPTION = "description";
        public static final Codec<FurledMapData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.fieldOf(FURLED_MAP_LOCATION).forGetter(FurledMapData::destinationResource), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).optionalFieldOf("dimension").forGetter(FurledMapData::dimension), (App)ExtraCodecs.f_252442_.optionalFieldOf("descriptionOverride").forGetter(FurledMapData::descriptionOverride)).apply((Applicative)builder, FurledMapData::new));
        public static final Codec<FurledMapData> LEGACY_CODEC = CodecHelper.createLegacyCodec(tag -> {
            CompoundTag nbt = (CompoundTag)tag;
            String destination = nbt.m_128461_(FURLED_MAP_LOCATION);
            String rawDesc = nbt.m_128461_(FURLED_MAP_DESCRIPTION);
            Optional<Component> desc = Optional.empty();
            if (!rawDesc.isEmpty()) {
                desc = Optional.ofNullable(Component.Serializer.m_130701_((String)rawDesc));
            }
            return new FurledMapData(ResourceLocation.parse((String)destination), Optional.empty(), desc);
        });

        public static boolean has(ItemStack stack) {
            return CodecHelper.hasWithLegacy(stack, NBT, LEGACY_NBT);
        }

        public static FurledMapData get(ItemStack stack) {
            return CodecHelper.getWithLegacy(CODEC, stack, NBT, LEGACY_NBT, LEGACY_CODEC);
        }

        public static void set(ItemStack stack, FurledMapData data) {
            CodecHelper.set(stack, NBT, CODEC, data);
        }

        public static void setLoreHelper(ItemStack stack, Component line) {
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line)));
            stack.m_41698_("display").m_128365_("Lore", (Tag)lore);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof FurledMapData)) return false;
            FurledMapData data = (FurledMapData)obj;
            if (!data.destinationResource.equals((Object)this.destinationResource)) return false;
            if (!data.descriptionOverride.equals(this.descriptionOverride)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.destinationResource.hashCode() + this.descriptionOverride.hashCode() * 31;
        }
    }
}

