/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.portal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalEntity;
import io.redspace.ironsspellbooks.render.RenderHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PortalRenderer
extends EntityRenderer<PortalEntity> {
    private static final ResourceLocation ROUND_PORTAL = IronsSpellbooks.id("textures/entity/portal/portal_round.png");
    private static final ResourceLocation ELDRITCH_ROUND_PORTAL = IronsSpellbooks.id("textures/entity/portal/pocket_dimension_portal_round.png");
    private static final ResourceLocation ELDRITCH_SQUARE_PORTAL = IronsSpellbooks.id("textures/entity/portal/pocket_dimension_portal_square.png");
    private static final ResourceLocation SQUARE_PORTAL = IronsSpellbooks.id("textures/entity/portal/portal_square.png");
    private static final ResourceLocation SQUARE_COLOR_PORTAL = IronsSpellbooks.id("textures/entity/portal/portal_square_color.png");
    static int frameCount = 10;
    static int ticksPerFrame = 2;

    public PortalRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PortalEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_()));
        PortalRenderer.renderPortal(poseStack, bufferSource, entity.f_19797_, partialTicks, true, -1);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public static void renderPortal(PoseStack poseStack, MultiBufferSource buffer, int animationTick, float partialTicks, boolean round, int color) {
        PortalRenderer.renderPortal(poseStack, buffer, animationTick, partialTicks, round, false, color);
    }

    public static void renderPortal(PoseStack poseStack, MultiBufferSource buffer, int animationTick, float partialTicks, boolean round, boolean eldritch, int color) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        ResourceLocation texture = round ? (eldritch ? ELDRITCH_ROUND_PORTAL : ROUND_PORTAL) : (eldritch ? ELDRITCH_SQUARE_PORTAL : (color == -1 ? SQUARE_PORTAL : SQUARE_COLOR_PORTAL));
        VertexConsumer consumer = buffer.m_6299_(RenderHelper.CustomerRenderType.darkGlow(texture));
        int anim = animationTick / ticksPerFrame % frameCount;
        float uvMin = (float)anim / (float)frameCount;
        float uvMax = (float)(anim + 1) / (float)frameCount;
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, -8.0f, 0.0f, 0.0f, uvMin, 0.0f, color);
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, 8.0f, 0.0f, 0.0f, uvMax, 0.0f, color);
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, 8.0f, 32.0f, 0.0f, uvMax, 1.0f, color);
        PortalRenderer.vertex(poseMatrix, normalMatrix, consumer, -8.0f, 32.0f, 0.0f, uvMin, 1.0f, color);
        poseStack.m_85849_();
    }

    public static void renderPortal(PoseStack poseStack, MultiBufferSource buffer, int animationTick, float partialTicks, boolean round) {
        PortalRenderer.renderPortal(poseStack, buffer, animationTick, partialTicks, round, -1);
    }

    public static void vertex(Matrix4f pMatrix, Matrix3f pNormals, VertexConsumer pVertexBuilder, float pOffsetX, float pOffsetY, float pOffsetZ, float pTextureX, float pTextureY, int color) {
        int r = 255;
        int g = 255;
        int b = 255;
        if (color != -1) {
            r = (color & 0xFF0000) >> 16;
            g = (color & 0xFF00) >> 8;
            b = color & 0xFF;
        }
        pVertexBuilder.m_252986_(pMatrix, pOffsetX, pOffsetY, pOffsetZ).m_6122_(r, g, b, 100).m_7421_(pTextureX, pTextureY).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(PortalEntity entity) {
        return ROUND_PORTAL;
    }
}

