/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class FireEruptionAoe
extends AoeEntity {
    int waveAnim = -1;

    public FireEruptionAoe(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.reapplicationDelay = 25;
        this.setCircular();
    }

    public FireEruptionAoe(Level level, float radius) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.FIRE_ERUPTION_AOE.get()), level);
        this.setRadius(radius);
    }

    @Override
    public void applyEffect(LivingEntity target) {
        SpellDamageSource damageSource = ((AbstractSpell)SpellRegistry.RAISE_HELL_SPELL.get()).getDamageSource((Entity)(this.m_19749_() == null ? this : this.m_19749_()));
        DamageSources.ignoreNextKnockback(target);
        if (target.m_6469_((DamageSource)damageSource, this.getDamage())) {
            target.m_7311_(100);
            target.m_20256_(target.m_20184_().m_82520_(0.0, 0.65, 0.0));
            target.f_19864_ = true;
        }
    }

    @Override
    public float getParticleCount() {
        return 0.0f;
    }

    @Override
    public void ambientParticles() {
    }

    @Override
    public void m_8119_() {
        float radius = this.getRadius();
        Level level = this.f_19853_;
        int n = this.waveAnim++;
        if ((float)n < radius) {
            if (!level.f_46443_) {
                BlockPos blockPos;
                Vec3 vec3;
                int i;
                if (this.waveAnim % 2 == 0) {
                    float volume = (float)(this.waveAnim + 8) / 16.0f;
                    this.m_5496_((SoundEvent)SoundRegistry.EARTHQUAKE_IMPACT.get(), volume, (float)Utils.random.m_216332_(90, 110) * 0.01f);
                }
                float circumferenceMin = (float)((this.waveAnim - 1) * 2) * 3.14f;
                float circumferenceMax = (float)((this.waveAnim + 1) * 2) * 3.14f;
                int minBlocks = Mth.m_14045_((int)((int)circumferenceMin), (int)0, (int)60);
                int maxBlocks = Mth.m_14045_((int)((int)circumferenceMax), (int)0, (int)60);
                float anglePerBlockMin = 360.0f / (float)minBlocks;
                float anglePerBlockMax = 360.0f / (float)maxBlocks;
                for (i = 0; i < minBlocks; ++i) {
                    vec3 = new Vec3((double)((float)this.waveAnim * Mth.m_14089_((float)(anglePerBlockMin * (float)i))), 0.0, (double)((float)this.waveAnim * Mth.m_14031_((float)(anglePerBlockMin * (float)i))));
                    blockPos = BlockPos.m_274446_((Position)Utils.moveToRelativeGroundLevel(level, this.m_20182_().m_82549_(vec3), 4)).m_7495_();
                    Utils.createTremorBlock(level, blockPos, 0.1f + this.f_19796_.m_188501_() * 0.2f);
                }
                for (i = 0; i < maxBlocks; ++i) {
                    vec3 = new Vec3((double)((float)(this.waveAnim + 1) * Mth.m_14089_((float)(anglePerBlockMax * (float)i))), 0.0, (double)((float)(this.waveAnim + 1) * Mth.m_14031_((float)(anglePerBlockMax * (float)i))));
                    blockPos = BlockPos.m_274446_((Position)Utils.moveToRelativeGroundLevel(level, this.m_20182_().m_82549_(vec3), 4).m_82520_(0.0, 0.1, 0.0));
                    if (!level.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)level, blockPos.m_7495_(), Direction.UP)) continue;
                    Utils.createTremorBlockWithState(level, Blocks.f_50083_.m_49966_(), blockPos, 0.1f + this.f_19796_.m_188501_() * 0.2f);
                }
                List targets = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(this.getInflation().f_82479_, this.getInflation().f_82480_, this.getInflation().f_82481_));
                int r1Sqr = this.waveAnim * this.waveAnim;
                int r2Sqr = (this.waveAnim + 1) * (this.waveAnim + 1);
                for (LivingEntity target : targets) {
                    double distanceSqr = target.m_20280_((Entity)this);
                    if (!this.m_5603_((Entity)target) || !(distanceSqr >= (double)r1Sqr) || !(distanceSqr <= (double)r2Sqr) || !this.canHitTargetForGroundContext(target)) continue;
                    this.applyEffect(target);
                }
            } else {
                int particles = (int)((float)((this.waveAnim + 1) * 2) * 3.14f * 2.5f);
                float anglePerParticle = (float)Math.PI * 2 / (float)particles;
                for (int i = 0; i < particles; ++i) {
                    Vec3 trig = new Vec3((double)Mth.m_14089_((float)(anglePerParticle * (float)i)), 0.0, (double)Mth.m_14031_((float)(anglePerParticle * (float)i)));
                    float r = Mth.m_14179_((float)Utils.random.m_188501_(), (float)this.waveAnim, (float)(this.waveAnim + 1));
                    Vec3 pos = trig.m_82490_((double)r).m_82549_(Utils.getRandomVec3(0.4)).m_82549_(this.m_20182_()).m_82520_(0.0, 0.5, 0.0);
                    Vec3 motion = trig.m_82549_(Utils.getRandomVec3(0.5)).m_82490_(0.1);
                    level.m_7106_(ParticleHelper.FIRE, pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
        } else {
            this.m_146870_();
        }
    }

    public boolean m_142391_() {
        return false;
    }

    @Override
    protected boolean canHitTargetForGroundContext(LivingEntity target) {
        return !this.f_19853_.m_45772_(target.m_20191_().m_82383_(new Vec3(0.0, -0.9999, 0.0)));
    }

    @Override
    protected Vec3 getInflation() {
        return new Vec3(0.0, 5.0, 0.0);
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)3.0f);
    }

    @Override
    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }
}

