/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobRenderer;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossEntity;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossFireballChargeLayer;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossFlameLayer;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossModel;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossSoulLayer;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;

public class FireBossRenderer
extends AbstractSpellCastingMobRenderer {
    static final int deathFadeTime = 120;

    public FireBossRenderer(EntityRendererProvider.Context context) {
        super(context, new FireBossModel());
        this.f_114477_ = 0.65f;
        this.addRenderLayer(new FireBossSoulLayer(this));
        this.addRenderLayer(new FireBossFlameLayer(this));
        this.addRenderLayer(new FireBossFireballChargeLayer(this, context));
    }

    public void preRender(PoseStack poseStack, AbstractSpellCastingMob animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        FireBossEntity fireBoss;
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        float scale = animatable instanceof FireBossEntity && (fireBoss = (FireBossEntity)animatable).isSoulMode() ? 2.0125f : 1.75f;
        poseStack.m_85841_(scale, scale, scale);
    }

    @Override
    public void render(AbstractSpellCastingMob entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        FireBossEntity fireBossEntity;
        if (entity instanceof FireBossEntity && (fireBossEntity = (FireBossEntity)entity).isSpawning()) {
            float f = fireBossEntity.getSpawnWalkPercent(partialTick);
            if (f == 0.0f) {
                return;
            }
            this.f_114477_ = Mth.m_14179_((float)f, (float)2.0f, (float)0.65f);
            this.f_114478_ = Mth.m_14179_((float)f, (float)0.0f, (float)1.0f);
        } else {
            this.f_114478_ = 1.0f;
            this.f_114477_ = 0.65f;
        }
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, Mth.m_14045_((int)(packedLight + 100), (int)0, (int)240));
    }

    public void applyRenderLayersForBone(PoseStack poseStack, AbstractSpellCastingMob animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        FireBossEntity fireBoss;
        super.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        if (bone.getName().equals("bipedHandLeft") && animatable instanceof FireBossEntity && (fireBoss = (FireBossEntity)animatable).spectralDaggerActive()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85837_(-0.375, 0.1, -1.0);
            Minecraft.m_91087_().m_91291_().m_115143_(((Item)ItemRegistry.HELLRAZOR.get()).m_7968_(), ItemDisplayContext.THIRD_PERSON_LEFT_HAND, true, poseStack, bufferSource, packedLight, packedOverlay, Minecraft.m_91087_().m_91304_().getModel(IronsSpellbooks.id("item/fiery_dagger")));
            poseStack.m_85849_();
        }
    }

    public int getPackedOverlay(AbstractSpellCastingMob animatable, float u, float partialTick) {
        return OverlayTexture.f_118083_;
    }

    @Override
    public Color getRenderColor(AbstractSpellCastingMob animatable, float partialTick, int packedLight) {
        FireBossEntity fireBoss;
        Color color = super.getRenderColor(animatable, partialTick, packedLight);
        float f = 1.0f;
        if (animatable.f_20919_ > 40) {
            f = Mth.m_14036_((float)((float)(160 - animatable.f_20919_) / 120.0f), (float)0.0f, (float)1.0f);
        } else if (animatable instanceof FireBossEntity && (fireBoss = (FireBossEntity)animatable).isSpawning()) {
            f = fireBoss.getSpawnWalkPercent(partialTick);
        }
        if (!animatable.m_20145_() && f != 1.0f) {
            color = new Color(RenderHelper.colorf(1.0f, 1.0f, 1.0f, f));
        }
        return color;
    }

    @Override
    public RenderType getRenderType(AbstractSpellCastingMob animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        FireBossEntity fireBoss;
        if (animatable.m_21224_() || animatable instanceof FireBossEntity && ((fireBoss = (FireBossEntity)animatable).isSpawning() || fireBoss.isDespawning())) {
            return RenderType.m_110473_((ResourceLocation)texture);
        }
        return super.getRenderType(animatable, texture, bufferSource, partialTick);
    }

    protected float getDeathMaxRotation(AbstractSpellCastingMob animatable) {
        return 0.0f;
    }
}

