/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.goals;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class AlchemistAttackGoal
extends WizardAttackGoal {
    protected float throwRangeSqr;
    protected float throwRange;
    protected float potionBias;
    public static final List<MobEffect> ATTACK_POTIONS = List.of(MobEffects.f_19613_, MobEffects.f_19610_, MobEffects.f_19620_, MobEffects.f_19597_, MobEffects.f_19599_);

    public AlchemistAttackGoal(IMagicEntity abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval, float throwRange, float potionBias) {
        super(abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval);
        this.throwRange = throwRange;
        this.throwRangeSqr = throwRange * throwRange;
        this.spellcastingRange = throwRange - 2.0f;
        this.spellcastingRangeSqr = this.spellcastingRange * this.spellcastingRange;
        this.potionBias = potionBias;
    }

    @Override
    public AlchemistAttackGoal setSpells(List<AbstractSpell> attackSpells, List<AbstractSpell> defenseSpells, List<AbstractSpell> movementSpells, List<AbstractSpell> supportSpells) {
        return (AlchemistAttackGoal)super.setSpells(attackSpells, defenseSpells, movementSpells, supportSpells);
    }

    @Override
    public AlchemistAttackGoal setSpellQuality(float minSpellQuality, float maxSpellQuality) {
        return (AlchemistAttackGoal)super.setSpellQuality(minSpellQuality, maxSpellQuality);
    }

    @Override
    public AlchemistAttackGoal setSingleUseSpell(AbstractSpell spellType, int minDelay, int maxDelay, int minLevel, int maxLevel) {
        return (AlchemistAttackGoal)super.setSingleUseSpell(spellType, minDelay, maxDelay, minLevel, maxLevel);
    }

    @Override
    public AlchemistAttackGoal setIsFlying() {
        return (AlchemistAttackGoal)super.setIsFlying();
    }

    @Override
    protected void doSpellAction() {
        if (this.mob.m_20280_((Entity)this.target) < (double)this.throwRangeSqr && this.mob.m_217043_().m_188501_() < this.potionBias) {
            int attackWeight = this.getAttackWeight();
            int supportWeight = this.getSupportWeight();
            ItemStack potion = new ItemStack((ItemLike)Items.f_42736_);
            LivingEntity targetedEntity = this.target;
            if (this.hasLineOfSight && this.mob.m_217043_().m_188501_() * (float)(attackWeight + supportWeight) > (float)supportWeight) {
                MobEffect effect;
                int amplifier = (this.mob.m_217043_().m_188501_() < 0.75f ? 0 : 1) + (this.target.m_21233_() > 30.0f ? (this.mob.m_217043_().m_188501_() < 0.5f ? 0 : 1) : 0);
                MobEffect mobEffect = effect = this.target.m_21222_() ? MobEffects.f_19601_ : MobEffects.f_19602_;
                if (this.mob.m_217043_().m_188501_() < 0.45f) {
                    for (int i = 0; i < ATTACK_POTIONS.size(); ++i) {
                        int p = this.mob.m_217043_().m_188503_(ATTACK_POTIONS.size());
                        if (this.target.m_21023_(ATTACK_POTIONS.get(p))) continue;
                        effect = ATTACK_POTIONS.get(p);
                        break;
                    }
                }
                PotionUtils.m_43552_((ItemStack)potion, List.of(new MobEffectInstance(effect, effect.m_8093_() ? 0 : 200, amplifier)));
                PotionUtils.m_43549_((ItemStack)potion, (Potion)Potions.f_43599_);
            } else {
                Utils.setPotion(potion, Potions.f_43581_);
                targetedEntity = this.mob;
            }
            ThrownPotion thrownpotion = new ThrownPotion(this.mob.f_19853_, (LivingEntity)this.mob);
            thrownpotion.m_37446_(potion);
            thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
            Vec3 vec3 = targetedEntity.m_20184_();
            double d0 = targetedEntity.m_20185_() + vec3.f_82479_ - this.mob.m_20185_();
            double d1 = targetedEntity.m_20188_() - (double)1.1f - this.mob.m_20188_();
            double d2 = targetedEntity.m_20189_() + vec3.f_82481_ - this.mob.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            thrownpotion.m_6686_(d0, d1 + d3 * 0.2, d2, (float)Mth.m_14085_((double)0.5, (double)1.25, (double)(this.mob.m_20280_((Entity)targetedEntity) / (double)this.throwRangeSqr)), 8.0f);
            if (!this.mob.m_20067_()) {
                this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12553_, this.mob.m_5720_(), 1.0f, 0.8f + this.mob.m_217043_().m_188501_() * 0.4f);
            }
            this.mob.f_19853_.m_7967_((Entity)thrownpotion);
            this.mob.m_21011_(InteractionHand.MAIN_HAND, true);
        } else {
            super.doSpellAction();
        }
    }
}

