/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.effect;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.entity.spells.LightningStrike;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ThunderstormEffect
extends MagicMobEffect {
    public ThunderstormEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 40 == 0;
    }

    public void m_6742_(LivingEntity entity, int pAmplifier) {
        int radiusSqr = 400;
        entity.f_19853_.m_6443_(LivingEntity.class, entity.m_20191_().m_82377_(20.0, 12.0, 20.0), livingEntity -> livingEntity != entity && this.horizontalDistanceSqr((LivingEntity)livingEntity, entity) < (float)radiusSqr && livingEntity.m_6087_() && !livingEntity.m_5833_() && !Utils.shouldHealEntity((Entity)entity, (Entity)livingEntity) && Utils.hasLineOfSight(entity.f_19853_, (Entity)entity, (Entity)livingEntity, false)).forEach(targetEntity -> {
            LightningStrike lightningStrike = new LightningStrike(entity.f_19853_);
            lightningStrike.m_5602_((Entity)entity);
            lightningStrike.setDamage(ThunderstormEffect.getDamageFromAmplifier(pAmplifier, entity));
            lightningStrike.m_146884_(targetEntity.m_20182_());
            entity.f_19853_.m_7967_((Entity)lightningStrike);
        });
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, LivingEntity entity2) {
        double dx = livingEntity.m_20185_() - entity2.m_20185_();
        double dz = livingEntity.m_20189_() - entity2.m_20189_();
        return (float)(dx * dx + dz * dz);
    }

    public static float getDamageFromAmplifier(int effectAmplifier, @Nullable LivingEntity caster) {
        float power = caster == null ? 1.0f : ((AbstractSpell)SpellRegistry.THUNDERSTORM_SPELL.get()).getEntityPowerMultiplier(caster);
        return (float)(effectAmplifier - 7) * power + 7.0f;
    }
}

