/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.effect;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.entity.mobs.frozen_humanoid.FrozenHumanoid;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FrostbiteEffect
extends MagicMobEffect {
    public FrostbiteEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    @SubscribeEvent
    public static void handleFrostbiteDeathEffects(LivingDeathEvent event) {
        LivingEntity attacker;
        MobEffectInstance effect;
        Entity entity;
        DamageSource damageSource = event.getSource();
        LivingEntity entity2 = event.getEntity();
        if (damageSource != null && (entity = damageSource.m_7639_()) instanceof LivingEntity && (effect = (attacker = (LivingEntity)entity).m_21124_((MobEffect)MobEffectRegistry.FROSTBITTEN_STRIKES.get())) != null && entity2.m_146890_()) {
            FrozenHumanoid iceClone = new FrozenHumanoid(entity2.f_19853_, entity2);
            iceClone.setSummoner(attacker);
            iceClone.setShatterDamage(FrostbiteEffect.getDamageForAmplifier(effect.m_19564_(), attacker));
            iceClone.setDeathTimer(100);
            entity2.f_19853_.m_7967_((Entity)iceClone);
            entity2.f_20919_ = 1000;
            iceClone.m_5496_((SoundEvent)SoundRegistry.FROSTBITE_FREEZE.get(), 2.0f, (float)Utils.random.m_216339_(9, 11) * 0.1f);
        }
    }

    public static float getDamageForAmplifier(int effectAmplifier, @Nullable LivingEntity caster) {
        float power = caster == null ? 1.0f : ((AbstractSpell)SpellRegistry.FROSTBITE_SPELL.get()).getEntityPowerMultiplier(caster);
        return (float)(1 + effectAmplifier) * power;
    }
}

