/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ManaCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mana").requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ManaCommand.changeMana((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), true)))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ManaCommand.changeMana((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), false)))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(context -> ManaCommand.getMana((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"targets"))))));
    }

    private static int changeMana(CommandSourceStack source, Collection<ServerPlayer> targets, int amount, boolean set) {
        String s;
        targets.forEach(serverPlayer -> {
            MagicData pmg = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            float base = set ? 0.0f : pmg.getMana();
            pmg.setMana((float)amount + base);
            PacketDistributor.sendToPlayer(serverPlayer, new SyncManaPacket(pmg));
        });
        String string = s = set ? "set" : "add";
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)("commands.mana." + s + ".success.single"), (Object[])new Object[]{amount, ((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)("commands.mana." + s + ".success.multiple"), (Object[])new Object[]{amount, targets.size()}), true);
        }
        return targets.size();
    }

    private static int getMana(CommandSourceStack source, ServerPlayer serverPlayer) {
        MagicData pmg = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        int mana = (int)pmg.getMana();
        source.m_288197_(() -> Component.m_237110_((String)"commands.mana.get.success", (Object[])new Object[]{serverPlayer.m_5446_(), mana}), true);
        return mana;
    }
}

