/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.spawning;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.SpawnData;

public record TrialSpawnerConfig(int spawnRange, float totalMobs, float simultaneousMobs, float totalMobsAddedPerPlayer, float simultaneousMobsAddedPerPlayer, int ticksBetweenSpawn, SimpleWeightedRandomList<SpawnData> spawnPotentialsDefinition, SimpleWeightedRandomList<ResourceLocation> lootTablesToEject, ResourceLocation itemsToDropWhenOminous) {
    public static final TrialSpawnerConfig DEFAULT = new TrialSpawnerConfig(4, 6.0f, 2.0f, 2.0f, 1.0f, 40, (SimpleWeightedRandomList<SpawnData>)SimpleWeightedRandomList.m_185864_(), (SimpleWeightedRandomList<ResourceLocation>)SimpleWeightedRandomList.m_146263_().m_146270_(), ResourceLocation.withDefaultNamespace((String)"empty"));
    public static final Codec<TrialSpawnerConfig> CODEC = RecordCodecBuilder.create(p_338041_ -> p_338041_.group((App)Codec.intRange((int)1, (int)128).optionalFieldOf("spawn_range", (Object)TrialSpawnerConfig.DEFAULT.spawnRange).forGetter(TrialSpawnerConfig::spawnRange), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("total_mobs", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.totalMobs)).forGetter(TrialSpawnerConfig::totalMobs), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("simultaneous_mobs", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.simultaneousMobs)).forGetter(TrialSpawnerConfig::simultaneousMobs), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("total_mobs_added_per_player", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.totalMobsAddedPerPlayer)).forGetter(TrialSpawnerConfig::totalMobsAddedPerPlayer), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("simultaneous_mobs_added_per_player", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.simultaneousMobsAddedPerPlayer)).forGetter(TrialSpawnerConfig::simultaneousMobsAddedPerPlayer), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("ticks_between_spawn", (Object)TrialSpawnerConfig.DEFAULT.ticksBetweenSpawn).forGetter(TrialSpawnerConfig::ticksBetweenSpawn), (App)SpawnData.f_186560_.optionalFieldOf("spawn_potentials", (Object)SimpleWeightedRandomList.m_185864_()).forGetter(TrialSpawnerConfig::spawnPotentialsDefinition), (App)SimpleWeightedRandomList.m_185860_((Codec)ResourceLocation.f_135803_).optionalFieldOf("loot_tables_to_eject", TrialSpawnerConfig.DEFAULT.lootTablesToEject).forGetter(TrialSpawnerConfig::lootTablesToEject), (App)ResourceLocation.f_135803_.optionalFieldOf("items_to_drop_when_ominous", (Object)TrialSpawnerConfig.DEFAULT.itemsToDropWhenOminous).forGetter(TrialSpawnerConfig::itemsToDropWhenOminous)).apply((Applicative)p_338041_, TrialSpawnerConfig::new));

    public int calculateTargetTotalMobs(int players) {
        return (int)Math.floor(this.totalMobs + this.totalMobsAddedPerPlayer * (float)players);
    }

    public int calculateTargetSimultaneousMobs(int players) {
        return (int)Math.floor(this.simultaneousMobs + this.simultaneousMobsAddedPerPlayer * (float)players);
    }

    public long ticksBetweenItemSpawners() {
        return 160L;
    }
}

