/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.backwards_compat;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class CodecHelper {
    public static <T> Codec<T> withAlternative(Codec<T> primary, Codec<? extends T> alternative) {
        return Codec.either(primary, alternative).xmap(either -> either.map(Function.identity(), Function.identity()), Either::left);
    }

    public static <T> T get(Codec<T> codec, Tag rawDataTag) {
        return (T)((Pair)codec.decode((DynamicOps)NbtOps.f_128958_, (Object)rawDataTag).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0))).getFirst();
    }

    public static <T> T getOrElse(Codec<T> codec, Tag rawDataTag, T backup) {
        return (T)codec.decode((DynamicOps)NbtOps.f_128958_, (Object)rawDataTag).get().map(Pair::getFirst, pair -> backup);
    }

    public static <T> T get(Codec<T> codec, ItemStack stack, String nbt) {
        return CodecHelper.get(codec, stack.m_41784_().m_128423_(nbt));
    }

    public static <T> T getOrElse(ItemStack stack, String nbt, Codec<T> codec, T empty) {
        return stack.m_41782_() && stack.m_41784_().m_128441_(nbt) ? CodecHelper.get(codec, stack.m_41784_().m_128423_(nbt)) : empty;
    }

    public static <T> T getWithLegacy(Codec<T> codec, ItemStack stack, String nbt, String legacyNbt, Codec<T> legacyCodec) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(nbt)) {
            return CodecHelper.get(codec, tag.m_128423_(nbt));
        }
        T data = CodecHelper.get(legacyCodec, tag.m_128423_(legacyNbt));
        tag.m_128473_(legacyNbt);
        tag.m_128365_(nbt, (Tag)codec.encode(data, (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0)));
        return data;
    }

    public static <T> T getOrElseWithLegacy(ItemStack stack, String nbt, Codec<T> codec, T empty, String legacyNbt, Codec<T> legacyCodec) {
        if (CodecHelper.hasWithLegacy(stack, nbt, legacyNbt)) {
            return CodecHelper.getWithLegacy(codec, stack, nbt, legacyNbt, legacyCodec);
        }
        return empty;
    }

    public static boolean hasWithLegacy(ItemStack stack, String nbt, String legacyNbt) {
        return stack.m_41782_() && (stack.m_41784_().m_128441_(nbt) || stack.m_41784_().m_128441_(legacyNbt));
    }

    public static <T> void set(ItemStack stack, String nbt, Codec<T> codec, T data) {
        stack.m_41784_().m_128365_(nbt, (Tag)codec.encode(data, (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).getOrThrow(false, arg_0 -> ((Logger)IronsSpellbooks.LOGGER).error(arg_0)));
    }

    public static boolean has(ItemStack stack, String nbt) {
        return stack.m_41782_() && stack.m_41784_().m_128441_(nbt);
    }

    public static <E> Codec<E> createLegacyCodec(final Function<Tag, E> decoder) {
        return Codec.of((Encoder)Encoder.error((String)"Legacy codec should never write!"), (Decoder)new Decoder<E>(){

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
                try {
                    Object data = decoder.apply((Tag)input);
                    return DataResult.success((Object)Pair.of(data, input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        });
    }
}

