/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.forge;

import com.starfish_studios.naturalist.Naturalist;
import com.starfish_studios.naturalist.NaturalistConfig;
import com.starfish_studios.naturalist.common.entity.Alligator;
import com.starfish_studios.naturalist.common.entity.Bear;
import com.starfish_studios.naturalist.common.entity.Bird;
import com.starfish_studios.naturalist.common.entity.Boar;
import com.starfish_studios.naturalist.common.entity.Butterfly;
import com.starfish_studios.naturalist.common.entity.Caterpillar;
import com.starfish_studios.naturalist.common.entity.Catfish;
import com.starfish_studios.naturalist.common.entity.Deer;
import com.starfish_studios.naturalist.common.entity.Dragonfly;
import com.starfish_studios.naturalist.common.entity.Duck;
import com.starfish_studios.naturalist.common.entity.Elephant;
import com.starfish_studios.naturalist.common.entity.Firefly;
import com.starfish_studios.naturalist.common.entity.Giraffe;
import com.starfish_studios.naturalist.common.entity.Hippo;
import com.starfish_studios.naturalist.common.entity.Lion;
import com.starfish_studios.naturalist.common.entity.Lizard;
import com.starfish_studios.naturalist.common.entity.LizardTail;
import com.starfish_studios.naturalist.common.entity.Moose;
import com.starfish_studios.naturalist.common.entity.Rhino;
import com.starfish_studios.naturalist.common.entity.Snail;
import com.starfish_studios.naturalist.common.entity.Snake;
import com.starfish_studios.naturalist.common.entity.Tortoise;
import com.starfish_studios.naturalist.common.entity.Vulture;
import com.starfish_studios.naturalist.core.platform.forge.CommonPlatformHelperImpl;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.forge.NaturalistBiomeModifiers;
import com.starfish_studios.naturalist.core.registry.forge.NaturalistCreativeModeTabForge;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.Collections;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.jetbrains.annotations.NotNull;

@Mod(value="naturalist")
public class NaturalistForge {
    public NaturalistForge() {
        Naturalist.init();
        MidnightConfig.init((String)"naturalist", NaturalistConfig.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueue);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonPlatformHelperImpl.BLOCKS.register(bus);
        CommonPlatformHelperImpl.ITEMS.register(bus);
        CommonPlatformHelperImpl.SOUND_EVENTS.register(bus);
        CommonPlatformHelperImpl.ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.POTIONS.register(bus);
        CommonPlatformHelperImpl.RECIPE_TYPES.register(bus);
        CommonPlatformHelperImpl.RECIPE_SERIALIZERS.register(bus);
        NaturalistCreativeModeTabForge.CREATIVE_MODE_TABS.register(bus);
        NaturalistBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(bus);
        bus.addListener(this::setup);
        bus.addListener(this::createAttributes);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void enqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("diet")) {
            NaturalistForge.dietIntegration(NaturalistRegistry.DUCK.get(), Foods.f_38817_);
            NaturalistForge.dietIntegration(NaturalistRegistry.COOKED_DUCK.get(), Foods.f_38821_);
            NaturalistForge.dietIntegration(NaturalistRegistry.VENISON.get(), Foods.f_38812_);
            NaturalistForge.dietIntegration(NaturalistRegistry.COOKED_VENISON.get(), Foods.f_38820_);
            NaturalistForge.dietIntegration(NaturalistRegistry.LIZARD_TAIL.get(), NaturalistRegistry.LIZARD_TAIL.get().m_41473_());
            NaturalistForge.dietIntegration(NaturalistRegistry.COOKED_LIZARD_TAIL.get(), NaturalistRegistry.COOKED_LIZARD_TAIL.get().m_41473_());
            NaturalistForge.dietIntegration(NaturalistRegistry.CATFISH.get(), Foods.f_38805_);
            NaturalistForge.dietIntegration(NaturalistRegistry.COOKED_CATFISH.get(), Foods.f_38826_);
            NaturalistForge.dietIntegration(NaturalistRegistry.BASS.get(), Foods.f_38819_);
            NaturalistForge.dietIntegration(NaturalistRegistry.COOKED_BASS.get(), Foods.f_38822_);
        }
    }

    public static void dietIntegration(Item item, FoodProperties food) {
        InterModComms.sendTo((String)"diet", (String)"item", () -> new Tuple((Object)item, (player, stack) -> new ImmutableTriple(Collections.singletonList(stack), (Object)food.m_38744_(), (Object)Float.valueOf(food.m_38745_()))));
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Naturalist.registerBrewingRecipes();
            Naturalist.registerCompostables();
            Naturalist.registerSpawnPlacements();
            Naturalist.registerDispenserBehaviors();
        });
    }

    private void createAttributes(@NotNull EntityAttributeCreationEvent event) {
        event.put(NaturalistEntityTypes.SNAIL.get(), Snail.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BEAR.get(), Bear.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BUTTERFLY.get(), Butterfly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.FIREFLY.get(), Firefly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.SNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CORAL_SNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.RATTLESNAKE.get(), Snake.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DEER.get(), Deer.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BLUEJAY.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CANARY.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CARDINAL.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ROBIN.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.FINCH.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.SPARROW.get(), Bird.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CATERPILLAR.get(), Caterpillar.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.RHINO.get(), Rhino.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.LION.get(), Lion.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ELEPHANT.get(), Elephant.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ZEBRA.get(), AbstractHorse.m_30627_().m_22265_());
        event.put(NaturalistEntityTypes.GIRAFFE.get(), Giraffe.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.HIPPO.get(), Hippo.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.VULTURE.get(), Vulture.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BOAR.get(), Boar.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DRAGONFLY.get(), Dragonfly.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.CATFISH.get(), Catfish.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.ALLIGATOR.get(), Alligator.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.BASS.get(), AbstractFish.m_27495_().m_22265_());
        event.put(NaturalistEntityTypes.LIZARD.get(), Lizard.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.LIZARD_TAIL.get(), LizardTail.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.MOOSE.get(), Moose.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.TORTOISE.get(), Tortoise.createAttributes().m_22265_());
        event.put(NaturalistEntityTypes.DUCK.get(), Duck.createAttributes().m_22265_());
    }
}

