/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.google.common.collect.Lists;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.api.BoxBuilder;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.skinlayers.util.SodiumWorkaround;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import dev.tr7zw.skinlayers.versionless.util.Direction;
import dev.tr7zw.skinlayers.versionless.util.wrapper.ModelBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_5604;
import net.minecraft.class_5606;
import net.minecraft.class_630;

public class CustomizableCubeListBuilder
implements ModelBuilder {
    private final List<CustomizableCube> cubes = Lists.newArrayList();
    private final List<class_630.class_628> vanillaCubes = Lists.newArrayList();
    private int u;
    private int v;
    private boolean mirror;
    private int textureWidth = 64;
    private int textureHeight = 64;

    public static ModelBuilder create() {
        return new CustomizableCubeListBuilder();
    }

    @Override
    public ModelBuilder textureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
        return this;
    }

    @Override
    public ModelBuilder uv(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Override
    public ModelBuilder mirror(boolean bl) {
        this.mirror = bl;
        return this;
    }

    public List<CustomizableCube> getCubes() {
        return this.cubes;
    }

    public List<class_630.class_628> getVanillaCubes() {
        return this.vanillaCubes;
    }

    @Override
    public ModelBuilder addBox(float x, float y, float z, float pixelSize, Direction[] hide, Direction[][] corners) {
        if (!SkinLayersModBase.config.irisCompatibilityMode) {
            this.cubes.add(new CustomizableCube(this.u, this.v, (float)(this.mirror ? -1 : 1) * x, y, z, pixelSize, pixelSize, pixelSize, 0.0f, 0.0f, 0.0f, this.mirror, this.textureWidth, this.textureHeight, hide, corners));
        } else {
            block16: for (Direction dir : Direction.values()) {
                for (Direction hideDir : hide) {
                    if (hideDir == dir) continue block16;
                }
                int uO = this.u;
                int vO = this.v;
                switch (dir) {
                    case DOWN: {
                        uO = (int)((float)uO - pixelSize);
                        break;
                    }
                    case UP: {
                        uO = (int)((float)uO - pixelSize * 2.0f);
                        break;
                    }
                    case NORTH: {
                        uO = (int)((float)uO - pixelSize);
                        vO = (int)((float)vO - pixelSize);
                        break;
                    }
                    case SOUTH: {
                        uO = (int)((float)uO - pixelSize * 3.0f);
                        vO = (int)((float)vO - pixelSize);
                        break;
                    }
                    case WEST: {
                        vO = (int)((float)vO - pixelSize);
                        break;
                    }
                    case EAST: {
                        uO = (int)((float)uO - pixelSize * 2.0f);
                        vO = (int)((float)vO - pixelSize);
                    }
                }
                class_5606 cubeList = class_5606.method_32108();
                class_2350 mcDir = switch (dir) {
                    default -> throw new MatchException(null, null);
                    case Direction.UP -> class_2350.field_11036;
                    case Direction.DOWN -> class_2350.field_11033;
                    case Direction.NORTH -> class_2350.field_11043;
                    case Direction.EAST -> {
                        if (SodiumWorkaround.applySodiumWorkaround()) {
                            yield class_2350.field_11039;
                        }
                        yield class_2350.field_11034;
                    }
                    case Direction.WEST -> {
                        if (SodiumWorkaround.applySodiumWorkaround()) {
                            yield class_2350.field_11034;
                        }
                        yield class_2350.field_11039;
                    }
                    case Direction.SOUTH -> class_2350.field_11035;
                };
                cubeList.method_32101(uO, vO).method_32106(this.mirror).method_49304(x, y, z, pixelSize, pixelSize, pixelSize, new HashSet<class_2350>(Arrays.asList(mcDir)));
                this.vanillaCubes.add(((class_5604)cubeList.method_32107().get(0)).method_32093(this.textureWidth, this.textureHeight));
            }
        }
        return this;
    }

    @Override
    public ModelBuilder addVanillaBox(float x, float y, float z, float width, float height, float depth) {
        if (this.mirror) {
            x = -1.0f;
        }
        this.vanillaCubes.add(SkinLayersAPI.getBoxBuilder().build(new BoxBuilder.BoxDefinition(this.u, this.v, this.mirror, x, y, z, width, height, depth, this.textureWidth, this.textureHeight)));
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getCubes().isEmpty() && this.getVanillaCubes().isEmpty();
    }
}

