/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.mixin;

import com.drmangotea.tfmg.content.decoration.tanks.aluminum.AluminumTankBlock;
import com.drmangotea.tfmg.content.decoration.tanks.cast_iron.CastIronTankBlock;
import com.drmangotea.tfmg.mixin.accessor.FluidTankBlockEntityAccessor;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidTankBlockEntity.class})
public class FluidTankBlockEntityMixin
extends SmartBlockEntity {
    @Shadow
    protected int height;
    @Shadow
    protected int width;
    @Shadow
    protected BlockPos controller;
    @Shadow
    protected boolean window;

    public FluidTankBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(at={@At(value="HEAD")}, method={"toggleWindows"}, cancellable=true, remap=false)
    public void toggleWindows(CallbackInfo ci) {
        FluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        be.setWindows(((FluidTankBlockEntityAccessor)be).tfmg$getWindow());
    }

    @Inject(at={@At(value="HEAD")}, method={"notifyMultiUpdated"}, cancellable=true, remap=false)
    public void notifyMultiUpdated(CallbackInfo ci) {
        BlockState state = this.m_58900_();
        if (AluminumTankBlock.isTank(state) || CastIronTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"removeController"}, cancellable=true, remap=false)
    public void removeController(boolean keepFluids, CallbackInfo ci) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        if (AluminumTankBlock.isTank(state) || CastIronTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)FluidTankBlock.SHAPE, (Comparable)(this.window ? FluidTankBlock.Shape.WINDOW : FluidTankBlock.Shape.PLAIN));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setWindows"}, cancellable=true, remap=false)
    public void setWindows(boolean window, CallbackInfo ci) {
        if (this.m_58900_().m_60713_((Block)TFMGBlocks.ALUMINUM_FLUID_TANK.get()) || this.m_58900_().m_60713_((Block)TFMGBlocks.CAST_IRON_FLUID_TANK.get())) {
            this.window = window;
            for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                        BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                        BlockState blockState = this.f_58857_.m_8055_(pos);
                        if (!AluminumTankBlock.isTank(blockState) && !CastIronTankBlock.isTank(blockState)) continue;
                        FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                        if (window) {
                            if (this.width == 1) {
                                shape = FluidTankBlock.Shape.WINDOW;
                            }
                            if (this.width == 2) {
                                FluidTankBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                            }
                            if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                                shape = FluidTankBlock.Shape.WINDOW;
                            }
                        }
                        this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_((Property)FluidTankBlock.SHAPE, (Comparable)shape), 22);
                        this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                    }
                }
            }
            return;
        }
    }

    @Shadow
    public FluidTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return (FluidTankBlockEntity)this.f_58857_.m_7702_(this.m_58899_());
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof FluidTankBlockEntity) {
            return (FluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    @Shadow
    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    @Shadow
    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    @Shadow
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN});
    }
}

