/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.diode;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPackets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class ElectricDiodeBlockEntity
extends VoltageAlteringBlockEntity {
    public boolean updateInFront = false;

    public ElectricDiodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getOutputVoltage() {
        return this.getData().getVoltage();
    }

    @Override
    public int getOutputPower() {
        return this.getPowerUsage();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    @Override
    public int getPowerUsage() {
        IElectric be;
        this.getOrCreateElectricNetwork().checkForLoops(this.m_58899_());
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            return Math.max(be.getNetworkPowerUsage(this), 0);
        }
        return 0;
    }

    @Override
    public IElectric getControlledBlock() {
        IElectric be;
        Direction facing = this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_) ? (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId()) {
            return be;
        }
        return null;
    }

    @Override
    public float resistance() {
        IElectric be;
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            return Math.max(be.getNetworkResistance(), 0);
        }
        return 0.0f;
    }

    public Direction getDirection() {
        if (!this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_)) {
            return ((Direction)this.m_58900_().m_61143_((Property)TFMGHorizontalDirectionalBlock.f_54117_)).m_122428_();
        }
        return (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return this.getDirection().m_122424_() == direction;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
        }
        this.sendStuff();
        this.m_6596_();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateInFront();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.updateInFront = true;
    }

    public void updateInFrontNextTick() {
        this.updateInFront = true;
    }

    public void updateInFront() {
        IElectric be;
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new UpdateInFrontPacket(BlockPos.m_122022_((long)this.getPos())));
        }
        Direction facing = this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_) ? (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.m_6596_();
    }

    public void updateBehind() {
        IElectric be;
        if (!this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new UpdateInFrontPacket(BlockPos.m_122022_((long)this.getPos())));
        }
        Direction facing = this.m_58900_().m_61138_((Property)DirectionalBlock.f_52588_) ? (Direction)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_) : ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122428_();
        facing = facing.m_122424_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.m_122424_())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.m_6596_();
    }
}

