/*
 * Decompiled with CFR 0.152.
 */
package dev.ninjdai.letsdocompat.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ninjdai.letsdocompat.Compat;
import dev.ninjdai.letsdocompat.DoAddonExpectPlatform;
import dev.ninjdai.letsdocompat.RecipeJsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Tuple;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    @Inject(method={"apply*"}, at={@At(value="HEAD")})
    public void interceptApply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller, CallbackInfo info) {
        HashMap<ResourceLocation, JsonObject> tMap = new HashMap<ResourceLocation, JsonObject>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            JsonObject jsonRecipe = entry.getValue().getAsJsonObject();
            if (!jsonRecipe.has("type")) continue;
            try {
                String recipeType = jsonRecipe.get("type").getAsString();
                if (!RecipeJsonUtil.RECIPE_CONVERSION_MAP.containsKey(recipeType)) continue;
                List<Tuple<String, RecipeJsonUtil.RecipeConvertor>> modConvertorTupleList = RecipeJsonUtil.RECIPE_CONVERSION_MAP.get(recipeType);
                for (Tuple<String, RecipeJsonUtil.RecipeConvertor> modConvertorTuple : modConvertorTupleList) {
                    JsonObject recipe;
                    if (!DoAddonExpectPlatform.isModLoaded((String)modConvertorTuple.m_14418_()) || (recipe = ((RecipeJsonUtil.RecipeConvertor)modConvertorTuple.m_14419_()).generate(jsonRecipe)) == null) continue;
                    tMap.put(new ResourceLocation("letsdocompat", (String)modConvertorTuple.m_14418_() + "/" + resourceLocation.m_135815_()), recipe);
                }
            }
            catch (Exception e) {
                Compat.LOGGER.error("Errored when converting recipes", (Throwable)e);
            }
        }
        map.putAll(tMap);
        Compat.LOGGER.info("Added {} compatibility recipes !", (Object)tMap.size());
    }
}

