/*
 * Decompiled with CFR 0.152.
 */
package dev.ninjdai.letsdocompat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.ninjdai.letsdocompat.Compat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;

public final class RecipeJsonUtil {
    public static final Map<String, List<Tuple<String, RecipeConvertor>>> RECIPE_CONVERSION_MAP = new HashMap<String, List<Tuple<String, RecipeConvertor>>>();
    public static final RecipeConvertor generateFDCookingPotFromLDCookingPot = jsonRecipe -> {
        JsonObject FDCookingPotRecipe = new JsonObject();
        FDCookingPotRecipe.add("type", (JsonElement)new JsonPrimitive("farmersdelight:cooking"));
        FDCookingPotRecipe.add("recipe_book_tab", (JsonElement)new JsonPrimitive("meals"));
        FDCookingPotRecipe.add("ingredients", (JsonElement)jsonRecipe.getAsJsonArray("ingredients"));
        try {
            JsonObject ldContainer = jsonRecipe.getAsJsonObject("container");
            if (ldContainer.get("required").getAsBoolean()) {
                FDCookingPotRecipe.add("container", ldContainer.get("item"));
            }
        }
        catch (Exception e) {
            Compat.LOGGER.error("Error while reading recipe container");
        }
        FDCookingPotRecipe.add("result", jsonRecipe.get("result"));
        return FDCookingPotRecipe;
    };
    public static final RecipeConvertor generateLDCookingPotFromFDCookingPot = jsonRecipe -> {
        JsonObject letsDoCookingPotRecipe = new JsonObject();
        letsDoCookingPotRecipe.add("type", (JsonElement)new JsonPrimitive("farm_and_charm:pot_cooking"));
        letsDoCookingPotRecipe.add("ingredients", (JsonElement)jsonRecipe.getAsJsonArray("ingredients"));
        if (jsonRecipe.has("container")) {
            JsonObject containerObject = new JsonObject();
            containerObject.add("required", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            containerObject.add("item", jsonRecipe.get("container"));
            letsDoCookingPotRecipe.add("container", (JsonElement)containerObject);
        } else {
            try {
                Item i = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(jsonRecipe.get("result").getAsJsonObject().get("item").getAsString()));
                if (i.m_41469_() == null) {
                    return null;
                }
                JsonObject container = new JsonObject();
                container.add("required", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                JsonObject itemObject = new JsonObject();
                itemObject.add("item", (JsonElement)new JsonPrimitive(i.m_41469_().arch$registryName().toString()));
                container.add("item", (JsonElement)itemObject);
                letsDoCookingPotRecipe.add("container", (JsonElement)container);
            }
            catch (Exception e) {
                Compat.LOGGER.error("Error getting item from Item Registry: {}", (Object)e.getMessage());
                return null;
            }
        }
        letsDoCookingPotRecipe.add("result", jsonRecipe.get("result"));
        letsDoCookingPotRecipe.add("requiresLearning", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        return letsDoCookingPotRecipe;
    };
    public static final RecipeConvertor generateCreateMixerFromFDBowl = jsonRecipe -> {
        JsonObject createMixerRecipe = new JsonObject();
        createMixerRecipe.add("type", (JsonElement)new JsonPrimitive("create:mixing"));
        createMixerRecipe.add("ingredients", (JsonElement)jsonRecipe.getAsJsonArray("ingredients"));
        JsonArray resultsArray = new JsonArray();
        resultsArray.add(jsonRecipe.get("result"));
        createMixerRecipe.add("results", (JsonElement)resultsArray);
        return createMixerRecipe;
    };
    public static final RecipeConvertor generateCreateMillingFromFDMincer = jsonRecipe -> {
        JsonObject createMillingRecipe = new JsonObject();
        createMillingRecipe.add("type", (JsonElement)new JsonPrimitive("create:milling"));
        createMillingRecipe.add("processingTime", (JsonElement)new JsonPrimitive((Number)90));
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add(jsonRecipe.get("ingredient"));
        createMillingRecipe.add("ingredients", (JsonElement)ingredientsArray);
        JsonArray resultsArray = new JsonArray();
        resultsArray.add(jsonRecipe.get("result"));
        createMillingRecipe.add("results", (JsonElement)resultsArray);
        return createMillingRecipe;
    };

    static {
        RECIPE_CONVERSION_MAP.put("farm_and_charm:pot_cooking", List.of(new Tuple((Object)"farmersdelight", (Object)generateFDCookingPotFromLDCookingPot)));
        RECIPE_CONVERSION_MAP.put("farmersdelight:cooking", List.of(new Tuple((Object)"farm_and_charm", (Object)generateLDCookingPotFromFDCookingPot)));
        RECIPE_CONVERSION_MAP.put("farm_and_charm:crafting_bowl", List.of(new Tuple((Object)"create", (Object)generateCreateMixerFromFDBowl)));
    }

    public static interface RecipeConvertor {
        public JsonObject generate(JsonObject var1);
    }
}

